/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.operator.JoinHashSupplier;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.PagesIndexOrdering;
import com.facebook.presto.operator.SimplePagesHashStrategy;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import com.facebook.presto.sql.gen.OrderingCompiler;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;

public class PagesIndex
implements Swapper {
    private static final Logger log = Logger.get(PagesIndex.class);
    private static final OrderingCompiler orderingCompiler = new OrderingCompiler();
    private static final JoinCompiler joinCompiler = new JoinCompiler();
    private final List<Type> types;
    private final LongArrayList valueAddresses;
    private final ObjectArrayList<Block>[] channels;
    private int nextBlockToCompact;
    private int positionCount;
    private long pagesMemorySize;
    private long estimatedSize;

    public PagesIndex(List<Type> types, int expectedPositions) {
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.valueAddresses = new LongArrayList(expectedPositions);
        this.channels = new ObjectArrayList[types.size()];
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = ObjectArrayList.wrap((Object[])new Block[1024], (int)0);
        }
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public LongArrayList getValueAddresses() {
        return this.valueAddresses;
    }

    public ObjectArrayList<Block> getChannel(int channel) {
        return this.channels[channel];
    }

    public void clear() {
        for (ObjectArrayList<Block> channel : this.channels) {
            channel.clear();
        }
        this.valueAddresses.clear();
        this.positionCount = 0;
        this.pagesMemorySize = 0L;
        this.estimatedSize = this.calculateEstimatedSize();
    }

    public void addPage(Page page) {
        if (page.getPositionCount() == 0) {
            return;
        }
        this.positionCount += page.getPositionCount();
        int pageIndex = this.channels.length > 0 ? this.channels[0].size() : 0;
        for (int i = 0; i < this.channels.length; ++i) {
            Block block = page.getBlock(i);
            this.channels[i].add((Object)block);
            this.pagesMemorySize += (long)block.getRetainedSizeInBytes();
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            long sliceAddress = SyntheticAddress.encodeSyntheticAddress(pageIndex, position);
            this.valueAddresses.add(sliceAddress);
        }
        this.estimatedSize = this.calculateEstimatedSize();
    }

    public DataSize getEstimatedSize() {
        return new DataSize((double)this.estimatedSize, DataSize.Unit.BYTE);
    }

    public void compact() {
        for (int channel = 0; channel < this.types.size(); ++channel) {
            ObjectArrayList<Block> blocks = this.channels[channel];
            for (int i = this.nextBlockToCompact; i < blocks.size(); ++i) {
                Block block = (Block)blocks.get(i);
                if (block.getSizeInBytes() >= block.getRetainedSizeInBytes()) continue;
                Block compactedBlock = block.copyRegion(0, block.getPositionCount());
                blocks.set(i, (Object)compactedBlock);
                this.pagesMemorySize -= (long)block.getRetainedSizeInBytes();
                this.pagesMemorySize += (long)compactedBlock.getRetainedSizeInBytes();
            }
        }
        this.nextBlockToCompact = this.channels[0].size();
        this.estimatedSize = this.calculateEstimatedSize();
    }

    private long calculateEstimatedSize() {
        long elementsSize = this.channels.length > 0 ? SizeOf.sizeOf((Object[])this.channels[0].elements()) : 0L;
        long channelsArraySize = elementsSize * (long)this.channels.length;
        long addressesArraySize = SizeOf.sizeOf((long[])this.valueAddresses.elements());
        return this.pagesMemorySize + channelsArraySize + addressesArraySize;
    }

    public Type getType(int channel) {
        return this.types.get(channel);
    }

    public void swap(int a, int b) {
        long[] elements = this.valueAddresses.elements();
        long temp = elements[a];
        elements[a] = elements[b];
        elements[b] = temp;
    }

    public int buildPage(int position, int[] outputChannels, PageBuilder pageBuilder) {
        while (!pageBuilder.isFull() && position < this.positionCount) {
            long pageAddress = this.valueAddresses.getLong(position);
            int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
            int blockPosition = SyntheticAddress.decodePosition(pageAddress);
            pageBuilder.declarePosition();
            for (int i = 0; i < outputChannels.length; ++i) {
                int outputChannel = outputChannels[i];
                Type type = this.types.get(outputChannel);
                Block block = (Block)this.channels[outputChannel].get(blockIndex);
                type.appendTo(block, blockPosition, pageBuilder.getBlockBuilder(i));
            }
            ++position;
        }
        return position;
    }

    public void appendTo(int channel, int position, BlockBuilder output) {
        long pageAddress = this.valueAddresses.getLong(position);
        Type type = this.types.get(channel);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        type.appendTo(block, blockPosition, output);
    }

    public boolean isNull(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return block.isNull(blockPosition);
    }

    public boolean getBoolean(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.types.get(channel).getBoolean(block, blockPosition);
    }

    public long getLong(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.types.get(channel).getLong(block, blockPosition);
    }

    public double getDouble(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.types.get(channel).getDouble(block, blockPosition);
    }

    public Slice getSlice(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.types.get(channel).getSlice(block, blockPosition);
    }

    public void sort(List<Integer> sortChannels, List<SortOrder> sortOrders) {
        this.sort(sortChannels, sortOrders, 0, this.getPositionCount());
    }

    public void sort(List<Integer> sortChannels, List<SortOrder> sortOrders, int startPosition, int endPosition) {
        this.createPagesIndexComparator(sortChannels, sortOrders).sort(this, startPosition, endPosition);
    }

    public boolean positionEqualsPosition(PagesHashStrategy partitionHashStrategy, int leftPosition, int rightPosition) {
        long leftAddress = this.valueAddresses.getLong(leftPosition);
        int leftPageIndex = SyntheticAddress.decodeSliceIndex(leftAddress);
        int leftPagePosition = SyntheticAddress.decodePosition(leftAddress);
        long rightAddress = this.valueAddresses.getLong(rightPosition);
        int rightPageIndex = SyntheticAddress.decodeSliceIndex(rightAddress);
        int rightPagePosition = SyntheticAddress.decodePosition(rightAddress);
        return partitionHashStrategy.positionEqualsPosition(leftPageIndex, leftPagePosition, rightPageIndex, rightPagePosition);
    }

    public boolean positionEqualsRow(PagesHashStrategy pagesHashStrategy, int indexPosition, int rightPosition, Page rightPage) {
        long pageAddress = this.valueAddresses.getLong(indexPosition);
        int pageIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int pagePosition = SyntheticAddress.decodePosition(pageAddress);
        return pagesHashStrategy.positionEqualsRow(pageIndex, pagePosition, rightPosition, rightPage);
    }

    private PagesIndexOrdering createPagesIndexComparator(List<Integer> sortChannels, List<SortOrder> sortOrders) {
        List sortTypes = (List)sortChannels.stream().map(this.types::get).collect(ImmutableCollectors.toImmutableList());
        return orderingCompiler.compilePagesIndexOrdering(sortTypes, sortChannels, sortOrders);
    }

    public Supplier<LookupSource> createLookupSourceSupplier(Session session, List<Integer> joinChannels) {
        return this.createLookupSourceSupplier(session, joinChannels, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public PagesHashStrategy createPagesHashStrategy(List<Integer> joinChannels, Optional<Integer> hashChannel) {
        return this.createPagesHashStrategy(joinChannels, hashChannel, Optional.empty());
    }

    public PagesHashStrategy createPagesHashStrategy(List<Integer> joinChannels, Optional<Integer> hashChannel, Optional<List<Integer>> outputChannels) {
        try {
            return joinCompiler.compilePagesHashStrategyFactory(this.types, joinChannels, outputChannels).createPagesHashStrategy((List<? extends List<Block>>)ImmutableList.copyOf((Object[])this.channels), hashChannel);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Lookup source compile failed for types=%s error=%s", new Object[]{this.types, e});
            return new SimplePagesHashStrategy(this.types, outputChannels.orElse(this.rangeList(this.types.size())), (List<List<Block>>)ImmutableList.copyOf((Object[])this.channels), joinChannels, hashChannel);
        }
    }

    public Supplier<LookupSource> createLookupSourceSupplier(Session session, List<Integer> joinChannels, Optional<Integer> hashChannel, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory) {
        return this.createLookupSourceSupplier(session, joinChannels, hashChannel, filterFunctionFactory, Optional.empty());
    }

    public Supplier<LookupSource> createLookupSourceSupplier(Session session, List<Integer> joinChannels, Optional<Integer> hashChannel, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, Optional<List<Integer>> outputChannels) {
        ImmutableList channels = ImmutableList.copyOf((Object[])this.channels);
        if (!joinChannels.isEmpty()) {
            try {
                JoinCompiler.LookupSourceSupplierFactory lookupSourceFactory = joinCompiler.compileLookupSourceFactory(this.types, joinChannels, outputChannels);
                return lookupSourceFactory.createLookupSourceSupplier(session.toConnectorSession(), this.valueAddresses, (List<List<Block>>)channels, hashChannel, filterFunctionFactory);
            }
            catch (Exception e) {
                log.error((Throwable)e, "Lookup source compile failed for types=%s error=%s", new Object[]{this.types, e});
            }
        }
        SimplePagesHashStrategy hashStrategy = new SimplePagesHashStrategy(this.types, outputChannels.orElse(this.rangeList(this.types.size())), (List<List<Block>>)channels, joinChannels, hashChannel);
        return new JoinHashSupplier(session.toConnectorSession(), hashStrategy, this.valueAddresses, (List<List<Block>>)channels, filterFunctionFactory);
    }

    private List<Integer> rangeList(int endExclusive) {
        return (List)IntStream.range(0, endExclusive).boxed().collect(ImmutableCollectors.toImmutableList());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("positionCount", this.positionCount).add("types", this.types).add("estimatedSize", this.estimatedSize).toString();
    }
}

