/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.JoinProbe;
import com.facebook.presto.operator.JoinProbeFactory;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class LookupJoinOperator
implements Operator,
Closeable {
    private final OperatorContext operatorContext;
    private final List<Type> types;
    private final ListenableFuture<? extends LookupSource> lookupSourceFuture;
    private final JoinProbeFactory joinProbeFactory;
    private final Runnable onClose;
    private final PageBuilder pageBuilder;
    private final boolean probeOnOuterSide;
    private LookupSource lookupSource;
    private JoinProbe probe;
    private boolean closed;
    private boolean finishing;
    private long joinPosition = -1L;

    public LookupJoinOperator(OperatorContext operatorContext, List<Type> types, LookupJoinOperators.JoinType joinType, ListenableFuture<LookupSource> lookupSourceFuture, JoinProbeFactory joinProbeFactory, Runnable onClose) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        Objects.requireNonNull(joinType, "joinType is null");
        this.probeOnOuterSide = joinType == LookupJoinOperators.JoinType.PROBE_OUTER || joinType == LookupJoinOperators.JoinType.FULL_OUTER;
        this.lookupSourceFuture = Objects.requireNonNull(lookupSourceFuture, "lookupSourceFuture is null");
        this.joinProbeFactory = Objects.requireNonNull(joinProbeFactory, "joinProbeFactory is null");
        this.onClose = Objects.requireNonNull(onClose, "onClose is null");
        this.pageBuilder = new PageBuilder(types);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        boolean finished;
        boolean bl = finished = this.finishing && this.probe == null && this.pageBuilder.isEmpty();
        if (finished) {
            this.close();
        }
        return finished;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.lookupSourceFuture;
    }

    @Override
    public boolean needsInput() {
        if (this.finishing) {
            return false;
        }
        if (this.lookupSource == null) {
            this.lookupSource = MoreFutures.tryGetFutureValue(this.lookupSourceFuture).orElse(null);
        }
        return this.lookupSource != null && this.probe == null;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is finishing");
        Preconditions.checkState((this.lookupSource != null ? 1 : 0) != 0, (Object)"Lookup source has not been built yet");
        Preconditions.checkState((this.probe == null ? 1 : 0) != 0, (Object)"Current page has not been completely processed yet");
        this.probe = this.joinProbeFactory.createJoinProbe(this.lookupSource, page);
        this.joinPosition = -1L;
    }

    @Override
    public Page getOutput() {
        if (this.lookupSource == null) {
            return null;
        }
        if (this.probe != null) {
            while (this.joinCurrentPosition() && this.advanceProbePosition() && this.outerJoinCurrentPosition()) {
            }
        }
        if (this.pageBuilder.isFull() || this.finishing && !this.pageBuilder.isEmpty() && this.probe == null) {
            Page page = this.pageBuilder.build();
            this.pageBuilder.reset();
            return page;
        }
        return null;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.probe = null;
        this.pageBuilder.reset();
        if (this.lookupSource != null) {
            this.lookupSource.close();
        }
        this.onClose.run();
    }

    private boolean joinCurrentPosition() {
        while (this.joinPosition >= 0L) {
            this.pageBuilder.declarePosition();
            this.probe.appendTo(this.pageBuilder);
            this.lookupSource.appendTo(this.joinPosition, this.pageBuilder, this.probe.getOutputChannelCount());
            this.joinPosition = this.lookupSource.getNextJoinPosition(this.joinPosition, this.probe.getPosition(), this.probe.getPage());
            if (!this.pageBuilder.isFull()) continue;
            return false;
        }
        return true;
    }

    private boolean advanceProbePosition() {
        if (!this.probe.advanceNextPosition()) {
            this.probe = null;
            return false;
        }
        this.joinPosition = this.probe.getCurrentJoinPosition();
        return true;
    }

    private boolean outerJoinCurrentPosition() {
        if (this.probeOnOuterSide && this.joinPosition < 0L) {
            this.pageBuilder.declarePosition();
            this.probe.appendTo(this.pageBuilder);
            int outputIndex = this.probe.getOutputChannelCount();
            for (int buildChannel = 0; buildChannel < this.lookupSource.getChannelCount(); ++buildChannel) {
                this.pageBuilder.getBlockBuilder(outputIndex).appendNull();
                ++outputIndex;
            }
            if (this.pageBuilder.isFull()) {
                return false;
            }
        }
        return true;
    }
}

