/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.operator.JoinHash;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.PagesHash;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class JoinHashSupplier
implements Supplier<LookupSource> {
    private final ConnectorSession session;
    private final PagesHash pagesHash;
    private final LongArrayList addresses;
    private final List<List<Block>> channels;
    private final Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory;

    public JoinHashSupplier(ConnectorSession session, PagesHashStrategy pagesHashStrategy, LongArrayList addresses, List<List<Block>> channels, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(pagesHashStrategy, "pagesHashStrategy is null");
        Objects.requireNonNull(addresses, "addresses is null");
        Objects.requireNonNull(channels, "channels is null");
        Objects.requireNonNull(filterFunctionFactory, "filterFunctionFactory is null");
        this.session = session;
        this.pagesHash = new PagesHash(addresses, pagesHashStrategy);
        this.addresses = addresses;
        this.channels = channels;
        this.filterFunctionFactory = filterFunctionFactory;
    }

    @Override
    public JoinHash get() {
        Optional<JoinFilterFunction> filterFunction = this.filterFunctionFactory.map(factory -> factory.create(this.session, this.addresses, this.channels));
        return new JoinHash(this.pagesHash, filterFunction);
    }
}

