/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.PagesHash;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class JoinHash
implements LookupSource {
    private final PagesHash pagesHash;
    @Nullable
    private final JoinFilterFunction filterFunction;

    public JoinHash(PagesHash pagesHash, Optional<JoinFilterFunction> filterFunction) {
        this.pagesHash = Objects.requireNonNull(pagesHash, "pagesHash is null");
        this.filterFunction = Objects.requireNonNull(filterFunction, "filterFunction can not be null").orElse(null);
    }

    @Override
    public final int getChannelCount() {
        return this.pagesHash.getChannelCount();
    }

    @Override
    public int getJoinPositionCount() {
        return this.pagesHash.getPositionCount();
    }

    @Override
    public long getInMemorySizeInBytes() {
        return this.pagesHash.getInMemorySizeInBytes();
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage) {
        int addressIndex = this.pagesHash.getAddressIndex(position, hashChannelsPage, allChannelsPage);
        if (addressIndex == -1) {
            return -1L;
        }
        return this.getNextJoinPositionFrom(addressIndex, position, allChannelsPage);
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage, long rawHash) {
        int addressIndex = this.pagesHash.getAddressIndex(position, hashChannelsPage, allChannelsPage, rawHash);
        if (addressIndex == -1) {
            return -1L;
        }
        return this.getNextJoinPositionFrom(addressIndex, position, allChannelsPage);
    }

    @Override
    public final long getNextJoinPosition(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        int nextAddressIndex = this.pagesHash.getNextAddressIndex(Math.toIntExact(currentJoinPosition));
        return this.getNextJoinPositionFrom(nextAddressIndex, probePosition, allProbeChannelsPage);
    }

    private int getNextJoinPositionFrom(int currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        while (this.filterFunction != null && currentJoinPosition != -1 && !this.filterFunction.filter(currentJoinPosition, probePosition, allProbeChannelsPage)) {
            currentJoinPosition = this.pagesHash.getNextAddressIndex(currentJoinPosition);
        }
        return currentJoinPosition;
    }

    @Override
    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        this.pagesHash.appendTo(Math.toIntExact(position), pageBuilder, outputChannelOffset);
    }

    @Override
    public void close() {
    }
}

