/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.PrestoMediaTypes;
import com.facebook.presto.block.PagesSerde;
import com.facebook.presto.operator.PageBufferClientStatus;
import com.facebook.presto.operator.PageTooLargeException;
import com.facebook.presto.operator.PageTransportErrorException;
import com.facebook.presto.operator.PageTransportTimeoutException;
import com.facebook.presto.server.remotetask.Backoff;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.ResponseHandlerUtils;
import io.airlift.http.client.ResponseTooLargeException;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.log.Logger;
import io.airlift.slice.InputStreamSliceInput;
import io.airlift.slice.SliceInput;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public final class HttpPageBufferClient
implements Closeable {
    private static final Logger log = Logger.get(HttpPageBufferClient.class);
    private final HttpClient httpClient;
    private final DataSize maxResponseSize;
    private final URI location;
    private final ClientCallback clientCallback;
    private final BlockEncodingSerde blockEncodingSerde;
    private final ScheduledExecutorService executor;
    private final Backoff backoff;
    @GuardedBy(value="this")
    private boolean closed;
    @GuardedBy(value="this")
    private HttpClient.HttpResponseFuture<?> future;
    @GuardedBy(value="this")
    private DateTime lastUpdate = DateTime.now();
    @GuardedBy(value="this")
    private long token;
    @GuardedBy(value="this")
    private boolean scheduled;
    @GuardedBy(value="this")
    private boolean completed;
    @GuardedBy(value="this")
    private String taskInstanceId;
    private final AtomicLong rowsReceived = new AtomicLong();
    private final AtomicInteger pagesReceived = new AtomicInteger();
    private final AtomicLong rowsRejected = new AtomicLong();
    private final AtomicInteger pagesRejected = new AtomicInteger();
    private final AtomicInteger requestsScheduled = new AtomicInteger();
    private final AtomicInteger requestsCompleted = new AtomicInteger();
    private final AtomicInteger requestsFailed = new AtomicInteger();

    public HttpPageBufferClient(HttpClient httpClient, DataSize maxResponseSize, Duration minErrorDuration, Duration maxErrorDuration, URI location, ClientCallback clientCallback, BlockEncodingSerde blockEncodingSerde, ScheduledExecutorService executor) {
        this(httpClient, maxResponseSize, minErrorDuration, maxErrorDuration, location, clientCallback, blockEncodingSerde, executor, Ticker.systemTicker());
    }

    public HttpPageBufferClient(HttpClient httpClient, DataSize maxResponseSize, Duration minErrorDuration, Duration maxErrorDuration, URI location, ClientCallback clientCallback, BlockEncodingSerde blockEncodingSerde, ScheduledExecutorService executor, Ticker ticker) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.maxResponseSize = Objects.requireNonNull(maxResponseSize, "maxResponseSize is null");
        this.location = Objects.requireNonNull(location, "location is null");
        this.clientCallback = Objects.requireNonNull(clientCallback, "clientCallback is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingManager is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(minErrorDuration, "minErrorDuration is null");
        Objects.requireNonNull(maxErrorDuration, "maxErrorDuration is null");
        Objects.requireNonNull(ticker, "ticker is null");
        this.backoff = new Backoff(minErrorDuration, maxErrorDuration, ticker, new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(50.0, TimeUnit.MILLISECONDS), new Duration(100.0, TimeUnit.MILLISECONDS), new Duration(200.0, TimeUnit.MILLISECONDS), new Duration(500.0, TimeUnit.MILLISECONDS));
    }

    public synchronized PageBufferClientStatus getStatus() {
        String state = this.closed ? "closed" : (this.future != null ? "running" : (this.scheduled ? "scheduled" : (this.completed ? "completed" : "queued")));
        String httpRequestState = "not scheduled";
        if (this.future != null) {
            httpRequestState = this.future.getState();
        }
        long rejectedRows = this.rowsRejected.get();
        int rejectedPages = this.pagesRejected.get();
        return new PageBufferClientStatus(this.location, state, this.lastUpdate, this.rowsReceived.get(), this.pagesReceived.get(), rejectedRows == 0L ? OptionalLong.empty() : OptionalLong.of(rejectedRows), rejectedPages == 0 ? OptionalInt.empty() : OptionalInt.of(rejectedPages), this.requestsScheduled.get(), this.requestsCompleted.get(), this.requestsFailed.get(), httpRequestState);
    }

    public synchronized boolean isRunning() {
        return this.future != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HttpClient.HttpResponseFuture<?> future;
        boolean shouldSendDelete;
        HttpPageBufferClient httpPageBufferClient = this;
        synchronized (httpPageBufferClient) {
            shouldSendDelete = !this.closed;
            this.closed = true;
            future = this.future;
            this.future = null;
            this.lastUpdate = DateTime.now();
        }
        if (future != null && !future.isDone()) {
            future.cancel(true);
        }
        if (shouldSendDelete) {
            this.sendDelete();
        }
    }

    public synchronized void scheduleRequest() {
        if (this.closed || this.future != null || this.scheduled) {
            return;
        }
        this.scheduled = true;
        this.backoff.startRequest();
        long delayNanos = this.backoff.getBackoffDelayNanos();
        this.executor.schedule(() -> {
            try {
                this.initiateRequest();
            }
            catch (Throwable t) {
                this.clientCallback.clientFailed(this, t);
            }
        }, delayNanos, TimeUnit.NANOSECONDS);
        this.lastUpdate = DateTime.now();
        this.requestsScheduled.incrementAndGet();
    }

    private synchronized void initiateRequest() {
        this.scheduled = false;
        if (this.closed || this.future != null) {
            return;
        }
        if (this.completed) {
            this.sendDelete();
        } else {
            this.sendGetResults();
        }
        this.lastUpdate = DateTime.now();
    }

    private synchronized void sendGetResults() {
        HttpClient.HttpResponseFuture resultFuture;
        final URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.location).appendPath(String.valueOf(this.token)).build();
        this.future = resultFuture = this.httpClient.executeAsync(Request.Builder.prepareGet().setHeader("X-Presto-Max-Size", this.maxResponseSize.toString()).setUri(uri).build(), (ResponseHandler)new PageResponseHandler(this.blockEncodingSerde));
        Futures.addCallback((ListenableFuture)resultFuture, (FutureCallback)new FutureCallback<PagesResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(PagesResponse result) {
                Object pages;
                HttpPageBufferClient httpPageBufferClient;
                HttpPageBufferClient.this.checkNotHoldsLock();
                HttpPageBufferClient.this.backoff.success();
                try {
                    httpPageBufferClient = HttpPageBufferClient.this;
                    synchronized (httpPageBufferClient) {
                        if (HttpPageBufferClient.this.taskInstanceId == null) {
                            HttpPageBufferClient.this.taskInstanceId = result.getTaskInstanceId();
                        }
                        if (!Strings.isNullOrEmpty((String)HttpPageBufferClient.this.taskInstanceId) && !result.getTaskInstanceId().equals(HttpPageBufferClient.this.taskInstanceId)) {
                            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_MISMATCH, String.format("%s (%s)", "Could not communicate with the remote task. The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.", HostAddress.fromUri((URI)uri)));
                        }
                        if (result.getToken() == HttpPageBufferClient.this.token) {
                            pages = result.getPages();
                            HttpPageBufferClient.this.token = result.getNextToken();
                        } else {
                            pages = ImmutableList.of();
                        }
                    }
                }
                catch (PrestoException e) {
                    HttpPageBufferClient.this.handleFailure(e, resultFuture);
                    return;
                }
                if (HttpPageBufferClient.this.clientCallback.addPages(HttpPageBufferClient.this, (List<Page>)pages)) {
                    HttpPageBufferClient.this.pagesReceived.addAndGet(pages.size());
                    HttpPageBufferClient.this.rowsReceived.addAndGet(pages.stream().mapToLong(Page::getPositionCount).sum());
                } else {
                    HttpPageBufferClient.this.pagesRejected.addAndGet(pages.size());
                    HttpPageBufferClient.this.rowsRejected.addAndGet(pages.stream().mapToLong(Page::getPositionCount).sum());
                }
                httpPageBufferClient = HttpPageBufferClient.this;
                synchronized (httpPageBufferClient) {
                    if (result.isClientComplete()) {
                        HttpPageBufferClient.this.completed = true;
                    }
                    if (HttpPageBufferClient.this.future == resultFuture) {
                        HttpPageBufferClient.this.future = null;
                    }
                    HttpPageBufferClient.this.lastUpdate = DateTime.now();
                }
                HttpPageBufferClient.this.requestsCompleted.incrementAndGet();
                HttpPageBufferClient.this.clientCallback.requestComplete(HttpPageBufferClient.this);
            }

            public void onFailure(Throwable t) {
                log.debug("Request to %s failed %s", new Object[]{uri, t});
                HttpPageBufferClient.this.checkNotHoldsLock();
                t = HttpPageBufferClient.rewriteException(t);
                if (!(t instanceof PrestoException) && HttpPageBufferClient.this.backoff.failure()) {
                    String message = String.format("%s (%s - %s failures, time since last success %s)", "Encountered too many errors talking to a worker node. The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.", uri, HttpPageBufferClient.this.backoff.getFailureCount(), HttpPageBufferClient.this.backoff.getTimeSinceLastSuccess().convertTo(TimeUnit.SECONDS));
                    t = new PageTransportTimeoutException(message, (Throwable)t);
                }
                HttpPageBufferClient.this.handleFailure(t, resultFuture);
            }
        }, (Executor)this.executor);
    }

    private synchronized void sendDelete() {
        HttpClient.HttpResponseFuture resultFuture;
        this.future = resultFuture = this.httpClient.executeAsync(Request.Builder.prepareDelete().setUri(this.location).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Futures.addCallback((ListenableFuture)resultFuture, (FutureCallback)new FutureCallback<StatusResponseHandler.StatusResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(@Nullable StatusResponseHandler.StatusResponse result) {
                HttpPageBufferClient.this.checkNotHoldsLock();
                HttpPageBufferClient.this.backoff.success();
                HttpPageBufferClient httpPageBufferClient = HttpPageBufferClient.this;
                synchronized (httpPageBufferClient) {
                    HttpPageBufferClient.this.closed = true;
                    if (HttpPageBufferClient.this.future == resultFuture) {
                        HttpPageBufferClient.this.future = null;
                    }
                    HttpPageBufferClient.this.lastUpdate = DateTime.now();
                }
                HttpPageBufferClient.this.requestsCompleted.incrementAndGet();
                HttpPageBufferClient.this.clientCallback.clientFinished(HttpPageBufferClient.this);
            }

            public void onFailure(Throwable t) {
                HttpPageBufferClient.this.checkNotHoldsLock();
                log.error("Request to delete %s failed %s", new Object[]{HttpPageBufferClient.this.location, t});
                if (!(t instanceof PrestoException) && HttpPageBufferClient.this.backoff.failure()) {
                    String message = String.format("Error closing remote buffer (%s - %s failures, time since last success %s)", HttpPageBufferClient.this.location, HttpPageBufferClient.this.backoff.getFailureCount(), HttpPageBufferClient.this.backoff.getTimeSinceLastSuccess().convertTo(TimeUnit.SECONDS));
                    t = new PrestoException((ErrorCodeSupplier)StandardErrorCode.REMOTE_BUFFER_CLOSE_FAILED, message, t);
                }
                HttpPageBufferClient.this.handleFailure(t, resultFuture);
            }
        }, (Executor)this.executor);
    }

    private void checkNotHoldsLock() {
        if (Thread.holdsLock(this)) {
            log.error("Can not handle callback while holding a lock on this");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFailure(Throwable t, HttpClient.HttpResponseFuture<?> expectedFuture) {
        this.checkNotHoldsLock();
        this.requestsFailed.incrementAndGet();
        this.requestsCompleted.incrementAndGet();
        if (t instanceof PrestoException) {
            this.clientCallback.clientFailed(this, t);
        }
        HttpPageBufferClient httpPageBufferClient = this;
        synchronized (httpPageBufferClient) {
            if (this.future == expectedFuture) {
                this.future = null;
            }
            this.lastUpdate = DateTime.now();
        }
        this.clientCallback.requestComplete(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpPageBufferClient that = (HttpPageBufferClient)o;
        return this.location.equals(that.location);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String state;
        HttpPageBufferClient httpPageBufferClient = this;
        synchronized (httpPageBufferClient) {
            state = this.closed ? "CLOSED" : (this.future != null ? "RUNNING" : "QUEUED");
        }
        return MoreObjects.toStringHelper((Object)this).add("location", (Object)this.location).addValue((Object)state).toString();
    }

    private static Throwable rewriteException(Throwable t) {
        if (t instanceof ResponseTooLargeException) {
            return new PageTooLargeException();
        }
        return t;
    }

    public static class PagesResponse {
        private final String taskInstanceId;
        private final long token;
        private final long nextToken;
        private final List<Page> pages;
        private final boolean clientComplete;

        public static PagesResponse createPagesResponse(String taskInstanceId, long token, long nextToken, Iterable<Page> pages, boolean complete) {
            return new PagesResponse(taskInstanceId, token, nextToken, pages, complete);
        }

        public static PagesResponse createEmptyPagesResponse(String taskInstanceId, long token, long nextToken, boolean complete) {
            return new PagesResponse(taskInstanceId, token, nextToken, (Iterable<Page>)ImmutableList.of(), complete);
        }

        private PagesResponse(String taskInstanceId, long token, long nextToken, Iterable<Page> pages, boolean clientComplete) {
            this.taskInstanceId = taskInstanceId;
            this.token = token;
            this.nextToken = nextToken;
            this.pages = ImmutableList.copyOf(pages);
            this.clientComplete = clientComplete;
        }

        public long getToken() {
            return this.token;
        }

        public long getNextToken() {
            return this.nextToken;
        }

        public List<Page> getPages() {
            return this.pages;
        }

        public boolean isClientComplete() {
            return this.clientComplete;
        }

        public String getTaskInstanceId() {
            return this.taskInstanceId;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("token", this.token).add("nextToken", this.nextToken).add("pagesSize", this.pages.size()).add("clientComplete", this.clientComplete).toString();
        }
    }

    public static class PageResponseHandler
    implements ResponseHandler<PagesResponse, RuntimeException> {
        private final BlockEncodingSerde blockEncodingSerde;

        public PageResponseHandler(BlockEncodingSerde blockEncodingSerde) {
            this.blockEncodingSerde = blockEncodingSerde;
        }

        public PagesResponse handleException(Request request, Exception exception) {
            throw ResponseHandlerUtils.propagate((Request)request, (Throwable)exception);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public PagesResponse handle(Request request, Response response) {
            try {
                if (response.getStatusCode() == HttpStatus.NO_CONTENT.code()) {
                    return PagesResponse.createEmptyPagesResponse(PageResponseHandler.getTaskInstanceId(response), PageResponseHandler.getToken(response), PageResponseHandler.getNextToken(response), PageResponseHandler.getComplete(response));
                }
                if (response.getStatusCode() != HttpStatus.OK.code()) {
                    StringBuilder body = new StringBuilder();
                    try (BufferedReader reader2 = new BufferedReader(new InputStreamReader(response.getInputStream()));){
                        String line;
                        for (int i = 0; i < 1000 && (line = reader2.readLine()) != null && body.length() + line.length() <= 102400; ++i) {
                            body.append(line + "\n");
                        }
                        throw new PageTransportErrorException(String.format("Expected response code to be 200, but was %s %s:%n%s", response.getStatusCode(), response.getStatusMessage(), body.toString()));
                    }
                    catch (IOException | RuntimeException reader2) {
                        // empty catch block
                    }
                    throw new PageTransportErrorException(String.format("Expected response code to be 200, but was %s %s:%n%s", response.getStatusCode(), response.getStatusMessage(), body.toString()));
                }
                String contentType = response.getHeader("Content-Type");
                if (contentType == null) {
                    throw new PageTransportErrorException(String.format("%s header is not set: %s", "Content-Type", response));
                }
                if (!PageResponseHandler.mediaTypeMatches(contentType, PrestoMediaTypes.PRESTO_PAGES_TYPE)) {
                    throw new PageTransportErrorException(String.format("Expected %s response from server but got %s", PrestoMediaTypes.PRESTO_PAGES_TYPE, contentType));
                }
                String taskInstanceId = PageResponseHandler.getTaskInstanceId(response);
                long token = PageResponseHandler.getToken(response);
                long nextToken = PageResponseHandler.getNextToken(response);
                boolean complete = PageResponseHandler.getComplete(response);
                try (InputStreamSliceInput input = new InputStreamSliceInput(response.getInputStream());){
                    ImmutableList pages = ImmutableList.copyOf(PagesSerde.readPages(this.blockEncodingSerde, (SliceInput)input));
                    PagesResponse pagesResponse = PagesResponse.createPagesResponse(taskInstanceId, token, nextToken, (Iterable<Page>)pages, complete);
                    return pagesResponse;
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            catch (PageTransportErrorException e) {
                throw new PageTransportErrorException(String.format("Error fetching %s: %s", request.getUri().toASCIIString(), e.getMessage()), (Throwable)((Object)e));
            }
        }

        private static String getTaskInstanceId(Response response) {
            String taskInstanceId = response.getHeader("X-Presto-Task-Instance-Id");
            if (taskInstanceId == null) {
                throw new PageTransportErrorException(String.format("Expected %s header", "X-Presto-Task-Instance-Id"));
            }
            return taskInstanceId;
        }

        private static long getToken(Response response) {
            String tokenHeader = response.getHeader("X-Presto-Page-Sequence-Id");
            if (tokenHeader == null) {
                throw new PageTransportErrorException(String.format("Expected %s header", "X-Presto-Page-Sequence-Id"));
            }
            return Long.parseLong(tokenHeader);
        }

        private static long getNextToken(Response response) {
            String nextTokenHeader = response.getHeader("X-Presto-Page-End-Sequence-Id");
            if (nextTokenHeader == null) {
                throw new PageTransportErrorException(String.format("Expected %s header", "X-Presto-Page-End-Sequence-Id"));
            }
            return Long.parseLong(nextTokenHeader);
        }

        private static boolean getComplete(Response response) {
            String bufferComplete = response.getHeader("X-Presto-Buffer-Complete");
            if (bufferComplete == null) {
                throw new PageTransportErrorException(String.format("Expected %s header", "X-Presto-Buffer-Complete"));
            }
            return Boolean.parseBoolean(bufferComplete);
        }

        private static boolean mediaTypeMatches(String value, MediaType range) {
            try {
                return MediaType.parse((String)value).is(range);
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                return false;
            }
        }
    }

    public static interface ClientCallback {
        public boolean addPages(HttpPageBufferClient var1, List<Page> var2);

        public void requestComplete(HttpPageBufferClient var1);

        public void clientFinished(HttpPageBufferClient var1);

        public void clientFailed(HttpPageBufferClient var1, Throwable var2);
    }
}

