/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.SystemMemoryUsageListener;
import com.facebook.presto.execution.buffer.BufferInfo;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.ClientBuffer;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.OutputBufferInfo;
import com.facebook.presto.execution.buffer.OutputBufferMemoryManager;
import com.facebook.presto.execution.buffer.PageBufferInfo;
import com.facebook.presto.execution.buffer.PageSplitterUtil;
import com.facebook.presto.spi.Page;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

public class PartitionedOutputBuffer
implements OutputBuffer {
    private final StateMachine<BufferState> state;
    private final OutputBuffers outputBuffers;
    private final OutputBufferMemoryManager memoryManager;
    private final List<ClientBuffer> partitions;
    private final AtomicLong totalPagesAdded = new AtomicLong();
    private final AtomicLong totalRowsAdded = new AtomicLong();

    public PartitionedOutputBuffer(String taskInstanceId, StateMachine<BufferState> state, OutputBuffers outputBuffers, DataSize maxBufferSize, SystemMemoryUsageListener systemMemoryUsageListener, Executor notificationExecutor) {
        this.state = Objects.requireNonNull(state, "state is null");
        Objects.requireNonNull(outputBuffers, "outputBuffers is null");
        Preconditions.checkArgument((outputBuffers.getType() == OutputBuffers.BufferType.PARTITIONED ? 1 : 0) != 0, (Object)"Expected a PARTITIONED output buffer descriptor");
        Preconditions.checkArgument((boolean)outputBuffers.isNoMoreBufferIds(), (Object)"Expected a final output buffer descriptor");
        this.outputBuffers = outputBuffers;
        this.memoryManager = new OutputBufferMemoryManager(Objects.requireNonNull(maxBufferSize, "maxBufferSize is null").toBytes(), Objects.requireNonNull(systemMemoryUsageListener, "systemMemoryUsageListener is null"), Objects.requireNonNull(notificationExecutor, "notificationExecutor is null"));
        ImmutableList.Builder partitions = ImmutableList.builder();
        for (OutputBuffers.OutputBufferId bufferId : outputBuffers.getBuffers().keySet()) {
            ClientBuffer partition = new ClientBuffer(taskInstanceId, bufferId);
            partitions.add((Object)partition);
        }
        this.partitions = partitions.build();
        state.compareAndSet(BufferState.OPEN, BufferState.NO_MORE_BUFFERS);
        state.compareAndSet(BufferState.NO_MORE_PAGES, BufferState.FLUSHING);
        this.checkFlushComplete();
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<BufferState> stateChangeListener) {
        this.state.addStateChangeListener(stateChangeListener);
    }

    @Override
    public boolean isFinished() {
        return this.state.get() == BufferState.FINISHED;
    }

    @Override
    public double getUtilization() {
        return this.memoryManager.getUtilization();
    }

    @Override
    public OutputBufferInfo getInfo() {
        BufferState state = this.state.get();
        int totalBufferedBytes = 0;
        int totalBufferedPages = 0;
        ImmutableList.Builder infos = ImmutableList.builder();
        for (ClientBuffer partition : this.partitions) {
            BufferInfo bufferInfo = partition.getInfo();
            infos.add((Object)bufferInfo);
            PageBufferInfo pageBufferInfo = bufferInfo.getPageBufferInfo();
            totalBufferedPages = (int)((long)totalBufferedPages + pageBufferInfo.getBufferedPages());
            totalBufferedBytes = (int)((long)totalBufferedBytes + pageBufferInfo.getBufferedBytes());
        }
        return new OutputBufferInfo("PARTITIONED", state, state.canAddBuffers(), state.canAddPages(), totalBufferedBytes, totalBufferedPages, this.totalRowsAdded.get(), this.totalPagesAdded.get(), (List<BufferInfo>)infos.build());
    }

    @Override
    public void setOutputBuffers(OutputBuffers newOutputBuffers) {
        Objects.requireNonNull(newOutputBuffers, "newOutputBuffers is null");
        if (this.state.get().isTerminal() || this.outputBuffers.getVersion() >= newOutputBuffers.getVersion()) {
            return;
        }
        this.outputBuffers.checkValidTransition(newOutputBuffers);
    }

    @Override
    public ListenableFuture<?> enqueue(Page page) {
        Preconditions.checkState((this.partitions.size() == 1 ? 1 : 0) != 0, (Object)"Expected exactly one partition");
        return this.enqueue(0, page);
    }

    @Override
    public ListenableFuture<?> enqueue(int partitionNumber, Page page) {
        Objects.requireNonNull(page, "page is null");
        if (!this.state.get().canAddPages()) {
            return Futures.immediateFuture((Object)true);
        }
        List<Page> pages = PageSplitterUtil.splitPage(page, 0x100000L);
        long bytesAdded = pages.stream().mapToLong(Page::getRetainedSizeInBytes).sum();
        this.memoryManager.updateMemoryUsage(bytesAdded);
        long rowCount = pages.stream().mapToLong(Page::getPositionCount).sum();
        Preconditions.checkState((rowCount == (long)page.getPositionCount() ? 1 : 0) != 0);
        this.totalRowsAdded.addAndGet(rowCount);
        this.totalPagesAdded.addAndGet(pages.size());
        List pageReferences = (List)pages.stream().map(pageSplit -> new ClientBuffer.PageReference((Page)pageSplit, 1, () -> this.memoryManager.updateMemoryUsage(-pageSplit.getRetainedSizeInBytes()))).collect(ImmutableCollectors.toImmutableList());
        this.partitions.get(partitionNumber).enqueuePages(pageReferences);
        pageReferences.forEach(ClientBuffer.PageReference::dereferencePage);
        return this.memoryManager.getNotFullFuture();
    }

    @Override
    public CompletableFuture<BufferResult> get(OutputBuffers.OutputBufferId outputBufferId, long startingSequenceId, DataSize maxSize) {
        Objects.requireNonNull(outputBufferId, "outputBufferId is null");
        Preconditions.checkArgument((maxSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxSize must be at least 1 byte");
        return this.partitions.get(outputBufferId.getId()).getPages(startingSequenceId, maxSize);
    }

    @Override
    public void abort(OutputBuffers.OutputBufferId bufferId) {
        Objects.requireNonNull(bufferId, "bufferId is null");
        this.partitions.get(bufferId.getId()).destroy();
        this.checkFlushComplete();
    }

    @Override
    public void setNoMorePages() {
        this.state.compareAndSet(BufferState.OPEN, BufferState.NO_MORE_PAGES);
        this.state.compareAndSet(BufferState.NO_MORE_BUFFERS, BufferState.FLUSHING);
        this.memoryManager.setNoBlockOnFull();
        this.partitions.forEach(ClientBuffer::setNoMorePages);
        this.checkFlushComplete();
    }

    @Override
    public void destroy() {
        if (this.state.setIf(BufferState.FINISHED, oldState -> !oldState.isTerminal())) {
            this.partitions.forEach(ClientBuffer::destroy);
            this.memoryManager.setNoBlockOnFull();
        }
    }

    @Override
    public void fail() {
        if (this.state.setIf(BufferState.FAILED, oldState -> !oldState.isTerminal())) {
            this.memoryManager.setNoBlockOnFull();
        }
    }

    private void checkFlushComplete() {
        if (this.state.get() != BufferState.FLUSHING) {
            return;
        }
        for (ClientBuffer partition : this.partitions) {
            if (partition.isDestroyed()) continue;
            return;
        }
        this.destroy();
    }
}

