/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.SystemMemoryUsageListener;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.ClientBuffer;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.OutputBufferInfo;
import com.facebook.presto.execution.buffer.OutputBufferMemoryManager;
import com.facebook.presto.execution.buffer.PageSplitterUtil;
import com.facebook.presto.spi.Page;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;

public class BroadcastOutputBuffer
implements OutputBuffer {
    private final String taskInstanceId;
    private final StateMachine<BufferState> state;
    private final OutputBufferMemoryManager memoryManager;
    @GuardedBy(value="this")
    private OutputBuffers outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers(OutputBuffers.BufferType.BROADCAST);
    @GuardedBy(value="this")
    private final Map<OutputBuffers.OutputBufferId, ClientBuffer> buffers = new ConcurrentHashMap<OutputBuffers.OutputBufferId, ClientBuffer>();
    @GuardedBy(value="this")
    private final List<ClientBuffer.PageReference> initialPagesForNewBuffers = new ArrayList<ClientBuffer.PageReference>();
    private final AtomicLong totalPagesAdded = new AtomicLong();
    private final AtomicLong totalRowsAdded = new AtomicLong();
    private final AtomicLong totalBufferedPages = new AtomicLong();

    public BroadcastOutputBuffer(String taskInstanceId, StateMachine<BufferState> state, DataSize maxBufferSize, SystemMemoryUsageListener systemMemoryUsageListener, Executor notificationExecutor) {
        this.taskInstanceId = Objects.requireNonNull(taskInstanceId, "taskInstanceId is null");
        this.state = Objects.requireNonNull(state, "state is null");
        this.memoryManager = new OutputBufferMemoryManager(Objects.requireNonNull(maxBufferSize, "maxBufferSize is null").toBytes(), Objects.requireNonNull(systemMemoryUsageListener, "systemMemoryUsageListener is null"), Objects.requireNonNull(notificationExecutor, "notificationExecutor is null"));
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<BufferState> stateChangeListener) {
        this.state.addStateChangeListener(stateChangeListener);
    }

    @Override
    public boolean isFinished() {
        return this.state.get() == BufferState.FINISHED;
    }

    @Override
    public double getUtilization() {
        return this.memoryManager.getUtilization();
    }

    @Override
    public OutputBufferInfo getInfo() {
        BufferState state = this.state.get();
        Collection<ClientBuffer> buffers = this.buffers.values();
        return new OutputBufferInfo("BROADCAST", state, state.canAddBuffers(), state.canAddPages(), this.memoryManager.getBufferedBytes(), this.totalBufferedPages.get(), this.totalRowsAdded.get(), this.totalPagesAdded.get(), (List)buffers.stream().map(ClientBuffer::getInfo).collect(ImmutableCollectors.toImmutableList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOutputBuffers(OutputBuffers newOutputBuffers) {
        Objects.requireNonNull(newOutputBuffers, "newOutputBuffers is null");
        BroadcastOutputBuffer broadcastOutputBuffer = this;
        synchronized (broadcastOutputBuffer) {
            BufferState state = this.state.get();
            if (state.isTerminal() || this.outputBuffers.getVersion() >= newOutputBuffers.getVersion()) {
                return;
            }
            this.outputBuffers.checkValidTransition(newOutputBuffers);
            this.outputBuffers = newOutputBuffers;
            for (Map.Entry<OutputBuffers.OutputBufferId, Integer> entry : this.outputBuffers.getBuffers().entrySet()) {
                if (this.buffers.containsKey(entry.getKey())) continue;
                ClientBuffer buffer = this.getBuffer(entry.getKey());
                if (state.canAddPages()) continue;
                buffer.setNoMorePages();
            }
            if (this.outputBuffers.isNoMoreBufferIds()) {
                this.state.compareAndSet(BufferState.OPEN, BufferState.NO_MORE_BUFFERS);
                this.state.compareAndSet(BufferState.NO_MORE_PAGES, BufferState.FLUSHING);
            }
        }
        if (!this.state.get().canAddBuffers()) {
            this.noMoreBuffers();
        }
        this.checkFlushComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<?> enqueue(Page page) {
        Collection<ClientBuffer> buffers;
        Objects.requireNonNull(page, "page is null");
        if (!this.state.get().canAddPages()) {
            return Futures.immediateFuture((Object)true);
        }
        List<Page> pages = PageSplitterUtil.splitPage(page, 0x100000L);
        long bytesAdded = pages.stream().mapToLong(Page::getRetainedSizeInBytes).sum();
        this.memoryManager.updateMemoryUsage(bytesAdded);
        long rowCount = pages.stream().mapToLong(Page::getPositionCount).sum();
        Preconditions.checkState((rowCount == (long)page.getPositionCount() ? 1 : 0) != 0);
        this.totalRowsAdded.addAndGet(rowCount);
        this.totalPagesAdded.addAndGet(pages.size());
        this.totalBufferedPages.addAndGet(pages.size());
        List pageReferences = (List)pages.stream().map(pageSplit -> new ClientBuffer.PageReference((Page)pageSplit, 1, () -> {
            Preconditions.checkState((this.totalBufferedPages.decrementAndGet() >= 0L ? 1 : 0) != 0);
            this.memoryManager.updateMemoryUsage(-pageSplit.getRetainedSizeInBytes());
        })).collect(ImmutableCollectors.toImmutableList());
        BroadcastOutputBuffer broadcastOutputBuffer = this;
        synchronized (broadcastOutputBuffer) {
            if (this.state.get().canAddBuffers()) {
                pageReferences.forEach(ClientBuffer.PageReference::addReference);
                this.initialPagesForNewBuffers.addAll(pageReferences);
            }
            buffers = this.safeGetBuffersSnapshot();
        }
        buffers.forEach(partition -> partition.enqueuePages(pageReferences));
        pageReferences.forEach(ClientBuffer.PageReference::dereferencePage);
        return this.memoryManager.getNotFullFuture();
    }

    @Override
    public ListenableFuture<?> enqueue(int partitionNumber, Page page) {
        Preconditions.checkState((partitionNumber == 0 ? 1 : 0) != 0, (Object)"Expected partition number to be zero");
        return this.enqueue(page);
    }

    @Override
    public CompletableFuture<BufferResult> get(OutputBuffers.OutputBufferId outputBufferId, long startingSequenceId, DataSize maxSize) {
        Objects.requireNonNull(outputBufferId, "outputBufferId is null");
        Preconditions.checkArgument((maxSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxSize must be at least 1 byte");
        return this.getBuffer(outputBufferId).getPages(startingSequenceId, maxSize);
    }

    @Override
    public void abort(OutputBuffers.OutputBufferId bufferId) {
        Objects.requireNonNull(bufferId, "bufferId is null");
        this.getBuffer(bufferId).destroy();
        this.checkFlushComplete();
    }

    @Override
    public void setNoMorePages() {
        this.state.compareAndSet(BufferState.OPEN, BufferState.NO_MORE_PAGES);
        this.state.compareAndSet(BufferState.NO_MORE_BUFFERS, BufferState.FLUSHING);
        this.memoryManager.setNoBlockOnFull();
        this.safeGetBuffersSnapshot().forEach(ClientBuffer::setNoMorePages);
        this.checkFlushComplete();
    }

    @Override
    public void destroy() {
        if (this.state.setIf(BufferState.FINISHED, oldState -> !oldState.isTerminal())) {
            this.noMoreBuffers();
            this.safeGetBuffersSnapshot().forEach(ClientBuffer::destroy);
            this.memoryManager.setNoBlockOnFull();
        }
    }

    @Override
    public void fail() {
        if (this.state.setIf(BufferState.FAILED, oldState -> !oldState.isTerminal())) {
            this.memoryManager.setNoBlockOnFull();
        }
    }

    private synchronized ClientBuffer getBuffer(OutputBuffers.OutputBufferId id) {
        ClientBuffer buffer = this.buffers.get(id);
        if (buffer != null) {
            return buffer;
        }
        Preconditions.checkState((boolean)this.state.get().canAddBuffers(), (Object)"No more buffers already set");
        buffer = new ClientBuffer(this.taskInstanceId, id);
        buffer.enqueuePages(this.initialPagesForNewBuffers);
        if (!this.state.get().canAddPages()) {
            buffer.setNoMorePages();
        }
        if (this.state.get() == BufferState.FINISHED) {
            buffer.destroy();
        }
        this.buffers.put(id, buffer);
        return buffer;
    }

    private synchronized Collection<ClientBuffer> safeGetBuffersSnapshot() {
        return ImmutableList.copyOf(this.buffers.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noMoreBuffers() {
        ImmutableList pages;
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not set no more buffers while holding a lock on this");
        BroadcastOutputBuffer broadcastOutputBuffer = this;
        synchronized (broadcastOutputBuffer) {
            pages = ImmutableList.copyOf(this.initialPagesForNewBuffers);
            this.initialPagesForNewBuffers.clear();
            Sets.SetView undeclaredCreatedBuffers = Sets.difference(this.buffers.keySet(), this.outputBuffers.getBuffers().keySet());
            Preconditions.checkState((boolean)undeclaredCreatedBuffers.isEmpty(), (String)"Final output buffers does not contain all created buffer ids: %s", (Object[])new Object[]{undeclaredCreatedBuffers});
        }
        pages.forEach(ClientBuffer.PageReference::dereferencePage);
    }

    private void checkFlushComplete() {
        if (this.state.get() != BufferState.FLUSHING) {
            return;
        }
        for (ClientBuffer buffer : this.safeGetBuffersSnapshot()) {
            if (buffer.isDestroyed()) continue;
            return;
        }
        this.destroy();
    }
}

