/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.event.query.QueryMonitor;
import com.facebook.presto.execution.FailedQueryExecution;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.ParameterExtractor;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryIdGenerator;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.QueryQueueManager;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.SqlQueryExecution;
import com.facebook.presto.execution.SqlQueryManagerStats;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.memory.ClusterMemoryManager;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.server.SessionSupplier;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.tree.Execute;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class SqlQueryManager
implements QueryManager {
    private static final Logger log = Logger.get(SqlQueryManager.class);
    private final SqlParser sqlParser;
    private final ExecutorService queryExecutor;
    private final ThreadPoolExecutorMBean queryExecutorMBean;
    private final QueryQueueManager queueManager;
    private final ClusterMemoryManager memoryManager;
    private final int maxQueryHistory;
    private final Duration minQueryExpireAge;
    private final ConcurrentMap<QueryId, QueryExecution> queries = new ConcurrentHashMap<QueryId, QueryExecution>();
    private final Queue<QueryExecution> expirationQueue = new LinkedBlockingQueue<QueryExecution>();
    private final Duration clientTimeout;
    private final ScheduledExecutorService queryManagementExecutor;
    private final ThreadPoolExecutorMBean queryManagementExecutorMBean;
    private final QueryMonitor queryMonitor;
    private final LocationFactory locationFactory;
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final QueryIdGenerator queryIdGenerator;
    private final SessionPropertyManager sessionPropertyManager;
    private final Map<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionFactories;
    private final SqlQueryManagerStats stats = new SqlQueryManagerStats();

    @Inject
    public SqlQueryManager(SqlParser sqlParser, QueryManagerConfig config, QueryMonitor queryMonitor, QueryQueueManager queueManager, ClusterMemoryManager memoryManager, LocationFactory locationFactory, TransactionManager transactionManager, AccessControl accessControl, QueryIdGenerator queryIdGenerator, SessionPropertyManager sessionPropertyManager, Map<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionFactories) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.executionFactories = Objects.requireNonNull(executionFactories, "executionFactories is null");
        this.queryExecutor = Executors.newCachedThreadPool(Threads.threadsNamed((String)"query-scheduler-%s"));
        this.queryExecutorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.queryExecutor);
        Objects.requireNonNull(config, "config is null");
        this.queueManager = Objects.requireNonNull(queueManager, "queueManager is null");
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.queryIdGenerator = Objects.requireNonNull(queryIdGenerator, "queryIdGenerator is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.minQueryExpireAge = config.getMinQueryExpireAge();
        this.maxQueryHistory = config.getMaxQueryHistory();
        this.clientTimeout = config.getClientTimeout();
        this.queryManagementExecutor = Executors.newScheduledThreadPool(config.getQueryManagerExecutorPoolSize(), Threads.threadsNamed((String)"query-management-%s"));
        this.queryManagementExecutorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)((Object)this.queryManagementExecutor));
        this.queryManagementExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    SqlQueryManager.this.failAbandonedQueries();
                }
                catch (Throwable e) {
                    log.warn(e, "Error cancelling abandoned queries");
                }
                try {
                    SqlQueryManager.this.enforceMemoryLimits();
                }
                catch (Throwable e) {
                    log.warn(e, "Error enforcing memory limits");
                }
                try {
                    SqlQueryManager.this.enforceQueryMaxRunTimeLimits();
                }
                catch (Throwable e) {
                    log.warn(e, "Error enforcing query timeout limits");
                }
                try {
                    SqlQueryManager.this.removeExpiredQueries();
                }
                catch (Throwable e) {
                    log.warn(e, "Error removing expired queries");
                }
                try {
                    SqlQueryManager.this.pruneExpiredQueries();
                }
                catch (Throwable e) {
                    log.warn(e, "Error pruning expired queries");
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void stop() {
        boolean queryCancelled = false;
        for (QueryExecution queryExecution : this.queries.values()) {
            if (queryExecution.getState().isDone()) continue;
            log.info("Server shutting down. Query %s has been cancelled", new Object[]{queryExecution.getQueryId()});
            queryExecution.fail(new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_SHUTTING_DOWN, "Server is shutting down. Query " + queryExecution.getQueryId() + " has been cancelled"));
            queryCancelled = true;
        }
        if (queryCancelled) {
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.queryManagementExecutor.shutdownNow();
        this.queryExecutor.shutdownNow();
    }

    @Override
    public List<QueryInfo> getAllQueryInfo() {
        return (List)this.queries.values().stream().map(queryExecution -> {
            try {
                return queryExecution.getQueryInfo();
            }
            catch (RuntimeException ignored) {
                return null;
            }
        }).filter(Objects::nonNull).collect(ImmutableCollectors.toImmutableList());
    }

    @Override
    public Duration waitForStateChange(QueryId queryId, QueryState currentState, Duration maxWait) throws InterruptedException {
        Objects.requireNonNull(queryId, "queryId is null");
        Objects.requireNonNull(maxWait, "maxWait is null");
        QueryExecution query = (QueryExecution)this.queries.get(queryId);
        if (query == null) {
            return maxWait;
        }
        return query.waitForStateChange(currentState, maxWait);
    }

    @Override
    public QueryInfo getQueryInfo(QueryId queryId) {
        Objects.requireNonNull(queryId, "queryId is null");
        QueryExecution query = (QueryExecution)this.queries.get(queryId);
        if (query == null) {
            throw new NoSuchElementException();
        }
        return query.getQueryInfo();
    }

    @Override
    public Optional<QueryState> getQueryState(QueryId queryId) {
        Objects.requireNonNull(queryId, "queryId is null");
        return Optional.ofNullable(this.queries.get(queryId)).map(QueryExecution::getState);
    }

    @Override
    public void recordHeartbeat(QueryId queryId) {
        Objects.requireNonNull(queryId, "queryId is null");
        QueryExecution query = (QueryExecution)this.queries.get(queryId);
        if (query == null) {
            return;
        }
        query.recordHeartbeat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryInfo createQuery(SessionSupplier sessionSupplier, String query) {
        Object queryExecution;
        Statement statement;
        Objects.requireNonNull(sessionSupplier, "sessionFactory is null");
        Objects.requireNonNull(query, "query is null");
        Preconditions.checkArgument((!query.isEmpty() ? 1 : 0) != 0, (Object)"query must not be empty string");
        QueryId queryId = this.queryIdGenerator.createNextQueryId();
        Session session = null;
        try {
            Statement innerStatement;
            session = sessionSupplier.createSession(queryId, this.transactionManager, this.accessControl, this.sessionPropertyManager);
            Statement wrappedStatement = this.sqlParser.createStatement(query);
            statement = SqlQueryManager.unwrapExecuteStatement(wrappedStatement, this.sqlParser, session);
            List parameters = wrappedStatement instanceof Execute ? ((Execute)wrappedStatement).getParameters() : Collections.emptyList();
            SqlQueryManager.validateParameters(statement, parameters);
            QueryExecution.QueryExecutionFactory<?> queryExecutionFactory = this.executionFactories.get(statement.getClass());
            if (queryExecutionFactory == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported statement type: " + statement.getClass().getSimpleName());
            }
            if (statement instanceof Explain && ((Explain)statement).isAnalyze() && !(this.executionFactories.get((innerStatement = ((Explain)statement).getStatement()).getClass()) instanceof SqlQueryExecution.SqlQueryExecutionFactory)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "EXPLAIN ANALYZE only supported for statements that are queries");
            }
            queryExecution = queryExecutionFactory.createQueryExecution(queryId, query, session, statement, parameters);
        }
        catch (PrestoException | SemanticException | ParsingException e) {
            URI self = this.locationFactory.createQueryLocation(queryId);
            if (session == null) {
                session = Session.builder(new SessionPropertyManager()).setQueryId(queryId).setIdentity(sessionSupplier.getIdentity()).build();
            }
            FailedQueryExecution execution = new FailedQueryExecution(queryId, query, session, self, this.transactionManager, this.queryExecutor, e);
            QueryInfo queryInfo = null;
            try {
                this.queries.put(queryId, execution);
                queryInfo = execution.getQueryInfo();
                this.queryMonitor.queryCreatedEvent(queryInfo);
                this.queryMonitor.queryCompletedEvent(queryInfo);
                this.stats.queryFinished(queryInfo);
            }
            finally {
                this.expirationQueue.add(execution);
            }
            return queryInfo;
        }
        QueryInfo queryInfo = queryExecution.getQueryInfo();
        this.queryMonitor.queryCreatedEvent(queryInfo);
        queryExecution.addFinalQueryInfoListener(finalQueryInfo -> {
            try {
                QueryInfo info = queryExecution.getQueryInfo();
                this.stats.queryFinished(info);
                this.queryMonitor.queryCompletedEvent(info);
            }
            finally {
                this.expirationQueue.add((QueryExecution)queryExecution);
            }
        });
        this.addStatsListener((QueryExecution)queryExecution);
        this.queries.put(queryId, (QueryExecution)queryExecution);
        this.queueManager.submit(statement, (QueryExecution)queryExecution, this.queryExecutor);
        return queryInfo;
    }

    public static Statement unwrapExecuteStatement(Statement statement, SqlParser sqlParser, Session session) {
        if (!(statement instanceof Execute)) {
            return statement;
        }
        String sql = session.getPreparedStatementFromExecute((Execute)statement);
        return sqlParser.createStatement(sql);
    }

    public static void validateParameters(Statement node, List<Expression> parameterValues) {
        int parameterCount = ParameterExtractor.getParameterCount(node);
        if (parameterValues.size() != parameterCount) {
            throw new SemanticException(SemanticErrorCode.INVALID_PARAMETER_USAGE, (Node)node, "Incorrect number of parameters: expected %s but found %s", parameterCount, parameterValues.size());
        }
        for (Expression expression : parameterValues) {
            ExpressionInterpreter.verifyExpressionIsConstant(Collections.emptySet(), expression);
        }
    }

    @Override
    public void cancelQuery(QueryId queryId) {
        Objects.requireNonNull(queryId, "queryId is null");
        log.debug("Cancel query %s", new Object[]{queryId});
        QueryExecution query = (QueryExecution)this.queries.get(queryId);
        if (query != null) {
            query.cancelQuery();
        }
    }

    @Override
    public void cancelStage(StageId stageId) {
        Objects.requireNonNull(stageId, "stageId is null");
        log.debug("Cancel stage %s", new Object[]{stageId});
        QueryExecution query = (QueryExecution)this.queries.get(stageId.getQueryId());
        if (query != null) {
            query.cancelStage(stageId);
        }
    }

    @Override
    @Managed
    @Flatten
    public SqlQueryManagerStats getStats() {
        return this.stats;
    }

    @Managed(description="Query scheduler executor")
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.queryExecutorMBean;
    }

    @Managed(description="Query garbage collector executor")
    @Nested
    public ThreadPoolExecutorMBean getManagementExecutor() {
        return this.queryManagementExecutorMBean;
    }

    public void enforceMemoryLimits() {
        this.memoryManager.process((Iterable)this.queries.values().stream().filter(query -> query.getState() == QueryState.RUNNING).collect(ImmutableCollectors.toImmutableList()));
    }

    public void enforceQueryMaxRunTimeLimits() {
        for (QueryExecution query : this.queries.values()) {
            if (query.getState().isDone()) continue;
            Duration queryMaxRunTime = SystemSessionProperties.getQueryMaxRunTime(query.getSession());
            DateTime executionStartTime = query.getQueryInfo().getQueryStats().getCreateTime();
            if (!executionStartTime.plus(queryMaxRunTime.toMillis()).isBeforeNow()) continue;
            query.fail(new PrestoException((ErrorCodeSupplier)StandardErrorCode.EXCEEDED_TIME_LIMIT, "Query exceeded maximum time limit of " + queryMaxRunTime));
        }
    }

    private void pruneExpiredQueries() {
        if (this.expirationQueue.size() <= this.maxQueryHistory) {
            return;
        }
        int count = 0;
        for (QueryExecution query : this.expirationQueue) {
            if (this.expirationQueue.size() - count <= this.maxQueryHistory) break;
            query.pruneInfo();
            ++count;
        }
    }

    private void removeExpiredQueries() {
        DateTime timeHorizon = DateTime.now().minus(this.minQueryExpireAge.toMillis());
        while (this.expirationQueue.size() > this.maxQueryHistory) {
            QueryInfo queryInfo = this.expirationQueue.peek().getQueryInfo();
            if (queryInfo.getQueryStats().getEndTime().isAfter((ReadableInstant)timeHorizon)) {
                return;
            }
            QueryId queryId = queryInfo.getQueryId();
            log.debug("Remove query %s", new Object[]{queryId});
            this.queries.remove(queryId);
            this.expirationQueue.remove();
        }
    }

    public void failAbandonedQueries() {
        for (QueryExecution queryExecution : this.queries.values()) {
            QueryInfo queryInfo = queryExecution.getQueryInfo();
            if (queryInfo.getState().isDone() || !this.isAbandoned(queryExecution)) continue;
            log.info("Failing abandoned query %s", new Object[]{queryExecution.getQueryId()});
            queryExecution.fail(new PrestoException((ErrorCodeSupplier)StandardErrorCode.ABANDONED_QUERY, String.format("Query %s has not been accessed since %s: currentTime %s", queryInfo.getQueryId(), queryInfo.getQueryStats().getLastHeartbeat(), DateTime.now())));
        }
    }

    private boolean isAbandoned(QueryExecution query) {
        DateTime oldestAllowedHeartbeat = DateTime.now().minus(this.clientTimeout.toMillis());
        DateTime lastHeartbeat = query.getQueryInfo().getQueryStats().getLastHeartbeat();
        return lastHeartbeat != null && lastHeartbeat.isBefore((ReadableInstant)oldestAllowedHeartbeat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStatsListener(QueryExecution queryExecution) {
        Object lock = new Object();
        AtomicBoolean started = new AtomicBoolean();
        queryExecution.addStateChangeListener(newValue -> {
            Object object = lock;
            synchronized (object) {
                if (newValue == QueryState.RUNNING && !started.getAndSet(true)) {
                    this.stats.queryStarted();
                }
            }
        });
        Object object = lock;
        synchronized (object) {
            if (queryExecution.getState() == QueryState.RUNNING && !started.getAndSet(true)) {
                this.stats.queryStarted();
            }
        }
        AtomicBoolean stopped = new AtomicBoolean();
        queryExecution.addStateChangeListener(newValue -> {
            Object object = lock;
            synchronized (object) {
                if (newValue.isDone() && !stopped.getAndSet(true) && started.get()) {
                    this.stats.queryStopped();
                }
            }
        });
        Object object2 = lock;
        synchronized (object2) {
            if (queryExecution.getState().isDone() && !stopped.getAndSet(true) && started.get()) {
                this.stats.queryStopped();
            }
        }
    }

    static void addCompletionCallback(QueryExecution queryExecution, Runnable callback) {
        AtomicBoolean taskExecuted = new AtomicBoolean();
        queryExecution.addStateChangeListener(newValue -> {
            if (newValue.isDone() && taskExecuted.compareAndSet(false, true)) {
                callback.run();
            }
        });
        if (queryExecution.getState().isDone() && taskExecuted.compareAndSet(false, true)) {
            callback.run();
        }
    }
}

