/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.SqlScalarFunctionBuilder;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DecimalInequalityOperators {
    private static final MethodHandle IS_RESULT_EQUAL = Reflection.methodHandle(DecimalInequalityOperators.class, "getResultEqual", Integer.TYPE);
    private static final MethodHandle IS_RESULT_NOT_EQUAL = Reflection.methodHandle(DecimalInequalityOperators.class, "isResultNotEqual", Integer.TYPE);
    private static final MethodHandle IS_RESULT_LESS_THAN = Reflection.methodHandle(DecimalInequalityOperators.class, "isResultLessThan", Integer.TYPE);
    private static final MethodHandle IS_RESULT_LESS_THAN_OR_EQUAL = Reflection.methodHandle(DecimalInequalityOperators.class, "isResultLessThanOrEqual", Integer.TYPE);
    private static final MethodHandle IS_RESULT_GREATER_THAN = Reflection.methodHandle(DecimalInequalityOperators.class, "isResultGreaterThan", Integer.TYPE);
    private static final MethodHandle IS_RESULT_GREATER_THAN_OR_EQUAL = Reflection.methodHandle(DecimalInequalityOperators.class, "isResultGreaterThanOrEqual", Integer.TYPE);
    public static final SqlScalarFunction DECIMAL_EQUAL_OPERATOR = DecimalInequalityOperators.binaryOperator(OperatorType.EQUAL, IS_RESULT_EQUAL);
    public static final SqlScalarFunction DECIMAL_NOT_EQUAL_OPERATOR = DecimalInequalityOperators.binaryOperator(OperatorType.NOT_EQUAL, IS_RESULT_NOT_EQUAL);
    public static final SqlScalarFunction DECIMAL_LESS_THAN_OPERATOR = DecimalInequalityOperators.binaryOperator(OperatorType.LESS_THAN, IS_RESULT_LESS_THAN);
    public static final SqlScalarFunction DECIMAL_LESS_THAN_OR_EQUAL_OPERATOR = DecimalInequalityOperators.binaryOperator(OperatorType.LESS_THAN_OR_EQUAL, IS_RESULT_LESS_THAN_OR_EQUAL);
    public static final SqlScalarFunction DECIMAL_GREATER_THAN_OPERATOR = DecimalInequalityOperators.binaryOperator(OperatorType.GREATER_THAN, IS_RESULT_GREATER_THAN);
    public static final SqlScalarFunction DECIMAL_GREATER_THAN_OR_EQUAL_OPERATOR = DecimalInequalityOperators.binaryOperator(OperatorType.GREATER_THAN_OR_EQUAL, IS_RESULT_GREATER_THAN_OR_EQUAL);
    public static final SqlScalarFunction DECIMAL_BETWEEN_OPERATOR = DecimalInequalityOperators.betweenOperator();
    public static final SqlScalarFunction DECIMAL_DISTINCT_FROM_OPERATOR = DecimalInequalityOperators.binaryOperatorNullable(OperatorType.IS_DISTINCT_FROM, IS_RESULT_NOT_EQUAL);
    private static final int MAX_PRECISION_OF_JAVA_LONG = 18;

    private DecimalInequalityOperators() {
    }

    @UsedByGeneratedCode
    public static boolean getResultEqual(int comparisonResult) {
        return comparisonResult == 0;
    }

    @UsedByGeneratedCode
    public static boolean isResultNotEqual(int comparisonResult) {
        return comparisonResult != 0;
    }

    @UsedByGeneratedCode
    public static boolean isResultLessThan(int comparisonResult) {
        return comparisonResult < 0;
    }

    @UsedByGeneratedCode
    public static boolean isResultLessThanOrEqual(int comparisonResult) {
        return comparisonResult <= 0;
    }

    @UsedByGeneratedCode
    public static boolean isResultGreaterThan(int comparisonResult) {
        return comparisonResult > 0;
    }

    @UsedByGeneratedCode
    public static boolean isResultGreaterThanOrEqual(int comparisonResult) {
        return comparisonResult >= 0;
    }

    private static SqlScalarFunctionBuilder makeBinaryOperatorFunctionBuilder(OperatorType operatorType) {
        TypeSignature decimalASignature = TypeSignature.parseTypeSignature((String)"decimal(a_precision, a_scale)", (Set)ImmutableSet.of((Object)"a_precision", (Object)"a_scale"));
        TypeSignature decimalBSignature = TypeSignature.parseTypeSignature((String)"decimal(b_precision, b_scale)", (Set)ImmutableSet.of((Object)"b_precision", (Object)"b_scale"));
        Signature signature = Signature.builder().kind(FunctionKind.SCALAR).operatorType(operatorType).argumentTypes(decimalASignature, decimalBSignature).returnType(TypeSignature.parseTypeSignature((String)"boolean")).build();
        return SqlScalarFunction.builder(DecimalInequalityOperators.class).signature(signature);
    }

    private static SqlScalarFunction binaryOperator(OperatorType operatorType, MethodHandle getResultMethodHandle) {
        return DecimalInequalityOperators.makeBinaryOperatorFunctionBuilder(operatorType).implementation(b -> b.methods("opShortShortShortRescale").withPredicate(DecimalInequalityOperators::rescaledValuesFitJavaLong).withExtraParameters(SqlScalarFunctionBuilder.concat(DecimalInequalityOperators::shortRescaleExtraParameters, SqlScalarFunctionBuilder.constant(getResultMethodHandle)))).implementation(b -> b.methods("opShortShortLongRescale", "opShortLong", "opLongShort", "opLongLong").withExtraParameters(SqlScalarFunctionBuilder.concat(DecimalInequalityOperators::longRescaleExtraParameters, SqlScalarFunctionBuilder.constant(getResultMethodHandle)))).build();
    }

    private static SqlScalarFunction binaryOperatorNullable(OperatorType operatorType, MethodHandle getResultMethodHandle) {
        return DecimalInequalityOperators.makeBinaryOperatorFunctionBuilder(operatorType).nullableArguments(true, true).nullFlags(true, true).implementation(b -> b.methods("opShortShortShortRescaleNullable").withPredicate(DecimalInequalityOperators::rescaledValuesFitJavaLong).withExtraParameters(SqlScalarFunctionBuilder.concat(DecimalInequalityOperators::shortRescaleExtraParameters, SqlScalarFunctionBuilder.constant(getResultMethodHandle)))).implementation(b -> b.methods("opShortShortLongRescaleNullable", "opShortLongNullable", "opLongShortNullable", "opLongLongNullable").withExtraParameters(SqlScalarFunctionBuilder.concat(DecimalInequalityOperators::longRescaleExtraParameters, SqlScalarFunctionBuilder.constant(getResultMethodHandle)))).build();
    }

    private static boolean rescaledValuesFitJavaLong(SqlScalarFunctionBuilder.SpecializeContext context) {
        long aPrecision = context.getLiteral("a_precision");
        long aScale = context.getLiteral("a_scale");
        long bPrecision = context.getLiteral("b_precision");
        long bScale = context.getLiteral("b_scale");
        long aRescaleFactor = DecimalInequalityOperators.rescaleFactor(aScale, bScale);
        long bRescaleFactor = DecimalInequalityOperators.rescaleFactor(bScale, aScale);
        return aPrecision + aRescaleFactor <= 18L && bPrecision + bRescaleFactor <= 18L;
    }

    private static List<Object> shortRescaleExtraParameters(SqlScalarFunctionBuilder.SpecializeContext context) {
        long aScale = context.getLiteral("a_scale");
        long bScale = context.getLiteral("b_scale");
        long aRescale = Decimals.longTenToNth((int)DecimalInequalityOperators.rescaleFactor(aScale, bScale));
        long bRescale = Decimals.longTenToNth((int)DecimalInequalityOperators.rescaleFactor(bScale, aScale));
        return ImmutableList.of((Object)aRescale, (Object)bRescale);
    }

    private static List<Object> longRescaleExtraParameters(SqlScalarFunctionBuilder.SpecializeContext context) {
        long aScale = context.getLiteral("a_scale");
        long bScale = context.getLiteral("b_scale");
        BigInteger aRescale = Decimals.bigIntegerTenToNth((int)DecimalInequalityOperators.rescaleFactor(aScale, bScale));
        BigInteger bRescale = Decimals.bigIntegerTenToNth((int)DecimalInequalityOperators.rescaleFactor(bScale, aScale));
        return ImmutableList.of((Object)aRescale, (Object)bRescale);
    }

    private static int rescaleFactor(long fromScale, long toScale) {
        return Integer.max(0, (int)(toScale - fromScale));
    }

    @UsedByGeneratedCode
    public static boolean opShortShortShortRescale(long a, long b, long aRescale, long bRescale, MethodHandle getResultMethodHandle) {
        return DecimalInequalityOperators.invokeGetResult(getResultMethodHandle, Long.compare(a * aRescale, b * bRescale));
    }

    @UsedByGeneratedCode
    public static boolean opShortShortShortRescaleNullable(long a, boolean aNull, long b, boolean bNull, long aRescale, long bRescale, MethodHandle getResultMethodHandle) {
        if (aNull != bNull) {
            return true;
        }
        if (aNull) {
            return false;
        }
        return DecimalInequalityOperators.opShortShortShortRescale(a, b, aRescale, bRescale, getResultMethodHandle);
    }

    @UsedByGeneratedCode
    public static boolean opShortShortLongRescale(long a, long b, BigInteger aRescale, BigInteger bRescale, MethodHandle getResultMethodHandle) {
        BigInteger left = BigInteger.valueOf(a).multiply(aRescale);
        BigInteger right = BigInteger.valueOf(b).multiply(bRescale);
        return DecimalInequalityOperators.invokeGetResult(getResultMethodHandle, left.compareTo(right));
    }

    @UsedByGeneratedCode
    public static boolean opShortShortLongRescaleNullable(long a, boolean aNull, long b, boolean bNull, BigInteger aRescale, BigInteger bRescale, MethodHandle getResultMethodHandle) {
        if (aNull != bNull) {
            return true;
        }
        if (aNull && bNull) {
            return false;
        }
        return DecimalInequalityOperators.opShortShortLongRescale(a, b, aRescale, bRescale, getResultMethodHandle);
    }

    @UsedByGeneratedCode
    public static boolean opShortLong(long a, Slice b, BigInteger aRescale, BigInteger bRescale, MethodHandle getResultMethodHandle) {
        BigInteger left = BigInteger.valueOf(a).multiply(aRescale);
        BigInteger right = Decimals.decodeUnscaledValue((Slice)b).multiply(bRescale);
        return DecimalInequalityOperators.invokeGetResult(getResultMethodHandle, left.compareTo(right));
    }

    @UsedByGeneratedCode
    public static boolean opShortLongNullable(long a, boolean aNull, Slice b, boolean bNull, BigInteger aRescale, BigInteger bRescale, MethodHandle getResultMethodHandle) {
        if (aNull != bNull) {
            return true;
        }
        if (aNull && bNull) {
            return false;
        }
        return DecimalInequalityOperators.opShortLong(a, b, aRescale, bRescale, getResultMethodHandle);
    }

    @UsedByGeneratedCode
    public static boolean opLongShort(Slice a, long b, BigInteger aRescale, BigInteger bRescale, MethodHandle getResultMethodHandle) {
        BigInteger left = Decimals.decodeUnscaledValue((Slice)a).multiply(aRescale);
        BigInteger right = BigInteger.valueOf(b).multiply(bRescale);
        return DecimalInequalityOperators.invokeGetResult(getResultMethodHandle, left.compareTo(right));
    }

    @UsedByGeneratedCode
    public static boolean opLongShortNullable(Slice a, boolean aNull, long b, boolean bNull, BigInteger aRescale, BigInteger bRescale, MethodHandle getResultMethodHandle) {
        if (aNull != bNull) {
            return true;
        }
        if (aNull && bNull) {
            return false;
        }
        return DecimalInequalityOperators.opLongShort(a, b, aRescale, bRescale, getResultMethodHandle);
    }

    @UsedByGeneratedCode
    public static boolean opLongLong(Slice a, Slice b, BigInteger aRescale, BigInteger bRescale, MethodHandle getResultMethodHandle) {
        BigInteger left = Decimals.decodeUnscaledValue((Slice)a).multiply(aRescale);
        BigInteger right = Decimals.decodeUnscaledValue((Slice)b).multiply(bRescale);
        return DecimalInequalityOperators.invokeGetResult(getResultMethodHandle, left.compareTo(right));
    }

    @UsedByGeneratedCode
    public static boolean opLongLongNullable(Slice a, boolean aNull, Slice b, boolean bNull, BigInteger aRescale, BigInteger bRescale, MethodHandle getResultMethodHandle) {
        if (aNull != bNull) {
            return true;
        }
        if (aNull && bNull) {
            return false;
        }
        return DecimalInequalityOperators.opLongLong(a, b, aRescale, bRescale, getResultMethodHandle);
    }

    private static boolean invokeGetResult(MethodHandle getResultMethodHandle, int comparisonResult) {
        try {
            return getResultMethodHandle.invokeExact(comparisonResult);
        }
        catch (Throwable t) {
            Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
            Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
        }
    }

    private static SqlScalarFunction betweenOperator() {
        TypeSignature valueSignature = TypeSignature.parseTypeSignature((String)"decimal(value_precision, value_scale)", (Set)ImmutableSet.of((Object)"value_precision", (Object)"value_scale"));
        TypeSignature lowSignature = TypeSignature.parseTypeSignature((String)"decimal(low_precision, low_scale)", (Set)ImmutableSet.of((Object)"low_precision", (Object)"low_scale"));
        TypeSignature highSignature = TypeSignature.parseTypeSignature((String)"decimal(high_precision, high_scale)", (Set)ImmutableSet.of((Object)"high_precision", (Object)"high_scale"));
        Signature signature = Signature.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.BETWEEN).argumentTypes(valueSignature, lowSignature, highSignature).returnType(TypeSignature.parseTypeSignature((String)"boolean")).build();
        return SqlScalarFunction.builder(DecimalInequalityOperators.class).signature(signature).implementation(b -> b.methods("betweenShortShortShort", "betweenShortShortLong", "betweenShortLongShort", "betweenShortLongLong", "betweenLongShortShort", "betweenLongShortLong", "betweenLongLongShort", "betweenLongLongLong").withExtraParameters(DecimalInequalityOperators::bindMethodsExtraParameters)).build();
    }

    private static List<Object> bindMethodsExtraParameters(SqlScalarFunctionBuilder.SpecializeContext context) {
        long valuePrecision = context.getLiteral("value_precision");
        long valueScale = context.getLiteral("value_scale");
        long lowPrecision = context.getLiteral("low_precision");
        long lowScale = context.getLiteral("low_scale");
        long highPrecision = context.getLiteral("high_precision");
        long highScale = context.getLiteral("high_scale");
        MethodHandle lowerBoundTestMethodHandle = DECIMAL_LESS_THAN_OR_EQUAL_OPERATOR.specialize(new BoundVariables((Map<String, Type>)ImmutableMap.of(), (Map<String, Long>)ImmutableMap.of((Object)"a_precision", (Object)lowPrecision, (Object)"a_scale", (Object)lowScale, (Object)"b_precision", (Object)valuePrecision, (Object)"b_scale", (Object)valueScale)), 2, context.getTypeManager(), context.getFunctionRegistry()).getMethodHandle();
        MethodHandle upperBoundTestMethodHandle = DECIMAL_GREATER_THAN_OR_EQUAL_OPERATOR.specialize(new BoundVariables((Map<String, Type>)ImmutableMap.of(), (Map<String, Long>)ImmutableMap.of((Object)"a_precision", (Object)highPrecision, (Object)"a_scale", (Object)highScale, (Object)"b_precision", (Object)valuePrecision, (Object)"b_scale", (Object)valueScale)), 2, context.getTypeManager(), context.getFunctionRegistry()).getMethodHandle();
        return ImmutableList.of((Object)lowerBoundTestMethodHandle, (Object)upperBoundTestMethodHandle);
    }

    @UsedByGeneratedCode
    public static boolean betweenShortShortShort(long value, long low, long high, MethodHandle lowerBoundTestMethodHandle, MethodHandle upperBoundTestMethodHandle) throws Throwable {
        return lowerBoundTestMethodHandle.invokeExact(low, value) && upperBoundTestMethodHandle.invokeExact(high, value);
    }

    @UsedByGeneratedCode
    public static boolean betweenShortShortLong(long value, long low, Slice high, MethodHandle lowerBoundTestMethodHandle, MethodHandle upperBoundTestMethodHandle) throws Throwable {
        return lowerBoundTestMethodHandle.invokeExact(low, value) && upperBoundTestMethodHandle.invokeExact(high, value);
    }

    @UsedByGeneratedCode
    public static boolean betweenShortLongShort(long value, Slice low, long high, MethodHandle lowerBoundTestMethodHandle, MethodHandle upperBoundTestMethodHandle) throws Throwable {
        return lowerBoundTestMethodHandle.invokeExact(low, value) && upperBoundTestMethodHandle.invokeExact(high, value);
    }

    @UsedByGeneratedCode
    public static boolean betweenShortLongLong(long value, Slice low, Slice high, MethodHandle lowerBoundTestMethodHandle, MethodHandle upperBoundTestMethodHandle) throws Throwable {
        return lowerBoundTestMethodHandle.invokeExact(low, value) && upperBoundTestMethodHandle.invokeExact(high, value);
    }

    @UsedByGeneratedCode
    public static boolean betweenLongShortShort(Slice value, long low, long high, MethodHandle lowerBoundTestMethodHandle, MethodHandle upperBoundTestMethodHandle) throws Throwable {
        return lowerBoundTestMethodHandle.invokeExact(low, value) && upperBoundTestMethodHandle.invokeExact(high, value);
    }

    @UsedByGeneratedCode
    public static boolean betweenLongShortLong(Slice value, long low, Slice high, MethodHandle lowerBoundTestMethodHandle, MethodHandle upperBoundTestMethodHandle) throws Throwable {
        return lowerBoundTestMethodHandle.invokeExact(low, value) && upperBoundTestMethodHandle.invokeExact(high, value);
    }

    @UsedByGeneratedCode
    public static boolean betweenLongLongShort(Slice value, Slice low, long high, MethodHandle lowerBoundTestMethodHandle, MethodHandle upperBoundTestMethodHandle) throws Throwable {
        return lowerBoundTestMethodHandle.invokeExact(low, value) && upperBoundTestMethodHandle.invokeExact(high, value);
    }

    @UsedByGeneratedCode
    public static boolean betweenLongLongLong(Slice value, Slice low, Slice high, MethodHandle lowerBoundTestMethodHandle, MethodHandle upperBoundTestMethodHandle) throws Throwable {
        return lowerBoundTestMethodHandle.invokeExact(low, value) && upperBoundTestMethodHandle.invokeExact(high, value);
    }
}

