/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.rewrite;

import com.facebook.presto.Session;
import com.facebook.presto.connector.informationSchema.InformationSchemaMetadata;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.CatalogSchemaName;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.rewrite.StatementRewrite;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.ColumnDefinition;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.ShowCatalogs;
import com.facebook.presto.sql.tree.ShowColumns;
import com.facebook.presto.sql.tree.ShowCreate;
import com.facebook.presto.sql.tree.ShowFunctions;
import com.facebook.presto.sql.tree.ShowPartitions;
import com.facebook.presto.sql.tree.ShowSchemas;
import com.facebook.presto.sql.tree.ShowSession;
import com.facebook.presto.sql.tree.ShowTables;
import com.facebook.presto.sql.tree.SimpleGroupBy;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.util.ImmutableCollectors;
import com.facebook.presto.util.Types;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

final class ShowQueriesRewrite
implements StatementRewrite.Rewrite {
    ShowQueriesRewrite() {
    }

    @Override
    public Statement rewrite(Session session, Metadata metadata, SqlParser parser, Optional<QueryExplainer> queryExplainer, Statement node, List<Expression> parameters, AccessControl accessControl) {
        return (Statement)new Visitor(metadata, parser, session, parameters).process((Node)node, null);
    }

    private static class Visitor
    extends AstVisitor<Node, Void> {
        private final Metadata metadata;
        private final Session session;
        private final SqlParser sqlParser;
        List<Expression> parameters;

        public Visitor(Metadata metadata, SqlParser sqlParser, Session session, List<Expression> parameters) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.parameters = Objects.requireNonNull(parameters, "parameters is null");
        }

        protected Node visitExplain(Explain node, Void context) {
            Statement statement = (Statement)this.process((Node)node.getStatement(), null);
            return new Explain((NodeLocation)node.getLocation().get(), node.isAnalyze(), statement, node.getOptions());
        }

        protected Node visitShowTables(ShowTables showTables, Void context) {
            CatalogSchemaName schema = MetadataUtil.createCatalogSchemaName(this.session, (Node)showTables, showTables.getSchema());
            if (!this.metadata.schemaExists(this.session, schema)) {
                throw new SemanticException(SemanticErrorCode.MISSING_SCHEMA, (Node)showTables, "Schema '%s' does not exist", schema.getSchemaName());
            }
            Expression predicate = QueryUtil.equal((Expression)QueryUtil.nameReference((String)"table_schema"), (Expression)new StringLiteral(schema.getSchemaName()));
            Optional likePattern = showTables.getLikePattern();
            if (likePattern.isPresent()) {
                LikePredicate likePredicate = new LikePredicate(QueryUtil.nameReference((String)"table_name"), (Expression)new StringLiteral((String)likePattern.get()), null);
                predicate = QueryUtil.logicalAnd((Expression)predicate, (Expression)likePredicate);
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"table_name", (String)"Table")}), (Relation)Visitor.from(schema.getCatalogName(), InformationSchemaMetadata.TABLE_TABLES), (Expression)predicate, (List)QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"table_name")}));
        }

        protected Node visitShowSchemas(ShowSchemas node, Void context) {
            if (!node.getCatalog().isPresent() && !this.session.getCatalog().isPresent()) {
                throw new SemanticException(SemanticErrorCode.CATALOG_NOT_SPECIFIED, (Node)node, "Catalog must be specified when session catalog is not set", new Object[0]);
            }
            Optional<Object> predicate = Optional.empty();
            Optional likePattern = node.getLikePattern();
            if (likePattern.isPresent()) {
                predicate = Optional.of(new LikePredicate(QueryUtil.nameReference((String)"schema_name"), (Expression)new StringLiteral((String)likePattern.get()), null));
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"schema_name", (String)"Schema")}), (Relation)Visitor.from(node.getCatalog().orElseGet(() -> this.session.getCatalog().get()), InformationSchemaMetadata.TABLE_SCHEMATA), predicate, (List)QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"schema_name")}));
        }

        protected Node visitShowCatalogs(ShowCatalogs node, Void context) {
            List rows = this.metadata.getCatalogNames(this.session).keySet().stream().map(name -> QueryUtil.row((Expression[])new Expression[]{new StringLiteral(name)})).collect(Collectors.toList());
            Optional<Object> predicate = Optional.empty();
            Optional likePattern = node.getLikePattern();
            if (likePattern.isPresent()) {
                predicate = Optional.of(new LikePredicate(QueryUtil.nameReference((String)"Catalog"), (Expression)new StringLiteral((String)likePattern.get()), null));
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.aliased((Relation)new Values(rows), (String)"catalogs", (List)ImmutableList.of((Object)"Catalog")), predicate, (List)QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"Catalog")}));
        }

        protected Node visitShowColumns(ShowColumns showColumns, Void context) {
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(this.session, (Node)showColumns, showColumns.getTable());
            if (!this.metadata.getView(this.session, tableName).isPresent() && !this.metadata.getTableHandle(this.session, tableName).isPresent()) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)showColumns, "Table '%s' does not exist", tableName);
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"column_name", (String)"Column"), QueryUtil.aliasedName((String)"data_type", (String)"Type"), QueryUtil.aliasedNullToEmpty((String)"comment", (String)"Comment")}), (Relation)Visitor.from(tableName.getCatalogName(), InformationSchemaMetadata.TABLE_COLUMNS), (Expression)QueryUtil.logicalAnd((Expression)QueryUtil.equal((Expression)QueryUtil.nameReference((String)"table_schema"), (Expression)new StringLiteral(tableName.getSchemaName())), (Expression)QueryUtil.equal((Expression)QueryUtil.nameReference((String)"table_name"), (Expression)new StringLiteral(tableName.getObjectName()))), (List)QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"ordinal_position")}));
        }

        private static <T> Expression getExpression(PropertyMetadata<T> property, Object value) throws PrestoException {
            return Visitor.toExpression(property.encode(property.getJavaType().cast(value)));
        }

        private static Expression toExpression(Object value) throws PrestoException {
            if (value instanceof String) {
                return new StringLiteral(value.toString());
            }
            if (value instanceof Boolean) {
                return new BooleanLiteral(value.toString());
            }
            if (value instanceof Long || value instanceof Integer) {
                return new LongLiteral(value.toString());
            }
            if (value instanceof Double) {
                return new DoubleLiteral(value.toString());
            }
            if (value instanceof List) {
                List list = (List)value;
                return new ArrayConstructor(list.stream().map(Visitor::toExpression).collect(Collectors.toList()));
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Failed to convert object of type %s to expression: %s", value.getClass().getName(), value));
        }

        protected Node visitShowPartitions(ShowPartitions showPartitions, Void context) {
            QualifiedObjectName table = MetadataUtil.createQualifiedObjectName(this.session, (Node)showPartitions, showPartitions.getTable());
            Optional<TableHandle> tableHandle = this.metadata.getTableHandle(this.session, table);
            if (!tableHandle.isPresent()) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)showPartitions, "Table '%s' does not exist", table);
            }
            List<TableLayoutResult> layouts = this.metadata.getLayouts(this.session, tableHandle.get(), (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.empty());
            if (layouts.size() != 1) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)showPartitions, "Table does not have exactly one layout: %s", table);
            }
            TableLayout layout = ((TableLayoutResult)Iterables.getOnlyElement(layouts)).getLayout();
            if (!layout.getDiscretePredicates().isPresent()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)showPartitions, "Table does not have partition columns: %s", table);
            }
            List partitionColumns = layout.getDiscretePredicates().get().getColumns();
            ImmutableList.Builder selectList = ImmutableList.builder();
            ImmutableList.Builder wrappedList = ImmutableList.builder();
            selectList.add((Object)QueryUtil.unaliasedName((String)"partition_number"));
            for (ColumnHandle columnHandle : partitionColumns) {
                ColumnMetadata column = this.metadata.getColumnMetadata(this.session, tableHandle.get(), columnHandle);
                Expression key = QueryUtil.equal((Expression)QueryUtil.nameReference((String)"partition_key"), (Expression)new StringLiteral(column.getName()));
                Expression value = QueryUtil.caseWhen((Expression)key, (Expression)QueryUtil.nameReference((String)"partition_value"));
                value = new Cast(value, column.getType().getTypeSignature().toString());
                Expression function = QueryUtil.functionCall((String)"max", (Expression[])new Expression[]{value});
                selectList.add((Object)new SingleColumn(function, column.getName()));
                wrappedList.add((Object)QueryUtil.unaliasedName((String)column.getName()));
            }
            Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectAll((List)selectList.build()), (Relation)Visitor.from(table.getCatalogName(), InformationSchemaMetadata.TABLE_INTERNAL_PARTITIONS), Optional.of(QueryUtil.logicalAnd((Expression)QueryUtil.equal((Expression)QueryUtil.nameReference((String)"table_schema"), (Expression)new StringLiteral(table.getSchemaName())), (Expression)QueryUtil.equal((Expression)QueryUtil.nameReference((String)"table_name"), (Expression)new StringLiteral(table.getObjectName())))), Optional.of(new GroupBy(false, (List)ImmutableList.of((Object)new SimpleGroupBy((List)ImmutableList.of((Object)QueryUtil.nameReference((String)"partition_number")))))), Optional.empty(), (List)ImmutableList.of(), Optional.empty());
            return QueryUtil.simpleQuery((Select)QueryUtil.selectAll((List)wrappedList.build()), (Relation)QueryUtil.subquery((Query)query), (Optional)showPartitions.getWhere(), Optional.empty(), Optional.empty(), (List)ImmutableList.builder().addAll((Iterable)showPartitions.getOrderBy()).add((Object)QueryUtil.ascending((String)"partition_number")).build(), (Optional)showPartitions.getLimit());
        }

        protected Node visitShowCreate(ShowCreate node, Void context) {
            QualifiedObjectName objectName = MetadataUtil.createQualifiedObjectName(this.session, (Node)node, node.getName());
            Optional<ViewDefinition> viewDefinition = this.metadata.getView(this.session, objectName);
            if (node.getType() == ShowCreate.Type.VIEW) {
                if (!viewDefinition.isPresent()) {
                    if (this.metadata.getTableHandle(this.session, objectName).isPresent()) {
                        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Relation '%s' is a table, not a view", objectName);
                    }
                    throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)node, "View '%s' does not exist", objectName);
                }
                Query query = this.parseView(viewDefinition.get().getOriginalSql(), objectName, (Node)node);
                String sql = SqlFormatter.formatSql((Node)new CreateView(MetadataUtil.createQualifiedName(objectName), query, false), Optional.of(this.parameters)).trim();
                return QueryUtil.singleValueQuery((String)"Create View", (String)sql);
            }
            if (node.getType() == ShowCreate.Type.TABLE) {
                if (viewDefinition.isPresent()) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Relation '%s' is a view, not a table", objectName);
                }
                Optional<TableHandle> tableHandle = this.metadata.getTableHandle(this.session, objectName);
                if (!tableHandle.isPresent()) {
                    throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)node, "Table '%s' does not exist", objectName);
                }
                ConnectorTableMetadata connectorTableMetadata = this.metadata.getTableMetadata(this.session, tableHandle.get()).getMetadata();
                List columns = (List)connectorTableMetadata.getColumns().stream().filter(column -> !column.isHidden()).map(column -> new ColumnDefinition(column.getName(), column.getType().getDisplayName())).collect(ImmutableCollectors.toImmutableList());
                Map properties = connectorTableMetadata.getProperties();
                Map allTableProperties = (Map)this.metadata.getTablePropertyManager().getAllProperties().get(tableHandle.get().getConnectorId());
                HashMap<String, Expression> sqlProperties = new HashMap<String, Expression>();
                for (Map.Entry propertyEntry : properties.entrySet()) {
                    String propertyName = (String)propertyEntry.getKey();
                    Object value = propertyEntry.getValue();
                    if (value == null) {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Property %s for table %s cannot have a null value", propertyName, objectName));
                    }
                    PropertyMetadata property = (PropertyMetadata)allTableProperties.get(propertyName);
                    if (!property.getJavaType().isInstance(value)) {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Property %s for table %s should have value of type %s, not %s", propertyName, objectName, property.getJavaType().getName(), value.getClass().getName()));
                    }
                    Expression sqlExpression = Visitor.getExpression(property, value);
                    sqlProperties.put(propertyName, sqlExpression);
                }
                CreateTable createTable = new CreateTable(QualifiedName.of((String)objectName.getCatalogName(), (String[])new String[]{objectName.getSchemaName(), objectName.getObjectName()}), columns, false, sqlProperties);
                return QueryUtil.singleValueQuery((String)"Create Table", (String)SqlFormatter.formatSql((Node)createTable, Optional.of(this.parameters)).trim());
            }
            throw new UnsupportedOperationException("SHOW CREATE only supported for tables and views");
        }

        protected Node visitShowFunctions(ShowFunctions node, Void context) {
            ImmutableList.Builder rows = ImmutableList.builder();
            for (SqlFunction function : this.metadata.listFunctions()) {
                rows.add((Object)QueryUtil.row((Expression[])new Expression[]{new StringLiteral(function.getSignature().getName()), new StringLiteral(function.getSignature().getReturnType().toString()), new StringLiteral(Joiner.on((String)", ").join(function.getSignature().getArgumentTypes())), new StringLiteral(Visitor.getFunctionType(function)), function.isDeterministic() ? BooleanLiteral.TRUE_LITERAL : BooleanLiteral.FALSE_LITERAL, new StringLiteral(Strings.nullToEmpty((String)function.getDescription()))}));
            }
            ImmutableMap columns = ImmutableMap.builder().put((Object)"function_name", (Object)"Function").put((Object)"return_type", (Object)"Return Type").put((Object)"argument_types", (Object)"Argument Types").put((Object)"function_type", (Object)"Function Type").put((Object)"deterministic", (Object)"Deterministic").put((Object)"description", (Object)"Description").build();
            return QueryUtil.simpleQuery((Select)QueryUtil.selectAll((List)((List)columns.entrySet().stream().map(entry -> QueryUtil.aliasedName((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(ImmutableCollectors.toImmutableList()))), (Relation)QueryUtil.aliased((Relation)new Values((List)rows.build()), (String)"functions", (List)ImmutableList.copyOf(columns.keySet())), (List)QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"function_name"), QueryUtil.ascending((String)"return_type"), QueryUtil.ascending((String)"argument_types"), QueryUtil.ascending((String)"function_type")}));
        }

        private static String getFunctionType(SqlFunction function) {
            FunctionKind kind = function.getSignature().getKind();
            switch (kind) {
                case AGGREGATE: {
                    return "aggregate";
                }
                case WINDOW: {
                    return "window";
                }
                case SCALAR: {
                    return "scalar";
                }
            }
            throw new IllegalArgumentException("Unsupported function kind: " + (Object)((Object)kind));
        }

        protected Node visitShowSession(ShowSession node, Void context) {
            ImmutableList.Builder rows = ImmutableList.builder();
            List<SessionPropertyManager.SessionPropertyValue> sessionProperties = this.metadata.getSessionPropertyManager().getAllSessionProperties(this.session, this.metadata.getCatalogNames(this.session));
            for (SessionPropertyManager.SessionPropertyValue sessionProperty : sessionProperties) {
                if (sessionProperty.isHidden()) continue;
                String value = sessionProperty.getValue();
                String defaultValue = sessionProperty.getDefaultValue();
                rows.add((Object)QueryUtil.row((Expression[])new Expression[]{new StringLiteral(sessionProperty.getFullyQualifiedName()), new StringLiteral(Strings.nullToEmpty((String)value)), new StringLiteral(Strings.nullToEmpty((String)defaultValue)), new StringLiteral(sessionProperty.getType()), new StringLiteral(sessionProperty.getDescription()), BooleanLiteral.TRUE_LITERAL}));
            }
            StringLiteral empty = new StringLiteral("");
            rows.add((Object)QueryUtil.row((Expression[])new Expression[]{empty, empty, empty, empty, empty, BooleanLiteral.FALSE_LITERAL}));
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"name", (String)"Name"), QueryUtil.aliasedName((String)"value", (String)"Value"), QueryUtil.aliasedName((String)"default", (String)"Default"), QueryUtil.aliasedName((String)"type", (String)"Type"), QueryUtil.aliasedName((String)"description", (String)"Description")}), (Relation)QueryUtil.aliased((Relation)new Values((List)rows.build()), (String)"session", (List)ImmutableList.of((Object)"name", (Object)"value", (Object)"default", (Object)"type", (Object)"description", (Object)"include")), (Expression)QueryUtil.nameReference((String)"include"));
        }

        private Query parseView(String view, QualifiedObjectName name, Node node) {
            try {
                Statement statement = this.sqlParser.createStatement(view);
                return Types.checkType(statement, Query.class, "parsed view");
            }
            catch (ParsingException e) {
                throw new SemanticException(SemanticErrorCode.VIEW_PARSE_ERROR, node, "Failed parsing stored view '%s': %s", name, e.getMessage());
            }
        }

        private static Relation from(String catalog, SchemaTableName table) {
            return QueryUtil.table((QualifiedName)QualifiedName.of((String)catalog, (String[])new String[]{table.getSchemaName(), table.getTableName()}));
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }
    }
}

