/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.util.ImmutableCollectors;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class WindowNode
extends PlanNode {
    private final PlanNode source;
    private final Set<Symbol> prePartitionedInputs;
    private final Specification specification;
    private final int preSortedOrderPrefix;
    private final Map<Symbol, Function> windowFunctions;
    private final Optional<Symbol> hashSymbol;

    @JsonCreator
    public WindowNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="specification") Specification specification, @JsonProperty(value="windowFunctions") Map<Symbol, Function> windowFunctions, @JsonProperty(value="hashSymbol") Optional<Symbol> hashSymbol, @JsonProperty(value="prePartitionedInputs") Set<Symbol> prePartitionedInputs, @JsonProperty(value="preSortedOrderPrefix") int preSortedOrderPrefix) {
        super(id);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(specification, "specification is null");
        Objects.requireNonNull(windowFunctions, "windowFunctions is null");
        Objects.requireNonNull(hashSymbol, "hashSymbol is null");
        Preconditions.checkArgument((boolean)specification.getPartitionBy().containsAll(prePartitionedInputs), (Object)"prePartitionedInputs must be contained in partitionBy");
        Preconditions.checkArgument((preSortedOrderPrefix <= specification.getOrderBy().size() ? 1 : 0) != 0, (Object)"Cannot have sorted more symbols than those requested");
        Preconditions.checkArgument((preSortedOrderPrefix == 0 || ImmutableSet.copyOf(prePartitionedInputs).equals((Object)ImmutableSet.copyOf(specification.getPartitionBy())) ? 1 : 0) != 0, (Object)"preSortedOrderPrefix can only be greater than zero if all partition symbols are pre-partitioned");
        this.source = source;
        this.prePartitionedInputs = ImmutableSet.copyOf(prePartitionedInputs);
        this.specification = specification;
        this.windowFunctions = ImmutableMap.copyOf(windowFunctions);
        this.hashSymbol = hashSymbol;
        this.preSortedOrderPrefix = preSortedOrderPrefix;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.copyOf((Iterable)Iterables.concat(this.source.getOutputSymbols(), this.windowFunctions.keySet()));
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public Specification getSpecification() {
        return this.specification;
    }

    public List<Symbol> getPartitionBy() {
        return this.specification.getPartitionBy();
    }

    public List<Symbol> getOrderBy() {
        return this.specification.getOrderBy();
    }

    public Map<Symbol, SortOrder> getOrderings() {
        return this.specification.getOrderings();
    }

    @JsonProperty
    public Map<Symbol, Function> getWindowFunctions() {
        return this.windowFunctions;
    }

    public List<Frame> getFrames() {
        return (List)this.windowFunctions.values().stream().map(Function::getFrame).collect(ImmutableCollectors.toImmutableList());
    }

    @JsonProperty
    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    @JsonProperty
    public Set<Symbol> getPrePartitionedInputs() {
        return this.prePartitionedInputs;
    }

    @JsonProperty
    public int getPreSortedOrderPrefix() {
        return this.preSortedOrderPrefix;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitWindow(this, context);
    }

    @Immutable
    public static final class Function {
        private final FunctionCall functionCall;
        private final Signature signature;
        private final Frame frame;

        @JsonCreator
        public Function(@JsonProperty(value="functionCall") FunctionCall functionCall, @JsonProperty(value="signature") Signature signature, @JsonProperty(value="frame") Frame frame) {
            this.functionCall = Objects.requireNonNull(functionCall, "functionCall is null");
            this.signature = Objects.requireNonNull(signature, "Signature is null");
            this.frame = Objects.requireNonNull(frame, "Frame is null");
        }

        @JsonProperty
        public FunctionCall getFunctionCall() {
            return this.functionCall;
        }

        @JsonProperty
        public Signature getSignature() {
            return this.signature;
        }

        @JsonProperty
        public Frame getFrame() {
            return this.frame;
        }

        public int hashCode() {
            return Objects.hash(this.functionCall, this.signature, this.frame);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Function other = (Function)obj;
            return Objects.equals(this.functionCall, other.functionCall) && Objects.equals(this.signature, other.signature) && Objects.equals(this.frame, other.frame);
        }
    }

    @Immutable
    public static class Frame {
        private final WindowFrame.Type type;
        private final FrameBound.Type startType;
        private final Optional<Symbol> startValue;
        private final FrameBound.Type endType;
        private final Optional<Symbol> endValue;

        @JsonCreator
        public Frame(@JsonProperty(value="type") WindowFrame.Type type, @JsonProperty(value="startType") FrameBound.Type startType, @JsonProperty(value="startValue") Optional<Symbol> startValue, @JsonProperty(value="endType") FrameBound.Type endType, @JsonProperty(value="endValue") Optional<Symbol> endValue) {
            this.startType = Objects.requireNonNull(startType, "startType is null");
            this.startValue = Objects.requireNonNull(startValue, "startValue is null");
            this.endType = Objects.requireNonNull(endType, "endType is null");
            this.endValue = Objects.requireNonNull(endValue, "endValue is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        @JsonProperty
        public WindowFrame.Type getType() {
            return this.type;
        }

        @JsonProperty
        public FrameBound.Type getStartType() {
            return this.startType;
        }

        @JsonProperty
        public Optional<Symbol> getStartValue() {
            return this.startValue;
        }

        @JsonProperty
        public FrameBound.Type getEndType() {
            return this.endType;
        }

        @JsonProperty
        public Optional<Symbol> getEndValue() {
            return this.endValue;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.startType, this.startValue, this.endType, this.endValue);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Frame other = (Frame)obj;
            return Objects.equals(this.type, other.type) && Objects.equals(this.startType, other.startType) && Objects.equals(this.startValue, other.startValue) && Objects.equals(this.endType, other.endType) && Objects.equals(this.endValue, other.endValue);
        }
    }

    @Immutable
    public static class Specification {
        private final List<Symbol> partitionBy;
        private final List<Symbol> orderBy;
        private final Map<Symbol, SortOrder> orderings;

        @JsonCreator
        public Specification(@JsonProperty(value="partitionBy") List<Symbol> partitionBy, @JsonProperty(value="orderBy") List<Symbol> orderBy, @JsonProperty(value="orderings") Map<Symbol, SortOrder> orderings) {
            Objects.requireNonNull(partitionBy, "partitionBy is null");
            Objects.requireNonNull(orderBy, "orderBy is null");
            Preconditions.checkArgument((orderings.size() == orderBy.size() ? 1 : 0) != 0, (Object)"orderBy and orderings sizes don't match");
            Preconditions.checkArgument((boolean)orderings.keySet().containsAll(orderBy), (Object)"Every orderBy symbol must have an ordering direction");
            this.partitionBy = ImmutableList.copyOf(partitionBy);
            this.orderBy = ImmutableList.copyOf(orderBy);
            this.orderings = ImmutableMap.copyOf(orderings);
        }

        @JsonProperty
        public List<Symbol> getPartitionBy() {
            return this.partitionBy;
        }

        @JsonProperty
        public List<Symbol> getOrderBy() {
            return this.orderBy;
        }

        @JsonProperty
        public Map<Symbol, SortOrder> getOrderings() {
            return this.orderings;
        }

        public int hashCode() {
            return Objects.hash(this.partitionBy, this.orderBy, this.orderings);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Specification other = (Specification)obj;
            return Objects.equals(this.partitionBy, other.partitionBy) && Objects.equals(this.orderBy, other.orderBy) && Objects.equals(this.orderings, other.orderings);
        }
    }
}

