/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class LimitNode
extends PlanNode {
    private final PlanNode source;
    private final long count;
    private final boolean partial;

    @JsonCreator
    public LimitNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="count") long count, @JsonProperty(value="partial") boolean partial) {
        super(id);
        this.partial = partial;
        Objects.requireNonNull(source, "source is null");
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (Object)"count must be greater than or equal to zero");
        this.source = source;
        this.count = count;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public long getCount() {
        return this.count;
    }

    @JsonProperty
    public boolean isPartial() {
        return this.partial;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.source.getOutputSymbols();
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitLimit(this, context);
    }
}

