/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ApplyNode
extends PlanNode {
    private final PlanNode input;
    private final PlanNode subquery;
    private final List<Symbol> correlation;

    @JsonCreator
    public ApplyNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="input") PlanNode input, @JsonProperty(value="subquery") PlanNode subquery, @JsonProperty(value="correlation") List<Symbol> correlation) {
        super(id);
        Objects.requireNonNull(input, "input is null");
        Objects.requireNonNull(subquery, "right is null");
        Objects.requireNonNull(correlation, "correlation is null");
        Preconditions.checkArgument((boolean)input.getOutputSymbols().containsAll(correlation), (Object)"Input does not contain symbols from correlation");
        this.input = input;
        this.subquery = subquery;
        this.correlation = ImmutableList.copyOf(correlation);
    }

    @JsonProperty(value="input")
    public PlanNode getInput() {
        return this.input;
    }

    @JsonProperty(value="subquery")
    public PlanNode getSubquery() {
        return this.subquery;
    }

    @JsonProperty(value="correlation")
    public List<Symbol> getCorrelation() {
        return this.correlation;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.input, (Object)this.subquery);
    }

    @Override
    @JsonProperty(value="outputSymbols")
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.input.getOutputSymbols()).addAll(this.subquery.getOutputSymbols()).build();
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitApply(this, context);
    }
}

