/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExceptNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.IntersectNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SetOperationNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class UnaliasSymbolReferences
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(), plan);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final Map<Symbol, Symbol> mapping = new HashMap<Symbol, Symbol>();

        private Rewriter() {
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableMap.Builder functionInfos = ImmutableMap.builder();
            ImmutableMap.Builder functionCalls = ImmutableMap.builder();
            ImmutableMap.Builder masks = ImmutableMap.builder();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                Symbol symbol = entry.getKey();
                Symbol canonical = this.canonicalize(symbol);
                FunctionCall canonicalCall = (FunctionCall)this.canonicalize((Expression)entry.getValue());
                functionCalls.put((Object)canonical, (Object)canonicalCall);
                functionInfos.put((Object)canonical, (Object)node.getFunctions().get(symbol));
            }
            for (Map.Entry<Symbol, Object> entry : node.getMasks().entrySet()) {
                masks.put((Object)this.canonicalize(entry.getKey()), (Object)this.canonicalize((Symbol)entry.getValue()));
            }
            List groupingSets = (List)node.getGroupingSets().stream().map(this::canonicalizeAndDistinct).collect(ImmutableCollectors.toImmutableList());
            return new AggregationNode(node.getId(), source, (Map<Symbol, FunctionCall>)functionCalls.build(), (Map<Symbol, Signature>)functionInfos.build(), (Map<Symbol, Symbol>)masks.build(), groupingSets, node.getStep(), this.canonicalize(node.getHashSymbol()), this.canonicalize(node.getGroupIdSymbol()));
        }

        @Override
        public PlanNode visitGroupId(GroupIdNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            HashMap<Symbol, Symbol> newGroupingMappings = new HashMap<Symbol, Symbol>();
            ImmutableList.Builder newGroupingSets = ImmutableList.builder();
            for (List<Symbol> groupingSet : node.getGroupingSets()) {
                ImmutableList.Builder newGroupingSet = ImmutableList.builder();
                for (Symbol output : groupingSet) {
                    newGroupingMappings.putIfAbsent(this.canonicalize(output), this.canonicalize(node.getGroupingSetMappings().get(output)));
                    newGroupingSet.add((Object)this.canonicalize(output));
                }
                newGroupingSets.add((Object)newGroupingSet.build());
            }
            HashMap<Symbol, Symbol> newArgumentMappings = new HashMap<Symbol, Symbol>();
            for (Symbol output : node.getArgumentMappings().keySet()) {
                Symbol canonicalOutput = this.canonicalize(output);
                if (newArgumentMappings.containsKey(canonicalOutput)) {
                    this.map(output, canonicalOutput);
                    continue;
                }
                newArgumentMappings.put(canonicalOutput, this.canonicalize(node.getArgumentMappings().get(output)));
            }
            return new GroupIdNode(node.getId(), source, (List<List<Symbol>>)newGroupingSets.build(), newGroupingMappings, newArgumentMappings, this.canonicalize(node.getGroupIdSymbol()));
        }

        @Override
        public PlanNode visitExplainAnalyze(ExplainAnalyzeNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new ExplainAnalyzeNode(node.getId(), source, this.canonicalize(node.getOutputSymbol()));
        }

        @Override
        public PlanNode visitMarkDistinct(MarkDistinctNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            List<Symbol> symbols = this.canonicalizeAndDistinct(node.getDistinctSymbols());
            return new MarkDistinctNode(node.getId(), source, this.canonicalize(node.getMarkerSymbol()), symbols, this.canonicalize(node.getHashSymbol()));
        }

        @Override
        public PlanNode visitUnnest(UnnestNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<Symbol, List<Symbol>> entry : node.getUnnestSymbols().entrySet()) {
                builder.put((Object)this.canonicalize(entry.getKey()), entry.getValue());
            }
            return new UnnestNode(node.getId(), source, this.canonicalizeAndDistinct(node.getReplicateSymbols()), (Map<Symbol, List<Symbol>>)builder.build(), node.getOrdinalitySymbol());
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableMap.Builder functions = ImmutableMap.builder();
            ImmutableMap.Builder frames = ImmutableMap.builder();
            for (Map.Entry<Symbol, WindowNode.Function> entry : node.getWindowFunctions().entrySet()) {
                Symbol symbol = entry.getKey();
                FunctionCall canonicalFunctionCall = (FunctionCall)this.canonicalize((Expression)entry.getValue().getFunctionCall());
                Signature signature = entry.getValue().getSignature();
                WindowNode.Frame canonicalFrame = this.canonicalize(entry.getValue().getFrame());
                functions.put((Object)this.canonicalize(symbol), (Object)new WindowNode.Function(canonicalFunctionCall, signature, canonicalFrame));
            }
            ImmutableMap.Builder orderings = ImmutableMap.builder();
            for (Map.Entry<Symbol, SortOrder> entry : node.getOrderings().entrySet()) {
                orderings.put((Object)this.canonicalize(entry.getKey()), (Object)entry.getValue());
            }
            return new WindowNode(node.getId(), source, this.canonicalizeAndDistinct(node.getSpecification()), (Map<Symbol, WindowNode.Function>)functions.build(), this.canonicalize(node.getHashSymbol()), this.canonicalize(node.getPrePartitionedInputs()), node.getPreSortedOrderPrefix());
        }

        private WindowNode.Frame canonicalize(WindowNode.Frame frame) {
            return new WindowNode.Frame(frame.getType(), frame.getStartType(), this.canonicalize(frame.getStartValue()), frame.getEndType(), this.canonicalize(frame.getEndValue()));
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            Expression originalConstraint = null;
            if (node.getOriginalConstraint() != null) {
                originalConstraint = this.canonicalize(node.getOriginalConstraint());
            }
            return new TableScanNode(node.getId(), node.getTable(), node.getOutputSymbols(), node.getAssignments(), node.getLayout(), node.getCurrentConstraint(), originalConstraint);
        }

        @Override
        public PlanNode visitExchange(ExchangeNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            List sources = (List)node.getSources().stream().map(context::rewrite).collect(ImmutableCollectors.toImmutableList());
            ArrayList<List<Symbol>> inputs = new ArrayList<List<Symbol>>();
            for (int i = 0; i < node.getInputs().size(); ++i) {
                inputs.add(new ArrayList());
            }
            HashSet<Symbol> addedOutputs = new HashSet<Symbol>();
            ImmutableList.Builder outputs = ImmutableList.builder();
            for (int symbolIndex = 0; symbolIndex < node.getOutputSymbols().size(); ++symbolIndex) {
                Symbol canonicalOutput = this.canonicalize(node.getOutputSymbols().get(symbolIndex));
                if (!addedOutputs.add(canonicalOutput)) continue;
                outputs.add((Object)canonicalOutput);
                for (int i = 0; i < node.getInputs().size(); ++i) {
                    List<Symbol> input = node.getInputs().get(i);
                    ((List)inputs.get(i)).add(this.canonicalize(input.get(symbolIndex)));
                }
            }
            PartitioningScheme partitioningScheme = new PartitioningScheme(node.getPartitioningScheme().getPartitioning().translate(this::canonicalize), (List<Symbol>)outputs.build(), this.canonicalize(node.getPartitioningScheme().getHashColumn()), node.getPartitioningScheme().isReplicateNulls(), node.getPartitioningScheme().getBucketToPartition());
            return new ExchangeNode(node.getId(), node.getType(), node.getScope(), partitioningScheme, sources, inputs);
        }

        @Override
        public PlanNode visitRemoteSource(RemoteSourceNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new RemoteSourceNode(node.getId(), node.getSourceFragmentIds(), this.canonicalizeAndDistinct(node.getOutputSymbols()));
        }

        @Override
        public PlanNode visitLimit(LimitNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return context.defaultRewrite(node);
        }

        @Override
        public PlanNode visitDistinctLimit(DistinctLimitNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new DistinctLimitNode(node.getId(), context.rewrite(node.getSource()), node.getLimit(), node.isPartial(), this.canonicalize(node.getHashSymbol()));
        }

        @Override
        public PlanNode visitSample(SampleNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new SampleNode(node.getId(), context.rewrite(node.getSource()), node.getSampleRatio(), node.getSampleType());
        }

        @Override
        public PlanNode visitValues(ValuesNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return context.defaultRewrite(node);
        }

        @Override
        public PlanNode visitDelete(DeleteNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new DeleteNode(node.getId(), context.rewrite(node.getSource()), node.getTarget(), this.canonicalize(node.getRowId()), node.getOutputSymbols());
        }

        @Override
        public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return context.defaultRewrite(node);
        }

        @Override
        public PlanNode visitRowNumber(RowNumberNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new RowNumberNode(node.getId(), context.rewrite(node.getSource()), this.canonicalizeAndDistinct(node.getPartitionBy()), this.canonicalize(node.getRowNumberSymbol()), node.getMaxRowCountPerPartition(), this.canonicalize(node.getHashSymbol()));
        }

        @Override
        public PlanNode visitTopNRowNumber(TopNRowNumberNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new TopNRowNumberNode(node.getId(), context.rewrite(node.getSource()), this.canonicalizeAndDistinct(node.getSpecification()), this.canonicalize(node.getRowNumberSymbol()), node.getMaxRowCountPerPartition(), node.isPartial(), this.canonicalize(node.getHashSymbol()));
        }

        @Override
        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new FilterNode(node.getId(), source, this.canonicalize(node.getPredicate()));
        }

        @Override
        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            HashMap<Expression, Symbol> computedExpressions = new HashMap<Expression, Symbol>();
            LinkedHashMap<Symbol, Expression> assignments = new LinkedHashMap<Symbol, Expression>();
            for (Map.Entry<Symbol, Expression> entry : node.getAssignments().entrySet()) {
                Symbol canonical;
                Expression expression = this.canonicalize(entry.getValue());
                if (expression instanceof SymbolReference) {
                    Symbol symbol = Symbol.from(expression);
                    if (!symbol.equals(entry.getKey())) {
                        this.map(entry.getKey(), symbol);
                    }
                } else if (DeterminismEvaluator.isDeterministic(expression) && !(expression instanceof NullLiteral)) {
                    Symbol computedSymbol = (Symbol)computedExpressions.get(expression);
                    if (computedSymbol == null) {
                        computedExpressions.put(expression, entry.getKey());
                    } else {
                        this.map(entry.getKey(), computedSymbol);
                    }
                }
                if (assignments.containsKey(canonical = this.canonicalize(entry.getKey()))) continue;
                assignments.put(canonical, expression);
            }
            return new ProjectNode(node.getId(), source, assignments);
        }

        @Override
        public PlanNode visitOutput(OutputNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            List canonical = Lists.transform(node.getOutputSymbols(), this::canonicalize);
            return new OutputNode(node.getId(), source, node.getColumnNames(), canonical);
        }

        @Override
        public PlanNode visitEnforceSingleRow(EnforceSingleRowNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new EnforceSingleRowNode(node.getId(), source);
        }

        @Override
        public PlanNode visitAssignUniqueId(AssignUniqueId node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            return new AssignUniqueId(node.getId(), source, node.getIdColumn());
        }

        @Override
        public PlanNode visitApply(ApplyNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getInput());
            PlanNode subquery = context.rewrite(node.getSubquery());
            List canonicalCorrelation = Lists.transform(node.getCorrelation(), this::canonicalize);
            return new ApplyNode(node.getId(), source, subquery, canonicalCorrelation);
        }

        @Override
        public PlanNode visitTopN(TopNNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableList.Builder symbols = ImmutableList.builder();
            ImmutableMap.Builder orderings = ImmutableMap.builder();
            for (Symbol symbol : node.getOrderBy()) {
                Symbol canonical = this.canonicalize(symbol);
                symbols.add((Object)canonical);
                orderings.put((Object)canonical, (Object)node.getOrderings().get(symbol));
            }
            return new TopNNode(node.getId(), source, node.getCount(), (List<Symbol>)symbols.build(), (Map<Symbol, SortOrder>)orderings.build(), node.isPartial());
        }

        @Override
        public PlanNode visitSort(SortNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableList.Builder symbols = ImmutableList.builder();
            ImmutableMap.Builder orderings = ImmutableMap.builder();
            for (Symbol symbol : node.getOrderBy()) {
                Symbol canonical = this.canonicalize(symbol);
                symbols.add((Object)canonical);
                orderings.put((Object)canonical, (Object)node.getOrderings().get(symbol));
            }
            return new SortNode(node.getId(), source, (List<Symbol>)symbols.build(), (Map<Symbol, SortOrder>)orderings.build());
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode left = context.rewrite(node.getLeft());
            PlanNode right = context.rewrite(node.getRight());
            return new JoinNode(node.getId(), node.getType(), left, right, this.canonicalizeJoinCriteria(node.getCriteria()), node.getFilter().map(this::canonicalize), this.canonicalize(node.getLeftHashSymbol()), this.canonicalize(node.getRightHashSymbol()));
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            PlanNode filteringSource = context.rewrite(node.getFilteringSource());
            return new SemiJoinNode(node.getId(), source, filteringSource, this.canonicalize(node.getSourceJoinSymbol()), this.canonicalize(node.getFilteringSourceJoinSymbol()), this.canonicalize(node.getSemiJoinOutput()), this.canonicalize(node.getSourceHashSymbol()), this.canonicalize(node.getFilteringSourceHashSymbol()));
        }

        @Override
        public PlanNode visitIndexSource(IndexSourceNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new IndexSourceNode(node.getId(), node.getIndexHandle(), node.getTableHandle(), node.getLayout(), this.canonicalize(node.getLookupSymbols()), node.getOutputSymbols(), node.getAssignments(), node.getEffectiveTupleDomain());
        }

        @Override
        public PlanNode visitIndexJoin(IndexJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode probeSource = context.rewrite(node.getProbeSource());
            PlanNode indexSource = context.rewrite(node.getIndexSource());
            return new IndexJoinNode(node.getId(), node.getType(), probeSource, indexSource, this.canonicalizeIndexJoinCriteria(node.getCriteria()), this.canonicalize(node.getProbeHashSymbol()), this.canonicalize(node.getIndexHashSymbol()));
        }

        @Override
        public PlanNode visitUnion(UnionNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new UnionNode(node.getId(), (List<PlanNode>)this.rewriteSources(node, context).build(), this.canonicalizeSetOperationSymbolMap(node.getSymbolMapping()), this.canonicalize(node.getOutputSymbols()));
        }

        @Override
        public PlanNode visitIntersect(IntersectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new IntersectNode(node.getId(), (List<PlanNode>)this.rewriteSources(node, context).build(), this.canonicalizeSetOperationSymbolMap(node.getSymbolMapping()), this.canonicalize(node.getOutputSymbols()));
        }

        @Override
        public PlanNode visitExcept(ExceptNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return new ExceptNode(node.getId(), (List<PlanNode>)this.rewriteSources(node, context).build(), this.canonicalizeSetOperationSymbolMap(node.getSymbolMapping()), this.canonicalize(node.getOutputSymbols()));
        }

        private ImmutableList.Builder<PlanNode> rewriteSources(SetOperationNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            ImmutableList.Builder rewrittenSources = ImmutableList.builder();
            for (PlanNode source : node.getSources()) {
                rewrittenSources.add((Object)context.rewrite(source));
            }
            return rewrittenSources;
        }

        @Override
        public PlanNode visitTableWriter(TableWriterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableList columns = node.getColumns().stream().map(this::canonicalize).collect(ImmutableCollectors.toImmutableList());
            return new TableWriterNode(node.getId(), source, node.getTarget(), (List<Symbol>)columns, node.getColumnNames(), node.getOutputSymbols(), node.getPartitioningScheme().map(partitioningScheme -> this.canonicalizePartitionFunctionBinding((PartitioningScheme)partitioningScheme, source)));
        }

        @Override
        protected PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            throw new UnsupportedOperationException("Unsupported plan node " + node.getClass().getSimpleName());
        }

        private void map(Symbol symbol, Symbol canonical) {
            Preconditions.checkArgument((!symbol.equals(canonical) ? 1 : 0) != 0, (String)"Can't map symbol to itself: %s", (Object[])new Object[]{symbol});
            this.mapping.put(symbol, canonical);
        }

        private Optional<Symbol> canonicalize(Optional<Symbol> symbol) {
            if (symbol.isPresent()) {
                return Optional.of(this.canonicalize(symbol.get()));
            }
            return Optional.empty();
        }

        private Symbol canonicalize(Symbol symbol) {
            Symbol canonical = symbol;
            while (this.mapping.containsKey(canonical)) {
                canonical = this.mapping.get(canonical);
            }
            return canonical;
        }

        private Expression canonicalize(Expression value) {
            return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

                public Expression rewriteSymbolReference(SymbolReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                    Symbol canonical = this.canonicalize(Symbol.from((Expression)node));
                    return canonical.toSymbolReference();
                }
            }, (Expression)value);
        }

        private List<Symbol> canonicalizeAndDistinct(List<Symbol> outputs) {
            HashSet<Symbol> added = new HashSet<Symbol>();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Symbol symbol : outputs) {
                Symbol canonical = this.canonicalize(symbol);
                if (!added.add(canonical)) continue;
                builder.add((Object)canonical);
            }
            return builder.build();
        }

        private WindowNode.Specification canonicalizeAndDistinct(WindowNode.Specification specification) {
            ImmutableMap.Builder orderings = ImmutableMap.builder();
            for (Map.Entry<Symbol, SortOrder> entry : specification.getOrderings().entrySet()) {
                orderings.put((Object)this.canonicalize(entry.getKey()), (Object)entry.getValue());
            }
            return new WindowNode.Specification(this.canonicalizeAndDistinct(specification.getPartitionBy()), this.canonicalizeAndDistinct(specification.getOrderBy()), (Map<Symbol, SortOrder>)orderings.build());
        }

        private List<Symbol> canonicalize(List<Symbol> symbols) {
            return (List)symbols.stream().map(this::canonicalize).collect(ImmutableCollectors.toImmutableList());
        }

        private Set<Symbol> canonicalize(Set<Symbol> symbols) {
            return (Set)symbols.stream().map(this::canonicalize).collect(ImmutableCollectors.toImmutableSet());
        }

        private List<JoinNode.EquiJoinClause> canonicalizeJoinCriteria(List<JoinNode.EquiJoinClause> criteria) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JoinNode.EquiJoinClause clause : criteria) {
                builder.add((Object)new JoinNode.EquiJoinClause(this.canonicalize(clause.getLeft()), this.canonicalize(clause.getRight())));
            }
            return builder.build();
        }

        private List<IndexJoinNode.EquiJoinClause> canonicalizeIndexJoinCriteria(List<IndexJoinNode.EquiJoinClause> criteria) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (IndexJoinNode.EquiJoinClause clause : criteria) {
                builder.add((Object)new IndexJoinNode.EquiJoinClause(this.canonicalize(clause.getProbe()), this.canonicalize(clause.getIndex())));
            }
            return builder.build();
        }

        private ListMultimap<Symbol, Symbol> canonicalizeSetOperationSymbolMap(ListMultimap<Symbol, Symbol> setOperationSymbolMap) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (Map.Entry entry : setOperationSymbolMap.asMap().entrySet()) {
                builder.putAll((Object)this.canonicalize((Symbol)entry.getKey()), Iterables.transform((Iterable)((Iterable)entry.getValue()), this::canonicalize));
            }
            return builder.build();
        }

        private PartitioningScheme canonicalizePartitionFunctionBinding(PartitioningScheme scheme, PlanNode source) {
            HashSet<Symbol> addedOutputs = new HashSet<Symbol>();
            ImmutableList.Builder outputs = ImmutableList.builder();
            for (Symbol symbol : source.getOutputSymbols()) {
                Symbol canonicalOutput = this.canonicalize(symbol);
                if (!addedOutputs.add(canonicalOutput)) continue;
                outputs.add((Object)canonicalOutput);
            }
            return new PartitioningScheme(scheme.getPartitioning().translate(this::canonicalize), (List<Symbol>)outputs.build(), this.canonicalize(scheme.getHashColumn()), scheme.isReplicateNulls(), scheme.getBucketToPartition());
        }
    }
}

