/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.ExpressionNodeInliner;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.ApplyNodeRewriter;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TransformUncorrelatedInPredicateSubqueryToSemiJoin
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        return SimplePlanRewriter.rewriteWith(new InPredicateRewriter(idAllocator, symbolAllocator), plan, null);
    }

    private static List<InPredicate> extractApplyInPredicates(Collection<Expression> expressions) {
        final ImmutableList.Builder inPredicates = ImmutableList.builder();
        for (Expression expression : expressions) {
            new DefaultTraversalVisitor<Void, Void>(){

                protected Void visitInPredicate(InPredicate node, Void context) {
                    if (node.getValueList() instanceof SymbolReference) {
                        inPredicates.add((Object)node);
                    }
                    return null;
                }
            }.process((Node)expression, null);
        }
        return inPredicates.build();
    }

    private static class InsertSemiJoinRewriter
    extends ApplyNodeRewriter {
        private final PlanNodeIdAllocator idAllocator;
        private final SymbolAllocator symbolAllocator;
        private final InPredicate originalInPredicate;
        private InPredicate inPredicate;
        private Optional<Symbol> semiJoinSymbol = Optional.empty();

        public InsertSemiJoinRewriter(PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, InPredicate inPredicate) {
            super((SymbolReference)inPredicate.getValueList());
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
            this.inPredicate = Objects.requireNonNull(inPredicate, "inPredicate is null");
            this.originalInPredicate = Objects.requireNonNull(inPredicate, "inPredicate is null");
        }

        @Override
        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            this.inPredicate = (InPredicate)ExpressionNodeInliner.replaceExpression((Expression)this.inPredicate, InsertSemiJoinRewriter.mapAssignmentSymbolsToExpression(node.getAssignments()));
            ProjectNode rewrittenNode = (ProjectNode)context.defaultRewrite(node);
            if (this.semiJoinSymbol.isPresent()) {
                return this.appendIdentityProjection(rewrittenNode, this.semiJoinSymbol.get());
            }
            return rewrittenNode;
        }

        private ProjectNode appendIdentityProjection(ProjectNode node, Symbol symbol) {
            if (node.getOutputSymbols().contains(symbol)) {
                return node;
            }
            if (node.getSource().getOutputSymbols().contains(symbol)) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.putAll(node.getAssignments());
                builder.put((Object)symbol, (Object)symbol.toSymbolReference());
                return new ProjectNode(node.getId(), node.getSource(), (Map<Symbol, Expression>)builder.build());
            }
            return node;
        }

        @Override
        protected PlanNode rewriteApply(ApplyNode node) {
            if (node.getCorrelation().isEmpty()) {
                Symbol value = Symbol.from(this.inPredicate.getValue());
                Symbol valueList = Symbol.from(this.inPredicate.getValueList());
                Preconditions.checkState((!this.semiJoinSymbol.isPresent() ? 1 : 0) != 0, (Object)"Semi join symbol is already set");
                this.semiJoinSymbol = Optional.of(this.symbolAllocator.newSymbol("semijoin_result", (Type)BooleanType.BOOLEAN));
                return new SemiJoinNode(this.idAllocator.getNextId(), node.getInput(), node.getSubquery(), value, valueList, this.semiJoinSymbol.get(), Optional.empty(), Optional.empty());
            }
            return node;
        }

        public Map<InPredicate, Expression> getInPredicateMapping() {
            if (!this.semiJoinSymbol.isPresent()) {
                return ImmutableMap.of();
            }
            return ImmutableMap.of((Object)this.originalInPredicate, (Object)this.semiJoinSymbol.get().toSymbolReference());
        }
    }

    private static class InPredicateRewriter
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final SymbolAllocator symbolAllocator;
        private final List<Map<InPredicate, Expression>> inPredicateMappings = new ArrayList<Map<InPredicate, Expression>>();

        public InPredicateRewriter(PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        }

        @Override
        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode rewrittenNode = this.rewriteInPredicates(context.defaultRewrite(node, context.get()), node.getPredicate());
            return new FilterNode(rewrittenNode.getId(), (PlanNode)Iterables.getOnlyElement(rewrittenNode.getSources()), this.replaceInPredicates(node.getPredicate()));
        }

        @Override
        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode rewrittenNode = this.rewriteInPredicates(context.defaultRewrite(node, context.get()), node.getAssignments().values());
            if (this.inPredicateMappings.isEmpty()) {
                return rewrittenNode;
            }
            return new ProjectNode(rewrittenNode.getId(), (PlanNode)Iterables.getOnlyElement(rewrittenNode.getSources()), this.replaceInPredicateInAssignments(node));
        }

        private PlanNode rewriteInPredicates(PlanNode node, Expression expressions) {
            return this.rewriteInPredicates(node, (Collection<Expression>)ImmutableList.of((Object)expressions));
        }

        private PlanNode rewriteInPredicates(PlanNode node, Collection<Expression> expressions) {
            List inPredicates = TransformUncorrelatedInPredicateSubqueryToSemiJoin.extractApplyInPredicates(expressions);
            ImmutableMap.Builder inPredicateMapping = ImmutableMap.builder();
            PlanNode rewrittenNode = node;
            for (InPredicate inPredicate : inPredicates) {
                InsertSemiJoinRewriter rewriter = new InsertSemiJoinRewriter(this.idAllocator, this.symbolAllocator, inPredicate);
                rewrittenNode = InPredicateRewriter.rewriteWith(rewriter, rewrittenNode, null);
                inPredicateMapping.putAll(rewriter.getInPredicateMapping());
            }
            this.inPredicateMappings.add((Map<InPredicate, Expression>)inPredicateMapping.build());
            return rewrittenNode;
        }

        private Map<Symbol, Expression> replaceInPredicateInAssignments(ProjectNode node) {
            ImmutableMap.Builder assignmentsBuilder = ImmutableMap.builder();
            Map<Symbol, Expression> assignments = node.getAssignments();
            for (Symbol symbol : assignments.keySet()) {
                assignmentsBuilder.put((Object)symbol, (Object)this.replaceInPredicates(assignments.get(symbol)));
            }
            return assignmentsBuilder.build();
        }

        private Expression replaceInPredicates(Expression expression) {
            for (Map<InPredicate, Expression> inPredicateMapping : this.inPredicateMappings) {
                expression = ExpressionNodeInliner.replaceExpression(expression, inPredicateMapping);
            }
            return expression;
        }
    }
}

