/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.NullLiteral;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SingleDistinctOptimizer
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        return PlanRewriter.rewriteWith(new Optimizer(idAllocator), plan, Optional.empty()).getPlanNode();
    }

    private static class Optimizer
    extends PlanRewriter<Optional<Symbol>, Boolean> {
        private final PlanNodeIdAllocator idAllocator;

        private Optimizer(PlanNodeIdAllocator idAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        }

        @Override
        public PlanRewriter.Result<Boolean> visitAggregation(AggregationNode node, PlanRewriter.RewriteContext<Optional<Symbol>, Boolean> context) {
            ImmutableSet masks = ImmutableSet.copyOf(node.getMasks().values());
            if (masks.size() != 1 || node.getMasks().size() != node.getAggregations().size()) {
                return context.defaultRewrite((PlanNode)node, Optional.empty());
            }
            if (node.getAggregations().values().stream().map(FunctionCall::getFilter).anyMatch(Optional::isPresent)) {
                return context.defaultRewrite((PlanNode)node, Optional.empty());
            }
            PlanRewriter.Result<Boolean> source = context.rewrite(node.getSource(), Optional.of(Iterables.getOnlyElement((Iterable)masks)));
            if (source.getPayload() == null || !source.getPayload().booleanValue()) {
                return context.defaultRewrite((PlanNode)node, Optional.empty());
            }
            ImmutableMap aggregations = ImmutableMap.copyOf((Map)Maps.transformValues(node.getAggregations(), call -> new FunctionCall(call.getName(), call.getWindow(), false, call.getArguments())));
            return new PlanRewriter.Result<Boolean>(new AggregationNode(this.idAllocator.getNextId(), source.getPlanNode(), (Map<Symbol, FunctionCall>)aggregations, node.getFunctions(), Collections.emptyMap(), node.getGroupingSets(), node.getStep(), node.getHashSymbol(), node.getGroupIdSymbol()), false);
        }

        @Override
        public PlanRewriter.Result<Boolean> visitMarkDistinct(MarkDistinctNode node, PlanRewriter.RewriteContext<Optional<Symbol>, Boolean> context) {
            Optional<Symbol> mask = context.get();
            if (!mask.isPresent() || !mask.get().equals(node.getMarkerSymbol())) {
                return context.defaultRewrite((PlanNode)node, Optional.empty());
            }
            AggregationNode aggregationNode = new AggregationNode(this.idAllocator.getNextId(), context.rewrite(node.getSource(), Optional.empty()).getPlanNode(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), (List<List<Symbol>>)ImmutableList.of(node.getDistinctSymbols()), AggregationNode.Step.SINGLE, node.getHashSymbol(), Optional.empty());
            ImmutableMap.Builder outputSymbols = ImmutableMap.builder();
            for (Symbol symbol : aggregationNode.getOutputSymbols()) {
                outputSymbols.put((Object)symbol, (Object)symbol.toSymbolReference());
            }
            outputSymbols.put((Object)mask.get(), (Object)new NullLiteral());
            return new PlanRewriter.Result<Boolean>(new ProjectNode(this.idAllocator.getNextId(), aggregationNode, (Map<Symbol, Expression>)outputSymbols.build()), true);
        }
    }
}

