/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;

public class EvaluateConstantApply
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        return SimplePlanRewriter.rewriteWith(new Rewriter(), plan);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private Rewriter() {
        }

        @Override
        public PlanNode visitApply(ApplyNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            if (!node.getCorrelation().isEmpty()) {
                return context.defaultRewrite(node);
            }
            if (!(node.getInput() instanceof ValuesNode) || !(node.getSubquery() instanceof ValuesNode)) {
                return context.defaultRewrite(node);
            }
            ValuesNode outer = (ValuesNode)node.getInput();
            ValuesNode inner = (ValuesNode)node.getSubquery();
            ImmutableList.Builder result = ImmutableList.builder();
            for (List<Expression> outerRow : outer.getRows()) {
                for (List<Expression> innerRow : inner.getRows()) {
                    result.add((Object)ImmutableList.builder().addAll(outerRow).addAll(innerRow).build());
                }
            }
            return new ValuesNode(node.getId(), node.getOutputSymbols(), (List<List<Expression>>)result.build());
        }
    }
}

