/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.SemanticExceptions;
import com.facebook.presto.sql.planner.ExpressionExtractor;
import com.facebook.presto.sql.planner.ExpressionNodeInliner;
import com.facebook.presto.sql.planner.ParameterRewriter;
import com.facebook.presto.sql.planner.PlanBuilder;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.RelationPlanner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.optimizations.Predicates;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.ComparisonExpressionType;
import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.util.AstUtils;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class SubqueryPlanner {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Metadata metadata;
    private final Session session;
    private final List<Expression> parameters;

    SubqueryPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, Session session, List<Expression> parameters) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(parameters, "parameters is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.metadata = metadata;
        this.session = session;
        this.parameters = parameters;
    }

    public PlanBuilder handleSubqueries(PlanBuilder builder, Collection<Expression> expressions, Node node) {
        for (Expression expression : expressions) {
            builder = this.handleSubqueries(builder, expression, node, true);
        }
        return builder;
    }

    public PlanBuilder handleUncorrelatedSubqueries(PlanBuilder builder, Collection<Expression> expressions, Node node) {
        for (Expression expression : expressions) {
            builder = this.handleSubqueries(builder, expression, node, false);
        }
        return builder;
    }

    public PlanBuilder handleSubqueries(PlanBuilder builder, Expression expression, Node node) {
        return this.handleSubqueries(builder, expression, node, true);
    }

    private PlanBuilder handleSubqueries(PlanBuilder builder, Expression expression, Node node, boolean correlationAllowed) {
        builder = this.appendInPredicateApplyNodes(builder, this.collectInPredicateSubqueries(expression, node), correlationAllowed);
        builder = this.appendScalarSubqueryApplyNodes(builder, this.collectScalarSubqueries(expression, node), correlationAllowed);
        builder = this.appendExistsSubqueryApplyNodes(builder, this.collectExistsSubqueries(expression, node), correlationAllowed);
        builder = this.appendQuantifiedComparisonApplyNodes(builder, this.collectQuantifiedComparisonSubqueries(expression, node), correlationAllowed);
        return builder;
    }

    public Set<InPredicate> collectInPredicateSubqueries(Expression expression, Node node) {
        return (Set)this.analysis.getInPredicateSubqueries(node).stream().filter(inPredicate -> AstUtils.nodeContains((Node)expression, (Node)inPredicate.getValueList())).collect(ImmutableCollectors.toImmutableSet());
    }

    public Set<SubqueryExpression> collectScalarSubqueries(Expression expression, Node node) {
        return (Set)this.analysis.getScalarSubqueries(node).stream().filter(subquery -> AstUtils.nodeContains((Node)expression, (Node)subquery)).collect(ImmutableCollectors.toImmutableSet());
    }

    public Set<ExistsPredicate> collectExistsSubqueries(Expression expression, Node node) {
        return (Set)this.analysis.getExistsSubqueries(node).stream().filter(subquery -> AstUtils.nodeContains((Node)expression, (Node)subquery)).collect(ImmutableCollectors.toImmutableSet());
    }

    public Set<QuantifiedComparisonExpression> collectQuantifiedComparisonSubqueries(Expression expression, Node node) {
        return (Set)this.analysis.getQuantifiedComparisonSubqueries(node).stream().filter(quantifiedComparison -> AstUtils.nodeContains((Node)expression, (Node)quantifiedComparison.getSubquery())).collect(ImmutableCollectors.toImmutableSet());
    }

    private PlanBuilder appendInPredicateApplyNodes(PlanBuilder subPlan, Set<InPredicate> inPredicates, boolean correlationAllowed) {
        for (InPredicate inPredicate : inPredicates) {
            subPlan = this.appendInPredicateApplyNode(subPlan, inPredicate, correlationAllowed);
        }
        return subPlan;
    }

    private PlanBuilder appendInPredicateApplyNode(PlanBuilder subPlan, InPredicate inPredicate, boolean correlationAllowed) {
        subPlan = subPlan.appendProjections((Iterable<Expression>)ImmutableList.of((Object)inPredicate.getValue()), this.symbolAllocator, this.idAllocator);
        Preconditions.checkState((boolean)(inPredicate.getValueList() instanceof SubqueryExpression));
        PlanNode subquery = this.createRelationPlan(((SubqueryExpression)inPredicate.getValueList()).getQuery()).getRoot();
        Map<Expression, Symbol> correlation = this.extractCorrelation(subPlan, subquery);
        if (!correlationAllowed && correlation.isEmpty()) {
            SemanticExceptions.throwNotSupportedException((Node)inPredicate, "Correlated subquery in given context");
        }
        subPlan = subPlan.appendProjections(correlation.keySet(), this.symbolAllocator, this.idAllocator);
        subquery = this.replaceExpressionsWithSymbols(subquery, correlation);
        TranslationMap translationMap = subPlan.copyTranslations();
        InPredicate parametersReplaced = (InPredicate)ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.parameters, this.analysis), (Expression)inPredicate);
        translationMap.addIntermediateMapping((Expression)inPredicate, (Expression)parametersReplaced);
        SymbolReference valueList = ((Symbol)Iterables.getOnlyElement(subquery.getOutputSymbols())).toSymbolReference();
        translationMap.addIntermediateMapping((Expression)parametersReplaced, (Expression)new InPredicate(parametersReplaced.getValue(), (Expression)valueList));
        return new PlanBuilder(translationMap, new ApplyNode(this.idAllocator.getNextId(), subPlan.getRoot(), subquery, (List<Symbol>)ImmutableList.copyOf(correlation.values())), this.analysis.getParameters());
    }

    private PlanBuilder appendScalarSubqueryApplyNodes(PlanBuilder builder, Set<SubqueryExpression> scalarSubqueries, boolean correlationAllowed) {
        for (SubqueryExpression scalarSubquery : scalarSubqueries) {
            builder = this.appendScalarSubqueryApplyNode(builder, scalarSubquery, correlationAllowed);
        }
        return builder;
    }

    private PlanBuilder appendScalarSubqueryApplyNode(PlanBuilder subPlan, SubqueryExpression scalarSubquery, boolean correlationAllowed) {
        if (subPlan.canTranslate((Expression)scalarSubquery)) {
            return subPlan;
        }
        return this.appendSubqueryApplyNode(subPlan, (Expression)scalarSubquery, (Node)scalarSubquery.getQuery(), new EnforceSingleRowNode(this.idAllocator.getNextId(), this.createRelationPlan(scalarSubquery.getQuery()).getRoot()), correlationAllowed);
    }

    private PlanBuilder appendExistsSubqueryApplyNodes(PlanBuilder builder, Set<ExistsPredicate> existsPredicates, boolean correlationAllowed) {
        for (ExistsPredicate existsPredicate : existsPredicates) {
            builder = this.appendExistSubqueryApplyNode(builder, existsPredicate, correlationAllowed);
        }
        return builder;
    }

    private PlanBuilder appendExistSubqueryApplyNode(PlanBuilder subPlan, ExistsPredicate existsPredicate, boolean correlationAllowed) {
        if (subPlan.canTranslate((Expression)existsPredicate)) {
            return subPlan;
        }
        PlanNode subqueryPlan = this.createRelationPlan(existsPredicate.getSubquery()).getRoot();
        Symbol exists = this.symbolAllocator.newSymbol("exists", (Type)BooleanType.BOOLEAN);
        if (this.isAggregationWithEmptyGroupBy(subqueryPlan)) {
            subPlan.getTranslations().put((Expression)existsPredicate, (Expression)BooleanLiteral.TRUE_LITERAL);
            return subPlan;
        }
        subqueryPlan = new LimitNode(this.idAllocator.getNextId(), subqueryPlan, 1L, false);
        FunctionRegistry functionRegistry = this.metadata.getFunctionRegistry();
        QualifiedName countFunction = QualifiedName.of((String)"count");
        Symbol count = this.symbolAllocator.newSymbol(countFunction.toString(), (Type)BigintType.BIGINT);
        subqueryPlan = new AggregationNode(this.idAllocator.getNextId(), subqueryPlan, (Map<Symbol, FunctionCall>)ImmutableMap.of((Object)count, (Object)new FunctionCall(countFunction, (List)ImmutableList.of())), (Map<Symbol, Signature>)ImmutableMap.of((Object)count, (Object)functionRegistry.resolveFunction(countFunction, (List<TypeSignature>)ImmutableList.of())), (Map<Symbol, Symbol>)ImmutableMap.of(), (List<List<Symbol>>)ImmutableList.of((Object)ImmutableList.of()), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty());
        ComparisonExpression countGreaterThanZero = new ComparisonExpression(ComparisonExpressionType.GREATER_THAN, (Expression)count.toSymbolReference(), (Expression)new Cast((Expression)new LongLiteral("0"), BigintType.BIGINT.toString()));
        subqueryPlan = new EnforceSingleRowNode(this.idAllocator.getNextId(), new ProjectNode(this.idAllocator.getNextId(), subqueryPlan, (Map<Symbol, Expression>)ImmutableMap.of((Object)exists, (Object)countGreaterThanZero)));
        return this.appendSubqueryApplyNode(subPlan, (Expression)existsPredicate, (Node)existsPredicate.getSubquery(), subqueryPlan, correlationAllowed);
    }

    private PlanBuilder appendQuantifiedComparisonApplyNodes(PlanBuilder subPlan, Set<QuantifiedComparisonExpression> quantifiedComparisons, boolean correlationAllowed) {
        for (QuantifiedComparisonExpression quantifiedComparison : quantifiedComparisons) {
            subPlan = this.appendQuantifiedComparisonApplyNode(subPlan, quantifiedComparison, correlationAllowed);
        }
        return subPlan;
    }

    private PlanBuilder appendQuantifiedComparisonApplyNode(PlanBuilder subPlan, QuantifiedComparisonExpression quantifiedComparison, boolean correlationAllowed) {
        if (subPlan.canTranslate((Expression)quantifiedComparison)) {
            return subPlan;
        }
        switch (quantifiedComparison.getComparisonType()) {
            case EQUAL: {
                switch (quantifiedComparison.getQuantifier()) {
                    case ALL: {
                        return this.planQuantifiedEqualsAll(subPlan, quantifiedComparison, correlationAllowed);
                    }
                    case ANY: 
                    case SOME: {
                        InPredicate inPredicate = new InPredicate(quantifiedComparison.getValue(), quantifiedComparison.getSubquery());
                        subPlan.getTranslations().addIntermediateMapping((Expression)quantifiedComparison, (Expression)inPredicate);
                        return this.appendInPredicateApplyNode(subPlan, inPredicate, correlationAllowed);
                    }
                }
                break;
            }
            case NOT_EQUAL: {
                switch (quantifiedComparison.getQuantifier()) {
                    case ALL: {
                        QuantifiedComparisonExpression rewrittenAny = new QuantifiedComparisonExpression(ComparisonExpressionType.EQUAL, QuantifiedComparisonExpression.Quantifier.ANY, quantifiedComparison.getValue(), quantifiedComparison.getSubquery());
                        NotExpression notAny = new NotExpression((Expression)rewrittenAny);
                        subPlan.getTranslations().addIntermediateMapping((Expression)quantifiedComparison, (Expression)notAny);
                        return this.appendQuantifiedComparisonApplyNode(subPlan, rewrittenAny, correlationAllowed);
                    }
                    case ANY: 
                    case SOME: {
                        QuantifiedComparisonExpression rewrittenAll = new QuantifiedComparisonExpression(ComparisonExpressionType.EQUAL, QuantifiedComparisonExpression.Quantifier.ALL, quantifiedComparison.getValue(), quantifiedComparison.getSubquery());
                        NotExpression notAll = new NotExpression((Expression)rewrittenAll);
                        subPlan.getTranslations().addIntermediateMapping((Expression)quantifiedComparison, (Expression)notAll);
                        return this.appendQuantifiedComparisonApplyNode(subPlan, rewrittenAll, correlationAllowed);
                    }
                }
                break;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                return this.planQuantifiedOrderable(subPlan, quantifiedComparison, correlationAllowed);
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected quantified comparison: '%s %s'", quantifiedComparison.getComparisonType().getValue(), quantifiedComparison.getQuantifier()));
    }

    private PlanBuilder planQuantifiedEqualsAll(PlanBuilder subPlan, QuantifiedComparisonExpression quantifiedComparison, boolean correlationAllowed) {
        Preconditions.checkArgument((quantifiedComparison.getComparisonType() == ComparisonExpressionType.EQUAL && quantifiedComparison.getQuantifier() == QuantifiedComparisonExpression.Quantifier.ALL ? 1 : 0) != 0);
        RelationPlan subqueryRelationPlan = this.createRelationPlan(quantifiedComparison.getSubquery());
        PlanNode subqueryPlan = subqueryRelationPlan.getRoot();
        ImmutableList outputColumnReference = ImmutableList.of((Object)((Symbol)Iterables.getOnlyElement(subqueryRelationPlan.getOutputSymbols())).toSymbolReference());
        Type outputColumnType = ((Field)Iterables.getOnlyElement(subqueryRelationPlan.getDescriptor().getAllFields())).getType();
        if (!outputColumnType.isOrderable()) {
            SemanticExceptions.throwNotSupportedException((Node)quantifiedComparison, "Quantified comparison '= ALL' or '<> ANY' for unorderable type " + outputColumnType.getDisplayName());
        }
        ImmutableList outputColumnTypeSignature = ImmutableList.of((Object)outputColumnType.getTypeSignature());
        FunctionRegistry functionRegistry = this.metadata.getFunctionRegistry();
        QualifiedName min = QualifiedName.of((String)"min");
        QualifiedName max = QualifiedName.of((String)"max");
        Symbol minValue = this.symbolAllocator.newSymbol(min.toString(), outputColumnType);
        Symbol maxValue = this.symbolAllocator.newSymbol(max.toString(), outputColumnType);
        subqueryPlan = new AggregationNode(this.idAllocator.getNextId(), subqueryPlan, (Map<Symbol, FunctionCall>)ImmutableMap.of((Object)minValue, (Object)new FunctionCall(min, (List)outputColumnReference), (Object)maxValue, (Object)new FunctionCall(max, (List)outputColumnReference)), (Map<Symbol, Signature>)ImmutableMap.of((Object)minValue, (Object)functionRegistry.resolveFunction(min, (List<TypeSignature>)outputColumnTypeSignature), (Object)maxValue, (Object)functionRegistry.resolveFunction(max, (List<TypeSignature>)outputColumnTypeSignature)), (Map<Symbol, Symbol>)ImmutableMap.of(), (List<List<Symbol>>)ImmutableList.of((Object)ImmutableList.of()), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty());
        subqueryPlan = new EnforceSingleRowNode(this.idAllocator.getNextId(), subqueryPlan);
        LogicalBinaryExpression valueComparedToSubquery = new LogicalBinaryExpression(LogicalBinaryExpression.Type.AND, (Expression)new ComparisonExpression(ComparisonExpressionType.EQUAL, (Expression)minValue.toSymbolReference(), (Expression)maxValue.toSymbolReference()), (Expression)new ComparisonExpression(ComparisonExpressionType.EQUAL, quantifiedComparison.getValue(), (Expression)minValue.toSymbolReference()));
        subPlan.getTranslations().addIntermediateMapping((Expression)quantifiedComparison, (Expression)valueComparedToSubquery);
        return this.appendSubqueryApplyNode(subPlan, quantifiedComparison.getSubquery(), (Node)quantifiedComparison.getSubquery(), subqueryPlan, correlationAllowed);
    }

    private PlanBuilder planQuantifiedOrderable(PlanBuilder subPlan, QuantifiedComparisonExpression quantifiedComparison, boolean correlationAllowed) {
        Preconditions.checkArgument((boolean)EnumSet.of(ComparisonExpressionType.LESS_THAN, ComparisonExpressionType.LESS_THAN_OR_EQUAL, ComparisonExpressionType.GREATER_THAN, ComparisonExpressionType.GREATER_THAN_OR_EQUAL).contains(quantifiedComparison.getComparisonType()));
        QualifiedName aggregationFunction = SubqueryPlanner.chooseAggregationFunction(quantifiedComparison);
        RelationPlan subqueryRelationPlan = this.createRelationPlan(quantifiedComparison.getSubquery());
        PlanNode subqueryPlan = subqueryRelationPlan.getRoot();
        Symbol outputColumn = (Symbol)Iterables.getOnlyElement(subqueryRelationPlan.getOutputSymbols());
        Type outputColumnType = ((Field)Iterables.getOnlyElement(subqueryRelationPlan.getDescriptor().getAllFields())).getType();
        Preconditions.checkState((boolean)outputColumnType.isOrderable(), (Object)"Subquery result type must be orderable");
        FunctionRegistry functionRegistry = this.metadata.getFunctionRegistry();
        Symbol subValue = this.symbolAllocator.newSymbol(aggregationFunction.toString(), outputColumnType);
        subqueryPlan = new AggregationNode(this.idAllocator.getNextId(), subqueryPlan, (Map<Symbol, FunctionCall>)ImmutableMap.of((Object)subValue, (Object)new FunctionCall(aggregationFunction, (List)ImmutableList.of((Object)outputColumn.toSymbolReference()))), (Map<Symbol, Signature>)ImmutableMap.of((Object)subValue, (Object)functionRegistry.resolveFunction(aggregationFunction, (List<TypeSignature>)ImmutableList.of((Object)outputColumnType.getTypeSignature()))), (Map<Symbol, Symbol>)ImmutableMap.of(), (List<List<Symbol>>)ImmutableList.of((Object)ImmutableList.of()), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty());
        subqueryPlan = new EnforceSingleRowNode(this.idAllocator.getNextId(), subqueryPlan);
        ComparisonExpression valueComparedToSubquery = new ComparisonExpression(quantifiedComparison.getComparisonType(), quantifiedComparison.getValue(), (Expression)subValue.toSymbolReference());
        subPlan.getTranslations().addIntermediateMapping((Expression)quantifiedComparison, (Expression)valueComparedToSubquery);
        return this.appendSubqueryApplyNode(subPlan, quantifiedComparison.getSubquery(), (Node)quantifiedComparison.getSubquery(), subqueryPlan, correlationAllowed);
    }

    private static QualifiedName chooseAggregationFunction(QuantifiedComparisonExpression quantifiedComparison) {
        switch (quantifiedComparison.getQuantifier()) {
            case ALL: {
                switch (quantifiedComparison.getComparisonType()) {
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: {
                        return QualifiedName.of((String)"min");
                    }
                    case GREATER_THAN: 
                    case GREATER_THAN_OR_EQUAL: {
                        return QualifiedName.of((String)"max");
                    }
                }
                break;
            }
            case ANY: 
            case SOME: {
                switch (quantifiedComparison.getComparisonType()) {
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: {
                        return QualifiedName.of((String)"max");
                    }
                    case GREATER_THAN: 
                    case GREATER_THAN_OR_EQUAL: {
                        return QualifiedName.of((String)"min");
                    }
                }
            }
        }
        throw new IllegalArgumentException("Unexpected quantifier: " + quantifiedComparison.getQuantifier());
    }

    private boolean isAggregationWithEmptyGroupBy(PlanNode subqueryPlan) {
        return PlanNodeSearcher.searchFrom(subqueryPlan).skipOnlyWhen(Predicates.isInstanceOfAny(ProjectNode.class)).where(AggregationNode.class::isInstance).findFirst().map(AggregationNode.class::cast).map(aggregation -> aggregation.getGroupingKeys().isEmpty()).orElse(false);
    }

    private PlanBuilder appendSubqueryApplyNode(PlanBuilder subPlan, Expression subqueryExpression, Node subquery, PlanNode subqueryNode, boolean correlationAllowed) {
        PlanNode root;
        Map<Expression, Symbol> correlation = this.extractCorrelation(subPlan, subqueryNode);
        if (!correlationAllowed && !correlation.isEmpty()) {
            SemanticExceptions.throwNotSupportedException(subquery, "Correlated subquery in given context");
        }
        subPlan = subPlan.appendProjections(correlation.keySet(), this.symbolAllocator, this.idAllocator);
        subqueryNode = this.replaceExpressionsWithSymbols(subqueryNode, correlation);
        TranslationMap translations = subPlan.copyTranslations();
        if (subqueryNode.getOutputSymbols().size() == 1) {
            translations.put(subqueryExpression, subqueryNode.getOutputSymbols().get(0));
        }
        if ((root = subPlan.getRoot()).getOutputSymbols().isEmpty()) {
            return new PlanBuilder(translations, subqueryNode, this.analysis.getParameters());
        }
        return new PlanBuilder(translations, new ApplyNode(this.idAllocator.getNextId(), root, subqueryNode, (List<Symbol>)ImmutableList.copyOf(correlation.values())), this.analysis.getParameters());
    }

    private Map<Expression, Symbol> extractCorrelation(PlanBuilder subPlan, PlanNode subquery) {
        Set<Expression> missingReferences = this.extractOuterColumnReferences(subquery);
        ImmutableMap.Builder correlation = ImmutableMap.builder();
        for (Expression missingReference : missingReferences) {
            this.tryResolveMissingExpression(subPlan, missingReference).ifPresent(symbolReference -> correlation.put((Object)missingReference, (Object)Symbol.from(symbolReference)));
        }
        return correlation.build();
    }

    private Optional<Expression> tryResolveMissingExpression(PlanBuilder subPlan, Expression expression) {
        Expression rewritten = subPlan.rewrite(expression);
        if (rewritten instanceof SymbolReference) {
            return Optional.of(rewritten);
        }
        return Optional.empty();
    }

    private RelationPlan createRelationPlan(Query subquery) {
        return (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session).process((Node)subquery, null);
    }

    private RelationPlan createRelationPlan(Expression subquery) {
        return (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session).process((Node)subquery, null);
    }

    private Set<Expression> extractOuterColumnReferences(PlanNode planNode) {
        return (Set)ExpressionExtractor.extractExpressions(planNode).stream().flatMap(expression -> SubqueryPlanner.extractColumnReferences(expression, this.analysis.getColumnReferences()).stream()).collect(ImmutableCollectors.toImmutableSet());
    }

    private static Set<Expression> extractColumnReferences(Expression expression, Set<Expression> columnReferences) {
        ImmutableSet.Builder expressionColumnReferences = ImmutableSet.builder();
        new ColumnReferencesExtractor(columnReferences).process((Node)expression, expressionColumnReferences);
        return expressionColumnReferences.build();
    }

    private PlanNode replaceExpressionsWithSymbols(PlanNode planNode, Map<Expression, Symbol> mapping) {
        if (mapping.isEmpty()) {
            return planNode;
        }
        Map expressionMapping = (Map)mapping.entrySet().stream().collect(ImmutableCollectors.toImmutableMap(Map.Entry::getKey, e -> ((Symbol)e.getValue()).toSymbolReference()));
        return SimplePlanRewriter.rewriteWith(new ExpressionReplacer(this.idAllocator, expressionMapping), planNode, null);
    }

    private static class ExpressionReplacer
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final Map<Expression, Expression> mapping;

        public ExpressionReplacer(PlanNodeIdAllocator idAllocator, Map<Expression, Expression> mapping) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.mapping = Objects.requireNonNull(mapping, "mapping is null");
        }

        @Override
        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            ProjectNode rewrittenNode = (ProjectNode)context.defaultRewrite(node);
            ImmutableMap.Builder assignments = ImmutableMap.builder();
            for (Map.Entry<Symbol, Expression> assignment : rewrittenNode.getAssignments().entrySet()) {
                Expression expression = assignment.getValue();
                Expression rewritten = ExpressionNodeInliner.replaceExpression(expression, this.mapping);
                assignments.put((Object)assignment.getKey(), (Object)rewritten);
            }
            return new ProjectNode(this.idAllocator.getNextId(), rewrittenNode.getSource(), (Map<Symbol, Expression>)assignments.build());
        }

        @Override
        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            FilterNode rewrittenNode = (FilterNode)context.defaultRewrite(node);
            return new FilterNode(this.idAllocator.getNextId(), rewrittenNode.getSource(), ExpressionNodeInliner.replaceExpression(rewrittenNode.getPredicate(), this.mapping));
        }

        @Override
        public PlanNode visitValues(ValuesNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            ValuesNode rewrittenNode = (ValuesNode)context.defaultRewrite(node);
            List rewrittenRows = (List)rewrittenNode.getRows().stream().map(row -> row.stream().map(column -> ExpressionNodeInliner.replaceExpression(column, this.mapping)).collect(ImmutableCollectors.toImmutableList())).collect(ImmutableCollectors.toImmutableList());
            return new ValuesNode(this.idAllocator.getNextId(), rewrittenNode.getOutputSymbols(), rewrittenRows);
        }
    }

    private static class ColumnReferencesExtractor
    extends DefaultExpressionTraversalVisitor<Void, ImmutableSet.Builder<Expression>> {
        private final Set<Expression> columnReferences;

        private ColumnReferencesExtractor(Set<Expression> columnReferences) {
            this.columnReferences = Objects.requireNonNull(columnReferences, "columnReferences is null");
        }

        protected Void visitDereferenceExpression(DereferenceExpression node, ImmutableSet.Builder<Expression> builder) {
            if (this.columnReferences.contains(node)) {
                builder.add((Object)node);
            } else {
                this.process((Node)node.getBase(), builder);
            }
            return null;
        }

        protected Void visitQualifiedNameReference(QualifiedNameReference node, ImmutableSet.Builder<Expression> builder) {
            builder.add((Object)node);
            return null;
        }
    }
}

