/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.concurrent.Immutable;

@Immutable
public class RelationType {
    private final List<Field> visibleFields;
    private final List<Field> allFields;
    private final Map<Field, Integer> fieldIndexes;

    public RelationType(Field ... fields) {
        this((List<Field>)ImmutableList.copyOf((Object[])fields));
    }

    public RelationType(List<Field> fields) {
        Objects.requireNonNull(fields, "fields is null");
        this.allFields = ImmutableList.copyOf(fields);
        this.visibleFields = ImmutableList.copyOf((Iterable)Iterables.filter(fields, (com.google.common.base.Predicate)Predicates.not(Field::isHidden)));
        int index = 0;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Field field : fields) {
            builder.put((Object)field, (Object)index++);
        }
        this.fieldIndexes = builder.build();
    }

    public int indexOf(Field field) {
        return Objects.requireNonNull(this.fieldIndexes.get(field));
    }

    public Field getFieldByIndex(int fieldIndex) {
        Preconditions.checkElementIndex((int)fieldIndex, (int)this.allFields.size(), (String)"fieldIndex");
        return this.allFields.get(fieldIndex);
    }

    public Collection<Field> getVisibleFields() {
        return this.visibleFields;
    }

    public int getVisibleFieldCount() {
        return this.visibleFields.size();
    }

    public Collection<Field> getAllFields() {
        return ImmutableSet.copyOf(this.allFields);
    }

    public int getAllFieldCount() {
        return this.allFields.size();
    }

    public List<Field> resolveFieldsWithPrefix(Optional<QualifiedName> prefix) {
        return (List)this.visibleFields.stream().filter(input -> input.matchesPrefix(prefix)).collect(ImmutableCollectors.toImmutableList());
    }

    public List<Field> resolveFields(QualifiedName name) {
        return (List)this.allFields.stream().filter(input -> input.canResolve(name)).collect(ImmutableCollectors.toImmutableList());
    }

    public Predicate<QualifiedName> canResolvePredicate() {
        return input -> !this.resolveFields((QualifiedName)input).isEmpty();
    }

    public RelationType joinWith(RelationType other) {
        ImmutableList fields = ImmutableList.builder().addAll(this.allFields).addAll(other.allFields).build();
        return new RelationType((List<Field>)fields);
    }

    public RelationType withAlias(String relationAlias, List<String> columnAliases) {
        if (columnAliases != null) {
            Preconditions.checkArgument((columnAliases.size() == this.visibleFields.size() ? 1 : 0) != 0, (String)"Column alias list has %s entries but '%s' has %s columns available", (Object[])new Object[]{columnAliases.size(), relationAlias, this.visibleFields.size()});
        }
        ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
        for (int i = 0; i < this.allFields.size(); ++i) {
            Field field = this.allFields.get(i);
            Optional<String> columnAlias = field.getName();
            if (columnAliases == null) {
                fieldsBuilder.add((Object)Field.newQualified(QualifiedName.of((String)relationAlias), columnAlias, field.getType(), field.isHidden(), field.getOriginTable(), field.isAliased()));
                continue;
            }
            if (field.isHidden()) continue;
            columnAlias = Optional.of(columnAliases.get(i));
            fieldsBuilder.add((Object)Field.newQualified(QualifiedName.of((String)relationAlias), columnAlias, field.getType(), false, field.getOriginTable(), field.isAliased()));
        }
        return new RelationType((List<Field>)fieldsBuilder.build());
    }

    public RelationType withOnlyVisibleFields() {
        return new RelationType(this.visibleFields);
    }

    public String toString() {
        return this.allFields.toString();
    }
}

