/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.RegexLibrary;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.units.DataSize;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.validation.constraints.Min;

@DefunctConfig(value={"resource-group-manager", "experimental-syntax-enabled", "analyzer.experimental-syntax-enabled"})
public class FeaturesConfig {
    private boolean distributedIndexJoinsEnabled;
    private boolean distributedJoinsEnabled = true;
    private boolean colocatedJoinsEnabled;
    private boolean redistributeWrites = true;
    private boolean optimizeMetadataQueries;
    private boolean optimizeHashGeneration = true;
    private boolean optimizeSingleDistinct = true;
    private boolean pushTableWriteThroughUnion = true;
    private boolean legacyArrayAgg;
    private boolean optimizeMixedDistinctAggregations;
    private String processingOptimization = "disabled";
    private boolean dictionaryAggregation;
    private boolean resourceGroups;
    private int re2JDfaStatesLimit = Integer.MAX_VALUE;
    private int re2JDfaRetries = 5;
    private RegexLibrary regexLibrary = RegexLibrary.JONI;
    private boolean spillEnabled;
    private DataSize operatorMemoryLimitBeforeSpill = new DataSize(4.0, DataSize.Unit.MEGABYTE);
    private Path spillerSpillPath = Paths.get(System.getProperty("java.io.tmpdir"), "presto", "spills");
    private int spillerThreads = 4;

    public boolean isResourceGroupsEnabled() {
        return this.resourceGroups;
    }

    @Config(value="experimental.resource-groups-enabled")
    public FeaturesConfig setResourceGroupsEnabled(boolean enabled) {
        this.resourceGroups = enabled;
        return this;
    }

    public boolean isDistributedIndexJoinsEnabled() {
        return this.distributedIndexJoinsEnabled;
    }

    @Config(value="distributed-index-joins-enabled")
    public FeaturesConfig setDistributedIndexJoinsEnabled(boolean distributedIndexJoinsEnabled) {
        this.distributedIndexJoinsEnabled = distributedIndexJoinsEnabled;
        return this;
    }

    public boolean isDistributedJoinsEnabled() {
        return this.distributedJoinsEnabled;
    }

    @Config(value="deprecated.legacy-array-agg")
    public FeaturesConfig setLegacyArrayAgg(boolean legacyArrayAgg) {
        this.legacyArrayAgg = legacyArrayAgg;
        return this;
    }

    public boolean isLegacyArrayAgg() {
        return this.legacyArrayAgg;
    }

    @Config(value="distributed-joins-enabled")
    public FeaturesConfig setDistributedJoinsEnabled(boolean distributedJoinsEnabled) {
        this.distributedJoinsEnabled = distributedJoinsEnabled;
        return this;
    }

    public boolean isColocatedJoinsEnabled() {
        return this.colocatedJoinsEnabled;
    }

    @Config(value="colocated-joins-enabled")
    @ConfigDescription(value="Experimental: Use a colocated join when possible")
    public FeaturesConfig setColocatedJoinsEnabled(boolean colocatedJoinsEnabled) {
        this.colocatedJoinsEnabled = colocatedJoinsEnabled;
        return this;
    }

    public boolean isRedistributeWrites() {
        return this.redistributeWrites;
    }

    @Config(value="redistribute-writes")
    public FeaturesConfig setRedistributeWrites(boolean redistributeWrites) {
        this.redistributeWrites = redistributeWrites;
        return this;
    }

    public boolean isOptimizeMetadataQueries() {
        return this.optimizeMetadataQueries;
    }

    @Config(value="optimizer.optimize-metadata-queries")
    public FeaturesConfig setOptimizeMetadataQueries(boolean optimizeMetadataQueries) {
        this.optimizeMetadataQueries = optimizeMetadataQueries;
        return this;
    }

    public boolean isOptimizeHashGeneration() {
        return this.optimizeHashGeneration;
    }

    @Config(value="optimizer.optimize-hash-generation")
    public FeaturesConfig setOptimizeHashGeneration(boolean optimizeHashGeneration) {
        this.optimizeHashGeneration = optimizeHashGeneration;
        return this;
    }

    public boolean isOptimizeSingleDistinct() {
        return this.optimizeSingleDistinct;
    }

    @Config(value="optimizer.optimize-single-distinct")
    public FeaturesConfig setOptimizeSingleDistinct(boolean optimizeSingleDistinct) {
        this.optimizeSingleDistinct = optimizeSingleDistinct;
        return this;
    }

    public boolean isPushTableWriteThroughUnion() {
        return this.pushTableWriteThroughUnion;
    }

    @Config(value="optimizer.push-table-write-through-union")
    public FeaturesConfig setPushTableWriteThroughUnion(boolean pushTableWriteThroughUnion) {
        this.pushTableWriteThroughUnion = pushTableWriteThroughUnion;
        return this;
    }

    public String getProcessingOptimization() {
        return this.processingOptimization;
    }

    @Config(value="optimizer.processing-optimization")
    public FeaturesConfig setProcessingOptimization(String processingOptimization) {
        if (!ProcessingOptimization.AVAILABLE_OPTIONS.contains(processingOptimization)) {
            throw new IllegalStateException(String.format("Value %s is not valid for processingOptimization.", processingOptimization));
        }
        this.processingOptimization = processingOptimization;
        return this;
    }

    public boolean isDictionaryAggregation() {
        return this.dictionaryAggregation;
    }

    @Config(value="optimizer.dictionary-aggregation")
    public FeaturesConfig setDictionaryAggregation(boolean dictionaryAggregation) {
        this.dictionaryAggregation = dictionaryAggregation;
        return this;
    }

    @Min(value=2L)
    public int getRe2JDfaStatesLimit() {
        return this.re2JDfaStatesLimit;
    }

    @Config(value="re2j.dfa-states-limit")
    public FeaturesConfig setRe2JDfaStatesLimit(int re2JDfaStatesLimit) {
        this.re2JDfaStatesLimit = re2JDfaStatesLimit;
        return this;
    }

    @Min(value=0L)
    public int getRe2JDfaRetries() {
        return this.re2JDfaRetries;
    }

    @Config(value="re2j.dfa-retries")
    public FeaturesConfig setRe2JDfaRetries(int re2JDfaRetries) {
        this.re2JDfaRetries = re2JDfaRetries;
        return this;
    }

    public RegexLibrary getRegexLibrary() {
        return this.regexLibrary;
    }

    @Config(value="regex-library")
    public FeaturesConfig setRegexLibrary(RegexLibrary regexLibrary) {
        this.regexLibrary = regexLibrary;
        return this;
    }

    public boolean isSpillEnabled() {
        return this.spillEnabled;
    }

    @Config(value="experimental.spill-enabled")
    public FeaturesConfig setSpillEnabled(boolean spillEnabled) {
        this.spillEnabled = spillEnabled;
        return this;
    }

    public DataSize getOperatorMemoryLimitBeforeSpill() {
        return this.operatorMemoryLimitBeforeSpill;
    }

    @Config(value="experimental.operator-memory-limit-before-spill")
    public FeaturesConfig setOperatorMemoryLimitBeforeSpill(DataSize operatorMemoryLimitBeforeSpill) {
        this.operatorMemoryLimitBeforeSpill = operatorMemoryLimitBeforeSpill;
        return this;
    }

    public Path getSpillerSpillPath() {
        return this.spillerSpillPath;
    }

    @Config(value="experimental.spiller-spill-path")
    public FeaturesConfig setSpillerSpillPath(String spillPath) {
        this.spillerSpillPath = Paths.get(spillPath, new String[0]);
        return this;
    }

    public int getSpillerThreads() {
        return this.spillerThreads;
    }

    @Config(value="experimental.spiller-threads")
    public FeaturesConfig setSpillerThreads(int spillerThreads) {
        this.spillerThreads = spillerThreads;
        return this;
    }

    public boolean isOptimizeMixedDistinctAggregations() {
        return this.optimizeMixedDistinctAggregations;
    }

    @Config(value="optimizer.optimize-mixed-distinct-aggregations")
    public FeaturesConfig setOptimizeMixedDistinctAggregations(boolean value) {
        this.optimizeMixedDistinctAggregations = value;
        return this;
    }

    public static class ProcessingOptimization {
        public static final String DISABLED = "disabled";
        public static final String COLUMNAR = "columnar";
        public static final String COLUMNAR_DICTIONARY = "columnar_dictionary";
        public static final List<String> AVAILABLE_OPTIONS = ImmutableList.of((Object)"disabled", (Object)"columnar", (Object)"columnar_dictionary");
    }
}

