/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.Session;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.split.PageSourceProvider;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PageSourceManager
implements PageSourceProvider {
    private final ConcurrentMap<ConnectorId, ConnectorPageSourceProvider> pageSourceProviders = new ConcurrentHashMap<ConnectorId, ConnectorPageSourceProvider>();

    public void addConnectorPageSourceProvider(ConnectorId connectorId, ConnectorPageSourceProvider pageSourceProvider) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        Preconditions.checkState((this.pageSourceProviders.put(connectorId, pageSourceProvider) == null ? 1 : 0) != 0, (String)"PageSourceProvider for connector '%s' is already registered", (Object[])new Object[]{connectorId});
    }

    public void removeConnectorPageSourceProvider(ConnectorId connectorId) {
        this.pageSourceProviders.remove(connectorId);
    }

    @Override
    public ConnectorPageSource createPageSource(Session session, Split split, List<ColumnHandle> columns) {
        Objects.requireNonNull(split, "split is null");
        Objects.requireNonNull(columns, "columns is null");
        ConnectorSession connectorSession = session.toConnectorSession(split.getConnectorId());
        return this.getPageSourceProvider(split).createPageSource(split.getTransactionHandle(), connectorSession, split.getConnectorSplit(), columns);
    }

    private ConnectorPageSourceProvider getPageSourceProvider(Split split) {
        ConnectorPageSourceProvider provider = (ConnectorPageSourceProvider)this.pageSourceProviders.get(split.getConnectorId());
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (String)"No page stream provider for '%s", (Object[])new Object[]{split.getConnectorId()});
        return provider;
    }
}

