/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spiller;

import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spiller.BinaryFileSpiller;
import com.facebook.presto.spiller.Spiller;
import com.facebook.presto.spiller.SpillerFactory;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import io.airlift.concurrent.Threads;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class BinarySpillerFactory
implements SpillerFactory {
    public static final String SPILLER_THREAD_NAME_PREFIX = "binary-spiller";
    private final ListeningExecutorService executor;
    private final BlockEncodingSerde blockEncodingSerde;
    private final Path spillPath;

    @Inject
    public BinarySpillerFactory(BlockEncodingSerde blockEncodingSerde, FeaturesConfig featuresConfig) {
        this(BinarySpillerFactory.createExecutorServiceOfSize(Objects.requireNonNull(featuresConfig, "featuresConfig is null").getSpillerThreads()), blockEncodingSerde, Objects.requireNonNull(featuresConfig, "featuresConfig is null").getSpillerSpillPath());
    }

    public BinarySpillerFactory(ListeningExecutorService executor, BlockEncodingSerde blockEncodingSerde, Path spillPath) {
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.spillPath = Objects.requireNonNull(spillPath, "spillPath is null");
        this.spillPath.toFile().mkdirs();
    }

    private static ListeningExecutorService createExecutorServiceOfSize(int nThreads) {
        ThreadFactory threadFactory = Threads.daemonThreadsNamed((String)"binary-spiller-%s");
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads, threadFactory);
        return MoreExecutors.listeningDecorator((ExecutorService)executorService);
    }

    @Override
    public Spiller create(List<Type> types) {
        return new BinaryFileSpiller(this.blockEncodingSerde, this.executor, this.spillPath);
    }
}

