/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.remotetask;

import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class Backoff {
    private final long maxFailureIntervalNanos;
    private final Ticker ticker;
    private final long[] backoffDelayIntervalsNanos;
    private long lastSuccessTime;
    private long lastFailureTime;
    private long failureCount;

    public Backoff(Duration maxFailureInterval) {
        this(maxFailureInterval, new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(50.0, TimeUnit.MILLISECONDS), new Duration(100.0, TimeUnit.MILLISECONDS), new Duration(200.0, TimeUnit.MILLISECONDS), new Duration(500.0, TimeUnit.MILLISECONDS));
    }

    public Backoff(Duration maxFailureInterval, Duration ... backoffDelayIntervals) {
        this(maxFailureInterval, Ticker.systemTicker(), backoffDelayIntervals);
    }

    public Backoff(Duration maxFailureInterval, Ticker ticker, Duration ... backoffDelayIntervals) {
        Objects.requireNonNull(maxFailureInterval, "maxFailureInterval is null");
        Objects.requireNonNull(ticker, "ticker is null");
        Objects.requireNonNull(backoffDelayIntervals, "backoffDelayIntervals is null");
        Preconditions.checkArgument((backoffDelayIntervals.length > 0 ? 1 : 0) != 0, (Object)"backoffDelayIntervals must contain at least one entry");
        this.maxFailureIntervalNanos = maxFailureInterval.roundTo(TimeUnit.NANOSECONDS);
        this.ticker = ticker;
        this.backoffDelayIntervalsNanos = new long[backoffDelayIntervals.length];
        for (int i = 0; i < backoffDelayIntervals.length; ++i) {
            this.backoffDelayIntervalsNanos[i] = backoffDelayIntervals[i].roundTo(TimeUnit.NANOSECONDS);
        }
        this.lastSuccessTime = this.ticker.read();
    }

    public synchronized long getFailureCount() {
        return this.failureCount;
    }

    public synchronized Duration getTimeSinceLastSuccess() {
        long lastSuccessfulRequest = this.lastSuccessTime;
        long value = this.ticker.read() - lastSuccessfulRequest;
        return new Duration((double)value, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit();
    }

    public synchronized void success() {
        this.lastSuccessTime = this.ticker.read();
        this.failureCount = 0L;
        this.lastFailureTime = 0L;
    }

    public synchronized boolean failure() {
        long now;
        long lastSuccessfulRequest = this.lastSuccessTime;
        this.lastFailureTime = now = this.ticker.read();
        ++this.failureCount;
        long timeSinceLastSuccess = now - lastSuccessfulRequest;
        return timeSinceLastSuccess >= this.maxFailureIntervalNanos;
    }

    public synchronized long getBackoffDelayNanos() {
        int failureCount = (int)Math.min((long)this.backoffDelayIntervalsNanos.length, this.failureCount);
        if (failureCount == 0) {
            return 0L;
        }
        long currentDelay = this.backoffDelayIntervalsNanos[failureCount - 1];
        long nanosSinceLastFailure = this.ticker.read() - this.lastFailureTime;
        return Math.max(0L, currentDelay - nanosSinceLastFailure);
    }
}

