/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.client.ServerInfo;
import com.facebook.presto.server.GracefulShutdownHandler;
import com.facebook.presto.spi.NodeState;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="/v1/info")
public class ServerInfoResource {
    private final ServerInfo serverInfo;
    private final GracefulShutdownHandler shutdownHandler;

    @Inject
    public ServerInfoResource(ServerInfo serverInfo, GracefulShutdownHandler shutdownHandler) {
        this.serverInfo = Objects.requireNonNull(serverInfo, "serverInfo is null");
        this.shutdownHandler = Objects.requireNonNull(shutdownHandler, "shutdownHandler is null");
    }

    @GET
    @Produces(value={"application/json"})
    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    @PUT
    @Path(value="state")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response updateState(NodeState state) throws WebApplicationException {
        switch (state) {
            case SHUTTING_DOWN: {
                this.shutdownHandler.requestShutdown();
                return Response.ok().build();
            }
            case ACTIVE: 
            case INACTIVE: {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)String.format("Invalid state transition to %s", state)).build());
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)String.format("Invalid state %s", state)).build();
    }

    @GET
    @Path(value="state")
    @Produces(value={"application/json"})
    public NodeState getServerState() {
        if (this.shutdownHandler.isShutdownRequested()) {
            return NodeState.SHUTTING_DOWN;
        }
        return NodeState.ACTIVE;
    }

    @GET
    @Path(value="coordinator")
    @Produces(value={"text/plain"})
    public Response getServerCoordinator() {
        if (this.serverInfo.isCoordinator()) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

