/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.Session;
import com.facebook.presto.client.ClientSession;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimeZoneNotSupportedException;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import io.airlift.units.Duration;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

final class ResourceUtil {
    private ResourceUtil() {
    }

    public static Session createSessionForRequest(HttpServletRequest servletRequest, TransactionManager transactionManager, AccessControl accessControl, SessionPropertyManager sessionPropertyManager, QueryId queryId) {
        String language;
        String catalog = ResourceUtil.trimEmptyToNull(servletRequest.getHeader("X-Presto-Catalog"));
        String schema = ResourceUtil.trimEmptyToNull(servletRequest.getHeader("X-Presto-Schema"));
        ResourceUtil.assertRequest(catalog != null || schema == null, "Schema is set but catalog is not", new Object[0]);
        String user = ResourceUtil.trimEmptyToNull(servletRequest.getHeader("X-Presto-User"));
        ResourceUtil.assertRequest(user != null, "User must be set", new Object[0]);
        Principal principal = servletRequest.getUserPrincipal();
        try {
            accessControl.checkCanSetUser(principal, user);
        }
        catch (AccessDeniedException e) {
            throw new WebApplicationException(e.getMessage(), Response.Status.FORBIDDEN);
        }
        Identity identity = new Identity(user, Optional.ofNullable(principal));
        Session.SessionBuilder sessionBuilder = Session.builder(sessionPropertyManager).setQueryId(queryId).setIdentity(identity).setSource(servletRequest.getHeader("X-Presto-Source")).setCatalog(catalog).setSchema(schema).setRemoteUserAddress(servletRequest.getRemoteAddr()).setUserAgent(servletRequest.getHeader("User-Agent"));
        String timeZoneId = servletRequest.getHeader("X-Presto-Time-Zone");
        if (timeZoneId != null) {
            sessionBuilder.setTimeZoneKey(ResourceUtil.getTimeZoneKey(timeZoneId));
        }
        if ((language = servletRequest.getHeader("X-Presto-Language")) != null) {
            sessionBuilder.setLocale(Locale.forLanguageTag(language));
        }
        for (Map.Entry<String, String> entry : ResourceUtil.parseSessionHeaders(servletRequest).entrySet()) {
            String fullPropertyName = entry.getKey();
            String propertyValue = entry.getValue();
            List nameParts = Splitter.on((char)'.').splitToList((CharSequence)fullPropertyName);
            if (nameParts.size() == 1) {
                String propertyName = (String)nameParts.get(0);
                ResourceUtil.assertRequest(!propertyName.isEmpty(), "Invalid %s header", "X-Presto-Session");
                sessionBuilder.setSystemProperty(propertyName, propertyValue);
                continue;
            }
            if (nameParts.size() == 2) {
                String catalogName = (String)nameParts.get(0);
                String propertyName = (String)nameParts.get(1);
                ResourceUtil.assertRequest(!catalogName.isEmpty(), "Invalid %s header", "X-Presto-Session");
                ResourceUtil.assertRequest(!propertyName.isEmpty(), "Invalid %s header", "X-Presto-Session");
                sessionBuilder.setCatalogSessionProperty(catalogName, propertyName, propertyValue);
                continue;
            }
            throw ResourceUtil.badRequest(String.format("Invalid %s header", "X-Presto-Session"));
        }
        for (Map.Entry<String, String> preparedStatement : ResourceUtil.parsePreparedStatementsHeaders(servletRequest).entrySet()) {
            sessionBuilder.addPreparedStatement(preparedStatement.getKey(), preparedStatement.getValue());
        }
        String transactionIdHeader = servletRequest.getHeader("X-Presto-Transaction-Id");
        if (transactionIdHeader != null) {
            sessionBuilder.setClientTransactionSupport();
        }
        Session session = sessionBuilder.build();
        Optional<TransactionId> transactionId = ResourceUtil.parseTransactionId(transactionIdHeader);
        if (transactionId.isPresent()) {
            session = session.beginTransactionId(transactionId.get(), transactionManager, accessControl);
        }
        return session;
    }

    public static ClientSession createClientSessionForRequest(HttpServletRequest request, URI server, Duration clientRequestTimeout) {
        Objects.requireNonNull(request, "request is null");
        Objects.requireNonNull(server, "server is null");
        Objects.requireNonNull(clientRequestTimeout, "clientRequestTimeout is null");
        String catalog = ResourceUtil.trimEmptyToNull(request.getHeader("X-Presto-Catalog"));
        String schema = ResourceUtil.trimEmptyToNull(request.getHeader("X-Presto-Schema"));
        ResourceUtil.assertRequest(catalog != null || schema == null, "Schema is set but catalog is not", new Object[0]);
        String user = ResourceUtil.trimEmptyToNull(request.getHeader("X-Presto-User"));
        ResourceUtil.assertRequest(user != null, "User must be set", new Object[0]);
        Principal principal = request.getUserPrincipal();
        String source = request.getHeader("X-Presto-Source");
        Identity identity = new Identity(user, Optional.ofNullable(principal));
        String transactionId = ResourceUtil.trimEmptyToNull(request.getHeader("X-Presto-Transaction-Id"));
        String timeZoneId = request.getHeader("X-Presto-Time-Zone");
        String language = request.getHeader("X-Presto-Language");
        Locale locale = null;
        if (language != null) {
            locale = Locale.forLanguageTag(language);
        }
        Map<String, String> sessionProperties = ResourceUtil.parseSessionHeaders(request);
        Map<String, String> preparedStatements = ResourceUtil.parsePreparedStatementsHeaders(request);
        return new ClientSession(server, identity.getUser(), source, catalog, schema, timeZoneId, locale, sessionProperties, preparedStatements, transactionId, false, clientRequestTimeout);
    }

    private static List<String> splitSessionHeader(Enumeration<String> headers) {
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        return (List)Collections.list(headers).stream().map(arg_0 -> ((Splitter)splitter).splitToList(arg_0)).flatMap(Collection::stream).collect(ImmutableCollectors.toImmutableList());
    }

    private static Map<String, String> parseSessionHeaders(HttpServletRequest servletRequest) {
        HashMap<String, String> sessionProperties = new HashMap<String, String>();
        for (String header : ResourceUtil.splitSessionHeader(servletRequest.getHeaders("X-Presto-Session"))) {
            List nameValue = Splitter.on((char)'=').limit(2).trimResults().splitToList((CharSequence)header);
            ResourceUtil.assertRequest(nameValue.size() == 2, "Invalid %s header", "X-Presto-Session");
            sessionProperties.put((String)nameValue.get(0), (String)nameValue.get(1));
        }
        return sessionProperties;
    }

    public static void assertRequest(boolean expression, String format, Object ... args) {
        if (!expression) {
            throw ResourceUtil.badRequest(String.format(format, args));
        }
    }

    private static Map<String, String> parsePreparedStatementsHeaders(HttpServletRequest servletRequest) {
        HashMap<String, String> preparedStatements = new HashMap<String, String>();
        for (String header : ResourceUtil.splitSessionHeader(servletRequest.getHeaders("X-Presto-Prepared-Statement"))) {
            String sqlString;
            String statementName;
            List nameValue = Splitter.on((char)'=').limit(2).trimResults().splitToList((CharSequence)header);
            ResourceUtil.assertRequest(nameValue.size() == 2, "Invalid %s header", "X-Presto-Prepared-Statement");
            try {
                statementName = ResourceUtil.urlDecode((String)nameValue.get(0));
                sqlString = ResourceUtil.urlDecode((String)nameValue.get(1));
            }
            catch (IllegalArgumentException e) {
                throw ResourceUtil.badRequest(String.format("Invalid %s header: %s", "X-Presto-Prepared-Statement", e.getMessage()));
            }
            SqlParser sqlParser = new SqlParser();
            try {
                sqlParser.createStatement(sqlString);
            }
            catch (ParsingException e) {
                throw ResourceUtil.badRequest(String.format("Invalid %s header: %s", "X-Presto-Prepared-Statement", e.getMessage()));
            }
            preparedStatements.put(statementName, sqlString);
        }
        return preparedStatements;
    }

    private static TimeZoneKey getTimeZoneKey(String timeZoneId) {
        try {
            return TimeZoneKey.getTimeZoneKey((String)timeZoneId);
        }
        catch (TimeZoneNotSupportedException e) {
            throw ResourceUtil.badRequest(e.getMessage());
        }
    }

    private static Optional<TransactionId> parseTransactionId(String transactionId) {
        if ((transactionId = ResourceUtil.trimEmptyToNull(transactionId)) == null || transactionId.equalsIgnoreCase("none")) {
            return Optional.empty();
        }
        try {
            return Optional.of(TransactionId.valueOf(transactionId));
        }
        catch (Exception e) {
            throw ResourceUtil.badRequest(e.getMessage());
        }
    }

    private static WebApplicationException badRequest(String message) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)message).build());
    }

    private static String trimEmptyToNull(String value) {
        return Strings.emptyToNull((String)Strings.nullToEmpty((String)value).trim());
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

