/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.type.Re2JRegexp;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public final class Re2JRegexpFunctions {
    private Re2JRegexpFunctions() {
    }

    @Description(value="returns substrings matching a regular expression")
    @ScalarFunction
    @SqlType(value="boolean")
    public static boolean regexpLike(@SqlType(value="varchar") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return pattern.matches(source);
    }

    @Description(value="removes substrings matching a regular expression")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice regexpReplace(@SqlType(value="varchar") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return Re2JRegexpFunctions.regexpReplace(source, pattern, Slices.EMPTY_SLICE);
    }

    @Description(value="replaces substrings matching a regular expression by given string")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice regexpReplace(@SqlType(value="varchar") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern, @SqlType(value="varchar") Slice replacement) {
        return pattern.replace(source, replacement);
    }

    @Description(value="string(s) extracted using the given pattern")
    @ScalarFunction
    @SqlType(value="array<varchar>")
    public static Block regexpExtractAll(@SqlType(value="varchar") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return Re2JRegexpFunctions.regexpExtractAll(source, pattern, 0L);
    }

    @Description(value="group(s) extracted using the given pattern")
    @ScalarFunction
    @SqlType(value="array<varchar>")
    public static Block regexpExtractAll(@SqlType(value="varchar") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern, @SqlType(value="bigint") long groupIndex) {
        return pattern.extractAll(source, groupIndex);
    }

    @SqlNullable
    @Description(value="string extracted using the given pattern")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice regexpExtract(@SqlType(value="varchar") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return Re2JRegexpFunctions.regexpExtract(source, pattern, 0L);
    }

    @SqlNullable
    @Description(value="returns regex group of extracted string with a pattern")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice regexpExtract(@SqlType(value="varchar") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern, @SqlType(value="bigint") long groupIndex) {
        return pattern.extract(source, groupIndex);
    }

    @ScalarFunction
    @Description(value="returns array of strings split by pattern")
    @SqlType(value="array<varchar>")
    public static Block regexpSplit(@SqlType(value="varchar") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return pattern.split(source);
    }
}

