/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.index.PageBuffer;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;

public class PageBufferOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final PageBuffer pageBuffer;
    private ListenableFuture<?> blocked = NOT_BLOCKED;
    private boolean finished;

    public PageBufferOperator(OperatorContext operatorContext, PageBuffer pageBuffer) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.pageBuffer = Objects.requireNonNull(pageBuffer, "pageBuffer is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return ImmutableList.of();
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        this.updateBlockedIfNecessary();
        return this.finished && this.blocked == NOT_BLOCKED;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        this.updateBlockedIfNecessary();
        return this.blocked;
    }

    @Override
    public boolean needsInput() {
        this.updateBlockedIfNecessary();
        return !this.finished && this.blocked == NOT_BLOCKED;
    }

    private void updateBlockedIfNecessary() {
        if (this.blocked != NOT_BLOCKED && this.blocked.isDone()) {
            this.blocked = NOT_BLOCKED;
        }
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((this.blocked == NOT_BLOCKED ? 1 : 0) != 0, (Object)"output is already blocked");
        ListenableFuture<?> future = this.pageBuffer.add(page);
        if (!future.isDone()) {
            this.blocked = future;
        }
        this.operatorContext.recordGeneratedOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class PageBufferOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final PageBuffer pageBuffer;

        public PageBufferOperatorFactory(int operatorId, PlanNodeId planNodeId, PageBuffer pageBuffer) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.pageBuffer = Objects.requireNonNull(pageBuffer, "pageBuffer is null");
        }

        @Override
        public List<Type> getTypes() {
            return ImmutableList.of();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, PageBufferOperator.class.getSimpleName());
            return new PageBufferOperator(operatorContext, this.pageBuffer);
        }

        @Override
        public void close() {
        }

        @Override
        public OperatorFactory duplicate() {
            return new PageBufferOperatorFactory(this.operatorId, this.planNodeId, this.pageBuffer);
        }
    }
}

