/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.NullableDoubleState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;

public class NullableDoubleStateSerializer
implements AccumulatorStateSerializer<NullableDoubleState> {
    public Type getSerializedType() {
        return DoubleType.DOUBLE;
    }

    public void serialize(NullableDoubleState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            DoubleType.DOUBLE.writeDouble(out, state.getDouble());
        }
    }

    public void deserialize(Block block, int index, NullableDoubleState state) {
        state.setNull(false);
        state.setDouble(DoubleType.DOUBLE.getDouble(block, index));
    }
}

