/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.state.HyperLogLogState;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import io.airlift.slice.Slice;
import io.airlift.stats.cardinality.HyperLogLog;

@AggregationFunction(value="merge")
public final class MergeHyperLogLogAggregation {
    private static final AccumulatorStateSerializer<HyperLogLogState> serializer = new StateCompiler().generateStateSerializer(HyperLogLogState.class);

    private MergeHyperLogLogAggregation() {
    }

    @InputFunction
    public static void input(HyperLogLogState state, @SqlType(value="HyperLogLog") Slice value) {
        HyperLogLog input = HyperLogLog.newInstance((Slice)value);
        MergeHyperLogLogAggregation.merge(state, input);
    }

    @CombineFunction
    public static void combine(HyperLogLogState state, HyperLogLogState otherState) {
        MergeHyperLogLogAggregation.merge(state, otherState.getHyperLogLog());
    }

    private static void merge(HyperLogLogState state, HyperLogLog input) {
        HyperLogLog previous = state.getHyperLogLog();
        if (previous == null) {
            state.setHyperLogLog(input);
            state.addMemoryUsage(input.estimatedInMemorySize());
        } else {
            state.addMemoryUsage(-previous.estimatedInMemorySize());
            previous.mergeWith(input);
            state.addMemoryUsage(previous.estimatedInMemorySize());
        }
    }

    @OutputFunction(value="HyperLogLog")
    public static void output(HyperLogLogState state, BlockBuilder out) {
        serializer.serialize((Object)state, out);
    }
}

