/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AggregationCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.BlockIndex;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.LazyAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class BindableAggregationFunction
extends SqlAggregationFunction {
    private final String description;
    private final boolean decomposable;
    private final Class<?> definitionClass;
    private final Class<?> stateClass;
    private final Method inputFunction;
    private final Method outputFunction;

    public BindableAggregationFunction(Signature signature, String description, boolean decomposable, Class<?> definitionClass, Class<?> stateClass, Method inputFunction, Method outputFunction) {
        super(signature);
        this.description = description;
        this.decomposable = decomposable;
        this.definitionClass = definitionClass;
        this.stateClass = stateClass;
        this.inputFunction = inputFunction;
        this.outputFunction = outputFunction;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables variables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        AggregationMetadata metadata;
        Signature boundSignature = SignatureBinder.applyBoundVariables(this.getSignature(), variables, arity);
        List inputTypes = (List)boundSignature.getArgumentTypes().stream().map(x -> typeManager.getType(x)).collect(ImmutableCollectors.toImmutableList());
        Type outputType = typeManager.getType(boundSignature.getReturnType());
        AggregationFunction aggregationAnnotation = this.definitionClass.getAnnotation(AggregationFunction.class);
        Objects.requireNonNull(aggregationAnnotation, "aggregationAnnotation is null");
        DynamicClassLoader classLoader = new DynamicClassLoader(this.definitionClass.getClassLoader(), this.getClass().getClassLoader());
        AccumulatorStateSerializer<?> stateSerializer = new StateCompiler().generateStateSerializer(this.stateClass, classLoader);
        Type intermediateType = stateSerializer.getSerializedType();
        Method combineFunction = AggregationCompiler.getCombineFunction(this.definitionClass, this.stateClass);
        AccumulatorStateFactory<?> stateFactory = new StateCompiler().generateStateFactory(this.stateClass, classLoader);
        try {
            MethodHandle inputHandle = MethodHandles.lookup().unreflect(this.inputFunction);
            MethodHandle combineHandle = MethodHandles.lookup().unreflect(combineFunction);
            MethodHandle outputHandle = this.outputFunction == null ? null : MethodHandles.lookup().unreflect(this.outputFunction);
            metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(this.getSignature().getName(), outputType.getTypeSignature(), BindableAggregationFunction.signaturesFromTypes(inputTypes)), BindableAggregationFunction.getParameterMetadata(this.inputFunction, inputTypes), inputHandle, combineHandle, outputHandle, this.stateClass, stateSerializer, stateFactory, outputType);
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
        LazyAccumulatorFactoryBinder factory = new LazyAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(this.getSignature().getName(), inputTypes, intermediateType, outputType, this.decomposable, factory);
    }

    public InternalAggregationFunction specialize(BoundVariables variables, int arity, TypeManager typeManager) {
        return this.specialize(variables, arity, typeManager, null);
    }

    private static List<TypeSignature> signaturesFromTypes(List<Type> types) {
        return (List)types.stream().map(x -> x.getTypeSignature()).collect(ImmutableCollectors.toImmutableList());
    }

    private static List<AggregationMetadata.ParameterMetadata> getParameterMetadata(@Nullable Method method, List<Type> inputTypes) {
        if (method == null) {
            return null;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE));
        Annotation[][] annotations = method.getParameterAnnotations();
        String methodName = method.getDeclaringClass() + "." + method.getName();
        for (int i = 1; i < annotations.length; ++i) {
            Annotation baseTypeAnnotation = BindableAggregationFunction.baseTypeAnnotation(annotations[i], methodName);
            if (baseTypeAnnotation instanceof SqlType) {
                builder.add((Object)AggregationMetadata.ParameterMetadata.fromSqlType(inputTypes.get(i - 1), AggregationCompiler.isParameterBlock(annotations[i]), AggregationCompiler.isParameterNullable(annotations[i]), methodName));
                continue;
            }
            if (baseTypeAnnotation instanceof BlockIndex) {
                builder.add((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
                continue;
            }
            throw new IllegalArgumentException("Unsupported annotation: " + annotations[i]);
        }
        return builder.build();
    }

    private static Annotation baseTypeAnnotation(Annotation[] annotations, String methodName) {
        List baseTypes = (List)Arrays.asList(annotations).stream().filter(annotation -> annotation instanceof SqlType || annotation instanceof BlockIndex).collect(ImmutableCollectors.toImmutableList());
        Preconditions.checkArgument((baseTypes.size() == 1 ? 1 : 0) != 0, (String)"Parameter of %s must have exactly one of @SqlType, @BlockIndex", (Object[])new Object[]{methodName});
        boolean nullable = AggregationCompiler.isParameterNullable(annotations);
        boolean isBlock = AggregationCompiler.isParameterBlock(annotations);
        Annotation annotation2 = (Annotation)baseTypes.get(0);
        Preconditions.checkArgument((!isBlock && !nullable || annotation2 instanceof SqlType ? 1 : 0) != 0, (String)"%s contains a parameter with @BlockPosition and/or @NullablePosition that is not @SqlType", (Object[])new Object[]{methodName});
        return annotation2;
    }
}

