/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceFactory;
import com.facebook.presto.operator.OuterLookupSource;
import com.facebook.presto.operator.PartitionedLookupSource;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;

public final class PartitionedLookupSourceFactory
implements LookupSourceFactory {
    private final List<Type> types;
    private final Map<Symbol, Integer> layout;
    private final List<Type> hashChannelTypes;
    private final Supplier<LookupSource>[] partitions;
    private final boolean outer;
    private final CompletableFuture<?> destroyed = new CompletableFuture();
    @GuardedBy(value="this")
    private int partitionsSet;
    @GuardedBy(value="this")
    private Supplier<LookupSource> lookupSourceSupplier;
    @GuardedBy(value="this")
    private final List<SettableFuture<LookupSource>> lookupSourceFutures = new ArrayList<SettableFuture<LookupSource>>();

    public PartitionedLookupSourceFactory(List<Type> types, List<Integer> hashChannels, int partitionCount, Map<Symbol, Integer> layout, boolean outer) {
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.layout = ImmutableMap.copyOf(layout);
        this.partitions = new Supplier[partitionCount];
        this.outer = outer;
        this.hashChannelTypes = (List)hashChannels.stream().map(types::get).collect(ImmutableCollectors.toImmutableList());
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public Map<Symbol, Integer> getLayout() {
        return this.layout;
    }

    @Override
    public synchronized ListenableFuture<LookupSource> createLookupSource() {
        if (this.lookupSourceSupplier != null) {
            return Futures.immediateFuture((Object)this.lookupSourceSupplier.get());
        }
        SettableFuture lookupSourceFuture = SettableFuture.create();
        this.lookupSourceFutures.add((SettableFuture<LookupSource>)lookupSourceFuture);
        return lookupSourceFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPartitionLookupSourceSupplier(int partitionIndex, Supplier<LookupSource> partitionLookupSource) {
        Objects.requireNonNull(partitionLookupSource, "partitionLookupSource is null");
        Supplier<LookupSource> lookupSourceSupplier = null;
        List lookupSourceFutures = null;
        PartitionedLookupSourceFactory partitionedLookupSourceFactory = this;
        synchronized (partitionedLookupSourceFactory) {
            if (this.destroyed.isDone()) {
                return;
            }
            Preconditions.checkState((this.partitions[partitionIndex] == null ? 1 : 0) != 0, (Object)"Partition already set");
            this.partitions[partitionIndex] = partitionLookupSource;
            ++this.partitionsSet;
            if (this.partitionsSet == this.partitions.length) {
                if (this.partitionsSet != 1) {
                    ImmutableList partitions = ImmutableList.copyOf((Object[])this.partitions);
                    this.lookupSourceSupplier = PartitionedLookupSource.createPartitionedLookupSourceSupplier((List<Supplier<LookupSource>>)partitions, this.hashChannelTypes, this.outer);
                } else {
                    this.lookupSourceSupplier = this.outer ? OuterLookupSource.createOuterLookupSourceSupplier(partitionLookupSource) : partitionLookupSource;
                }
                lookupSourceSupplier = this.lookupSourceSupplier;
                lookupSourceFutures = ImmutableList.copyOf(this.lookupSourceFutures);
            }
        }
        if (lookupSourceSupplier != null) {
            for (SettableFuture lookupSourceFuture : lookupSourceFutures) {
                lookupSourceFuture.set((Object)lookupSourceSupplier.get());
            }
        }
    }

    @Override
    public void destroy() {
        this.destroyed.complete(null);
    }

    public CompletableFuture<?> isDestroyed() {
        return MoreFutures.unmodifiableFuture(this.destroyed);
    }
}

