/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.exchange.LocalPartitionGenerator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@NotThreadSafe
public class PartitionedLookupSource
implements LookupSource {
    private final LookupSource[] lookupSources;
    private final LocalPartitionGenerator partitionGenerator;
    private final int partitionMask;
    private final int shiftSize;
    @Nullable
    private final OuterPositionTracker outerPositionTracker;

    public static Supplier<LookupSource> createPartitionedLookupSourceSupplier(List<Supplier<LookupSource>> partitions, List<Type> hashChannelTypes, boolean outer) {
        Optional<OuterPositionTracker> outerPositionTracker = Optional.ofNullable(outer ? new OuterPositionTracker(partitions) : null);
        return () -> new PartitionedLookupSource((List)partitions.stream().map(Supplier::get).collect(ImmutableCollectors.toImmutableList()), hashChannelTypes, outerPositionTracker);
    }

    private PartitionedLookupSource(List<? extends LookupSource> lookupSources, List<Type> hashChannelTypes, Optional<OuterPositionTracker> outerPositionTracker) {
        this.lookupSources = lookupSources.toArray(new LookupSource[lookupSources.size()]);
        int[] hashChannels = new int[hashChannelTypes.size()];
        for (int i = 0; i < hashChannels.length; ++i) {
            hashChannels[i] = i;
        }
        this.partitionGenerator = new LocalPartitionGenerator(new InterpretedHashGenerator(hashChannelTypes, hashChannels), lookupSources.size());
        this.partitionMask = lookupSources.size() - 1;
        this.shiftSize = Integer.numberOfTrailingZeros(lookupSources.size()) + 1;
        this.outerPositionTracker = outerPositionTracker.orElse(null);
    }

    @Override
    public int getChannelCount() {
        return this.lookupSources[0].getChannelCount();
    }

    @Override
    public int getJoinPositionCount() {
        throw new UnsupportedOperationException("Parallel hash can not be used in a RIGHT or FULL outer join");
    }

    @Override
    public long getInMemorySizeInBytes() {
        return Arrays.stream(this.lookupSources).mapToLong(LookupSource::getInMemorySizeInBytes).sum();
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage) {
        return this.getJoinPosition(position, hashChannelsPage, allChannelsPage, this.partitionGenerator.getRawHash(position, hashChannelsPage));
    }

    @Override
    public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage, long rawHash) {
        int partition = this.partitionGenerator.getPartition(rawHash);
        LookupSource lookupSource = this.lookupSources[partition];
        long joinPosition = lookupSource.getJoinPosition(position, hashChannelsPage, allChannelsPage, rawHash);
        if (joinPosition < 0L) {
            return joinPosition;
        }
        return this.encodePartitionedJoinPosition(partition, Ints.checkedCast((long)joinPosition));
    }

    @Override
    public long getNextJoinPosition(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
        long joinPosition;
        int partition = this.decodePartition(currentJoinPosition);
        LookupSource lookupSource = this.lookupSources[partition];
        long nextJoinPosition = lookupSource.getNextJoinPosition(joinPosition = (long)this.decodeJoinPosition(currentJoinPosition), probePosition, allProbeChannelsPage);
        if (nextJoinPosition < 0L) {
            return nextJoinPosition;
        }
        return this.encodePartitionedJoinPosition(partition, Ints.checkedCast((long)nextJoinPosition));
    }

    @Override
    public void appendTo(long partitionedJoinPosition, PageBuilder pageBuilder, int outputChannelOffset) {
        int partition = this.decodePartition(partitionedJoinPosition);
        int joinPosition = this.decodeJoinPosition(partitionedJoinPosition);
        this.lookupSources[partition].appendTo(joinPosition, pageBuilder, outputChannelOffset);
        if (this.outerPositionTracker != null) {
            this.outerPositionTracker.positionVisited(partition, joinPosition);
        }
    }

    @Override
    public LookupSource.OuterPositionIterator getOuterPositionIterator() {
        Preconditions.checkState((this.outerPositionTracker != null ? 1 : 0) != 0, (Object)"This is not an outer lookup source");
        return this.outerPositionTracker.getOuterPositionIterator();
    }

    private int decodePartition(long partitionedJoinPosition) {
        return (int)(partitionedJoinPosition & (long)this.partitionMask);
    }

    private int decodeJoinPosition(long partitionedJoinPosition) {
        return Ints.checkedCast((long)(partitionedJoinPosition >>> this.shiftSize));
    }

    private long encodePartitionedJoinPosition(int partition, int joinPosition) {
        return joinPosition << this.shiftSize | partition;
    }

    @ThreadSafe
    private static class OuterPositionTracker {
        private final List<Supplier<LookupSource>> lookupSourceSuppliers;
        @GuardedBy(value="this")
        private final boolean[][] visitedPositions;
        @GuardedBy(value="this")
        private boolean finished;

        public OuterPositionTracker(List<Supplier<LookupSource>> lookupSourceSuppliers) {
            this.lookupSourceSuppliers = lookupSourceSuppliers;
            this.visitedPositions = new boolean[lookupSourceSuppliers.size()][];
            for (int source = 0; source < lookupSourceSuppliers.size(); ++source) {
                try (LookupSource lookupSource = lookupSourceSuppliers.get(source).get();){
                    this.visitedPositions[source] = new boolean[lookupSource.getJoinPositionCount()];
                    continue;
                }
            }
        }

        public synchronized void positionVisited(int partition, int position) {
            Verify.verify((!this.finished ? 1 : 0) != 0);
            this.visitedPositions[partition][position] = true;
        }

        public synchronized LookupSource.OuterPositionIterator getOuterPositionIterator() {
            this.finished = true;
            LookupSource[] lookupSources = (LookupSource[])this.lookupSourceSuppliers.stream().map(Supplier::get).toArray(LookupSource[]::new);
            return new PartitionedLookupOuterPositionIterator(lookupSources, this.visitedPositions);
        }
    }

    private static class PartitionedLookupOuterPositionIterator
    implements LookupSource.OuterPositionIterator {
        private final LookupSource[] lookupSources;
        private final boolean[][] visitedPositions;
        @GuardedBy(value="this")
        private int currentSource;
        @GuardedBy(value="this")
        private int currentPosition;

        public PartitionedLookupOuterPositionIterator(LookupSource[] lookupSources, boolean[][] visitedPositions) {
            this.lookupSources = lookupSources;
            this.visitedPositions = visitedPositions;
        }

        @Override
        public synchronized boolean appendToNext(PageBuilder pageBuilder, int outputChannelOffset) {
            while (this.currentSource < this.lookupSources.length) {
                while (this.currentPosition < this.visitedPositions[this.currentSource].length) {
                    if (!this.visitedPositions[this.currentSource][this.currentPosition]) {
                        this.lookupSources[this.currentSource].appendTo(this.currentPosition, pageBuilder, outputChannelOffset);
                        ++this.currentPosition;
                        return true;
                    }
                    ++this.currentPosition;
                }
                this.currentPosition = 0;
                ++this.currentSource;
            }
            return false;
        }
    }
}

