/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.builder.HashAggregationBuilder;
import com.facebook.presto.operator.aggregation.builder.InMemoryHashAggregationBuilder;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class HashAggregationOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> groupByTypes;
    private final List<Integer> groupByChannels;
    private final List<Integer> globalAggregationGroupIds;
    private final AggregationNode.Step step;
    private final List<AccumulatorFactory> accumulatorFactories;
    private final Optional<Integer> hashChannel;
    private final Optional<Integer> groupIdChannel;
    private final int expectedGroups;
    private final DataSize maxPartialMemory;
    private final List<Type> types;
    private HashAggregationBuilder aggregationBuilder;
    private Iterator<Page> outputIterator;
    private boolean inputProcessed;
    private boolean finishing;
    private boolean finished;

    public HashAggregationOperator(OperatorContext operatorContext, List<Type> groupByTypes, List<Integer> groupByChannels, List<Integer> globalAggregationGroupIds, AggregationNode.Step step, List<AccumulatorFactory> accumulatorFactories, Optional<Integer> hashChannel, Optional<Integer> groupIdChannel, int expectedGroups, DataSize maxPartialMemory) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        Objects.requireNonNull(step, "step is null");
        Objects.requireNonNull(accumulatorFactories, "accumulatorFactories is null");
        Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.groupByTypes = ImmutableList.copyOf(groupByTypes);
        this.groupByChannels = ImmutableList.copyOf(groupByChannels);
        this.globalAggregationGroupIds = ImmutableList.copyOf(globalAggregationGroupIds);
        this.accumulatorFactories = ImmutableList.copyOf(accumulatorFactories);
        this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
        this.groupIdChannel = Objects.requireNonNull(groupIdChannel, "groupIdChannel is null");
        this.step = step;
        this.expectedGroups = expectedGroups;
        this.maxPartialMemory = Objects.requireNonNull(maxPartialMemory, "maxPartialMemory is null");
        this.types = InMemoryHashAggregationBuilder.toTypes(groupByTypes, step, accumulatorFactories, hashChannel);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.outputIterator == null && (this.aggregationBuilder == null || !this.aggregationBuilder.isFull());
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        this.inputProcessed = true;
        if (this.aggregationBuilder == null) {
            this.aggregationBuilder = new InMemoryHashAggregationBuilder(this.accumulatorFactories, this.step, this.expectedGroups, this.groupByTypes, this.groupByChannels, this.hashChannel, this.operatorContext, this.maxPartialMemory);
        } else {
            Preconditions.checkState((!this.aggregationBuilder.isFull() ? 1 : 0) != 0, (Object)"Aggregation buffer is full");
        }
        this.aggregationBuilder.processPage(page);
    }

    @Override
    public Page getOutput() {
        if (this.finished) {
            return null;
        }
        if (this.outputIterator == null) {
            this.outputIterator = null;
            if (this.finishing) {
                if (!this.inputProcessed && !this.step.isOutputPartial()) {
                    this.finished = true;
                    return this.getGlobalAggregationOutput();
                }
                if (this.aggregationBuilder == null) {
                    this.finished = true;
                    return null;
                }
            }
            if (!(this.finishing || this.aggregationBuilder != null && this.aggregationBuilder.isFull())) {
                return null;
            }
            this.outputIterator = this.aggregationBuilder.buildResult();
            if (!this.outputIterator.hasNext()) {
                this.closeAggregationBuilder();
                return null;
            }
        }
        Page output = this.outputIterator.next();
        if (!this.outputIterator.hasNext()) {
            this.closeAggregationBuilder();
        }
        return output;
    }

    @Override
    public void close() {
        this.closeAggregationBuilder();
    }

    private void closeAggregationBuilder() {
        this.outputIterator = null;
        if (this.aggregationBuilder != null) {
            this.aggregationBuilder.close();
            this.aggregationBuilder = null;
        }
    }

    private Page getGlobalAggregationOutput() {
        List accumulators = this.accumulatorFactories.stream().map(AccumulatorFactory::createAccumulator).collect(Collectors.toList());
        PageBuilder output = new PageBuilder(this.types);
        for (int groupId : this.globalAggregationGroupIds) {
            int channel;
            output.declarePosition();
            for (channel = 0; channel < this.groupByTypes.size(); ++channel) {
                if (channel == this.groupIdChannel.get()) {
                    output.getBlockBuilder(channel).writeLong((long)groupId);
                    continue;
                }
                output.getBlockBuilder(channel).appendNull();
            }
            if (this.hashChannel.isPresent()) {
                output.getBlockBuilder(channel++).writeLong(0L);
            }
            for (int j = 0; j < accumulators.size(); ++j) {
                ((Accumulator)accumulators.get(j)).evaluateFinal(output.getBlockBuilder(channel));
                ++channel;
            }
        }
        if (output.isEmpty()) {
            return null;
        }
        return output.build();
    }

    public static class HashAggregationOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> groupByTypes;
        private final List<Integer> groupByChannels;
        private final List<Integer> globalAggregationGroupIds;
        private final AggregationNode.Step step;
        private final List<AccumulatorFactory> accumulatorFactories;
        private final Optional<Integer> hashChannel;
        private final Optional<Integer> groupIdChannel;
        private final int expectedGroups;
        private final List<Type> types;
        private final DataSize maxPartialMemory;
        private boolean closed;

        public HashAggregationOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> groupByTypes, List<Integer> groupByChannels, List<Integer> globalAggregationGroupIds, AggregationNode.Step step, List<AccumulatorFactory> accumulatorFactories, Optional<Integer> hashChannel, Optional<Integer> groupIdChannel, int expectedGroups, DataSize maxPartialMemory) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
            this.groupIdChannel = Objects.requireNonNull(groupIdChannel, "groupIdChannel is null");
            this.groupByTypes = ImmutableList.copyOf(groupByTypes);
            this.groupByChannels = ImmutableList.copyOf(groupByChannels);
            this.globalAggregationGroupIds = ImmutableList.copyOf(globalAggregationGroupIds);
            this.step = step;
            this.accumulatorFactories = ImmutableList.copyOf(accumulatorFactories);
            this.expectedGroups = expectedGroups;
            this.maxPartialMemory = Objects.requireNonNull(maxPartialMemory, "maxPartialMemory is null");
            this.types = InMemoryHashAggregationBuilder.toTypes(groupByTypes, step, accumulatorFactories, hashChannel);
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, HashAggregationOperator.class.getSimpleName());
            HashAggregationOperator hashAggregationOperator = new HashAggregationOperator(operatorContext, this.groupByTypes, this.groupByChannels, this.globalAggregationGroupIds, this.step, this.accumulatorFactories, this.hashChannel, this.groupIdChannel, this.expectedGroups, this.maxPartialMemory);
            return hashAggregationOperator;
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new HashAggregationOperatorFactory(this.operatorId, this.planNodeId, this.groupByTypes, this.groupByChannels, this.globalAggregationGroupIds, this.step, this.accumulatorFactories, this.hashChannel, this.groupIdChannel, this.expectedGroups, this.maxPartialMemory);
        }
    }
}

