/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.operator.BigintGroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.MultiChannelGroupByHash;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import java.util.List;
import java.util.Optional;

public interface GroupByHash {
    public static GroupByHash createGroupByHash(Session session, List<? extends Type> hashTypes, int[] hashChannels, Optional<Integer> inputHashChannel, int expectedSize) {
        return GroupByHash.createGroupByHash(hashTypes, hashChannels, inputHashChannel, expectedSize, SystemSessionProperties.isDictionaryAggregationEnabled(session));
    }

    public static GroupByHash createGroupByHash(List<? extends Type> hashTypes, int[] hashChannels, Optional<Integer> inputHashChannel, int expectedSize, boolean processDictionary) {
        if (hashTypes.size() == 1 && hashTypes.get(0).equals(BigintType.BIGINT) && hashChannels.length == 1) {
            return new BigintGroupByHash(hashChannels[0], inputHashChannel.isPresent(), expectedSize);
        }
        return new MultiChannelGroupByHash(hashTypes, hashChannels, inputHashChannel, expectedSize, processDictionary);
    }

    public long getEstimatedSize();

    public List<Type> getTypes();

    public int getGroupCount();

    public void appendValuesTo(int var1, PageBuilder var2, int var3);

    public void addPage(Page var1);

    public GroupByIdBlock getGroupIds(Page var1);

    public boolean contains(int var1, Page var2, int[] var3);

    public int putIfAbsent(int var1, Page var2);

    public long getRawHash(int var1);
}

