/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.PolymorphicScalarFunction;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public final class SqlScalarFunctionBuilder {
    private final Class<?> clazz;
    private Signature signature;
    private String description;
    private Optional<Boolean> hidden = Optional.empty();
    private boolean deterministic;
    private boolean nullableResult;
    private List<Boolean> nullableArguments = Collections.emptyList();
    private List<Boolean> nullFlags = Collections.emptyList();
    private List<MethodsGroup> methodsGroups = new ArrayList<MethodsGroup>();

    public SqlScalarFunctionBuilder(Class<?> clazz) {
        this.clazz = clazz;
    }

    public SqlScalarFunctionBuilder signature(Signature signature) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.hidden = Optional.of(this.hidden.orElse(SqlScalarFunctionBuilder.isOperator(signature)));
        return this;
    }

    public SqlScalarFunctionBuilder description(String description) {
        this.description = description;
        return this;
    }

    public SqlScalarFunctionBuilder hidden(boolean hidden) {
        this.hidden = Optional.of(hidden);
        return this;
    }

    public SqlScalarFunctionBuilder deterministic(boolean deterministic) {
        this.deterministic = deterministic;
        return this;
    }

    public SqlScalarFunctionBuilder nullableResult(boolean nullableResult) {
        this.nullableResult = nullableResult;
        return this;
    }

    public SqlScalarFunctionBuilder nullableArguments(boolean ... nullableArguments) {
        Objects.requireNonNull(nullableArguments, "nullableArguments is null");
        ImmutableList.Builder nullableArgumentsBuilder = ImmutableList.builder();
        for (boolean nullableArgument : nullableArguments) {
            nullableArgumentsBuilder.add((Object)nullableArgument);
        }
        this.nullableArguments = nullableArgumentsBuilder.build();
        return this;
    }

    public SqlScalarFunctionBuilder nullableArguments(List<Boolean> nullableArguments) {
        this.nullableArguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(nullableArguments, "nullableArguments is null"));
        return this;
    }

    public SqlScalarFunctionBuilder nullFlags(boolean ... nullFlags) {
        Objects.requireNonNull(nullFlags, "nullFlags is null");
        ImmutableList.Builder nullFlagsBuilder = ImmutableList.builder();
        for (boolean flag : nullFlags) {
            nullFlagsBuilder.add((Object)flag);
        }
        this.nullFlags = nullFlagsBuilder.build();
        return this;
    }

    public SqlScalarFunctionBuilder implementation(Function<MethodsGroupBuilder, MethodsGroupBuilder> methodGroupSpecification) {
        MethodsGroupBuilder methodsGroupBuilder = new MethodsGroupBuilder(this.clazz);
        methodGroupSpecification.apply(methodsGroupBuilder);
        MethodsGroup methodsGroup = methodsGroupBuilder.build();
        this.methodsGroups.add(methodsGroup);
        return this;
    }

    public SqlScalarFunction build() {
        Preconditions.checkState((this.signature != null ? 1 : 0) != 0, (Object)"signature is null");
        if (this.nullableArguments.isEmpty()) {
            this.nullableArguments = Collections.nCopies(this.signature.getArgumentTypes().size(), false);
        }
        if (this.nullFlags.isEmpty()) {
            this.nullFlags = Collections.nCopies(this.signature.getArgumentTypes().size(), false);
        }
        return new PolymorphicScalarFunction(this.signature, this.description, this.hidden.orElse(false), this.deterministic, this.nullableResult, this.nullableArguments, this.nullFlags, this.methodsGroups);
    }

    @SafeVarargs
    public static Function<SpecializeContext, List<Object>> concat(Function<SpecializeContext, List<Object>> ... extraParametersFunctions) {
        return context -> {
            ImmutableList.Builder extraParametersBuilder = ImmutableList.builder();
            for (Function extraParametersFunction : extraParametersFunctions) {
                extraParametersBuilder.addAll((Iterable)extraParametersFunction.apply(context));
            }
            return extraParametersBuilder.build();
        };
    }

    public static <T> Function<SpecializeContext, List<Object>> constant(T value) {
        return context -> ImmutableList.of((Object)value);
    }

    private static boolean isOperator(Signature signature) {
        for (OperatorType operator : OperatorType.values()) {
            if (!signature.getName().equals(FunctionRegistry.mangleOperatorName(operator))) continue;
            return true;
        }
        return false;
    }

    static class MethodsGroup {
        private final List<Method> methods;
        private final Optional<Predicate<SpecializeContext>> predicate;
        private final Optional<Function<SpecializeContext, List<Object>>> extraParametersFunction;

        private MethodsGroup(List<Method> methods, Optional<Predicate<SpecializeContext>> predicate, Optional<Function<SpecializeContext, List<Object>>> extraParametersFunction) {
            this.methods = Objects.requireNonNull(methods, "methods is null");
            this.predicate = Objects.requireNonNull(predicate, "predicate is null");
            this.extraParametersFunction = Objects.requireNonNull(extraParametersFunction, "extraParametersFunction is null");
        }

        List<Method> getMethods() {
            return this.methods;
        }

        Optional<Predicate<SpecializeContext>> getPredicate() {
            return this.predicate;
        }

        Optional<Function<SpecializeContext, List<Object>>> getExtraParametersFunction() {
            return this.extraParametersFunction;
        }
    }

    public static class MethodsGroupBuilder {
        private final Class<?> clazz;
        private List<Method> methods = null;
        private Optional<Predicate<SpecializeContext>> predicate = Optional.empty();
        private Optional<Function<SpecializeContext, List<Object>>> extraParametersFunction = Optional.empty();

        private MethodsGroupBuilder(Class<?> clazz) {
            this.clazz = clazz;
        }

        public MethodsGroupBuilder methods(String ... methodNames) {
            return this.methods(Arrays.asList((Object[])Objects.requireNonNull(methodNames, "methodNames is null")));
        }

        public MethodsGroupBuilder methods(List<String> methodNames) {
            Objects.requireNonNull(methodNames, "methodNames is null");
            Preconditions.checkArgument((!methodNames.isEmpty() ? 1 : 0) != 0, (Object)"methods list is empty");
            List matchingMethods = (List)Arrays.asList(this.clazz.getMethods()).stream().filter(method -> methodNames.contains(method.getName())).collect(ImmutableCollectors.toImmutableList());
            List matchingMethodNames = (List)matchingMethods.stream().map(Method::getName).collect(ImmutableCollectors.toImmutableList());
            for (String methodName : methodNames) {
                Preconditions.checkState((boolean)matchingMethodNames.contains(methodName), (String)"method %s was not found in %s", (Object[])new Object[]{methodName, this.clazz});
            }
            this.methods = matchingMethods;
            return this;
        }

        public MethodsGroupBuilder withPredicate(Predicate<SpecializeContext> predicate) {
            Preconditions.checkState((this.methods != null ? 1 : 0) != 0, (Object)"methods must be selected first");
            Objects.requireNonNull(predicate, "predicate is null");
            this.predicate = Optional.of(predicate);
            return this;
        }

        public MethodsGroupBuilder withExtraParameters(Function<SpecializeContext, List<Object>> extraParametersFunction) {
            Preconditions.checkState((this.methods != null ? 1 : 0) != 0, (Object)"methods must be selected first");
            Objects.requireNonNull(extraParametersFunction, "extraParametersFunction is null");
            this.extraParametersFunction = Optional.of(extraParametersFunction);
            return this;
        }

        public MethodsGroup build() {
            return new MethodsGroup(this.methods, this.predicate, this.extraParametersFunction);
        }
    }

    public static class SpecializeContext {
        private final BoundVariables boundVariables;
        private final List<Type> parameterTypes;
        private final Type returnType;
        private final TypeManager typeManager;
        private final FunctionRegistry functionRegistry;

        SpecializeContext(BoundVariables boundVariables, List<Type> parameterTypes, Type returnType, TypeManager typeManager, FunctionRegistry functionRegistry) {
            this.boundVariables = Objects.requireNonNull(boundVariables, "boundVariables is null");
            this.parameterTypes = Objects.requireNonNull(parameterTypes, "parameterTypes is null");
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
            this.returnType = Objects.requireNonNull(returnType, "returnType is null");
            this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry is null");
        }

        public Type getType(String name) {
            return this.boundVariables.getTypeVariable(name);
        }

        public Long getLiteral(String name) {
            return this.boundVariables.getLongVariable(name);
        }

        public List<Type> getParameterTypes() {
            return this.parameterTypes;
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public TypeManager getTypeManager() {
            return this.typeManager;
        }

        public FunctionRegistry getFunctionRegistry() {
            return this.functionRegistry;
        }
    }
}

