/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.execution.scheduler.OutputBufferManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PartitionedOutputBufferManager
implements OutputBufferManager {
    private final Map<OutputBuffers.OutputBufferId, Integer> outputBuffers;

    public PartitionedOutputBufferManager(int partitionCount, Consumer<OutputBuffers> outputBufferTarget) {
        Preconditions.checkArgument((partitionCount >= 1 ? 1 : 0) != 0, (Object)"partitionCount must be at least 1");
        ImmutableMap.Builder partitions = ImmutableMap.builder();
        for (int partition = 0; partition < partitionCount; ++partition) {
            partitions.put((Object)new OutputBuffers.OutputBufferId(partition), (Object)partition);
        }
        OutputBuffers outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers(OutputBuffers.BufferType.PARTITIONED).withBuffers((Map<OutputBuffers.OutputBufferId, Integer>)partitions.build()).withNoMoreBufferIds();
        outputBufferTarget.accept(outputBuffers);
        this.outputBuffers = outputBuffers.getBuffers();
    }

    @Override
    public void addOutputBuffers(List<OutputBuffers.OutputBufferId> newBuffers, boolean noMoreBuffers) {
        for (OutputBuffers.OutputBufferId newBuffer : newBuffers) {
            Integer existingBufferId = this.outputBuffers.get(newBuffer);
            if (existingBufferId == null) {
                throw new IllegalStateException("Unexpected new output buffer " + newBuffer);
            }
            if (newBuffer.getId() == existingBufferId.intValue()) continue;
            throw new IllegalStateException("newOutputBuffers has changed the assignment for task " + newBuffer);
        }
    }
}

