/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.resourceGroups.FifoQueue;
import com.facebook.presto.execution.resourceGroups.IndexedPriorityQueue;
import com.facebook.presto.execution.resourceGroups.ResourceGroupInfo;
import com.facebook.presto.execution.resourceGroups.StochasticPriorityQueue;
import com.facebook.presto.execution.resourceGroups.UpdateablePriorityQueue;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.ErrorType;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.resourceGroups.ResourceGroup;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.resourceGroups.SchedulingPolicy;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Managed;

@ThreadSafe
public class InternalResourceGroup
implements ResourceGroup {
    public static final int DEFAULT_WEIGHT = 1;
    private final InternalResourceGroup root;
    private final Optional<InternalResourceGroup> parent;
    private final ResourceGroupId id;
    private final BiConsumer<InternalResourceGroup, Boolean> jmxExportListener;
    private final Executor executor;
    @GuardedBy(value="root")
    private final Map<String, InternalResourceGroup> subGroups = new HashMap<String, InternalResourceGroup>();
    @GuardedBy(value="root")
    private UpdateablePriorityQueue<InternalResourceGroup> eligibleSubGroups = new FifoQueue<InternalResourceGroup>();
    @GuardedBy(value="root")
    private final Set<InternalResourceGroup> dirtySubGroups = new HashSet<InternalResourceGroup>();
    @GuardedBy(value="root")
    private long softMemoryLimitBytes;
    @GuardedBy(value="root")
    private int maxRunningQueries;
    @GuardedBy(value="root")
    private int maxQueuedQueries;
    @GuardedBy(value="root")
    private long softCpuLimitMillis = Long.MAX_VALUE;
    @GuardedBy(value="root")
    private long hardCpuLimitMillis = Long.MAX_VALUE;
    @GuardedBy(value="root")
    private long cpuUsageMillis;
    @GuardedBy(value="root")
    private long cpuQuotaGenerationMillisPerSecond = Long.MAX_VALUE;
    @GuardedBy(value="root")
    private int descendantRunningQueries;
    @GuardedBy(value="root")
    private int descendantQueuedQueries;
    @GuardedBy(value="root")
    private long cachedMemoryUsageBytes;
    @GuardedBy(value="root")
    private int schedulingWeight = 1;
    @GuardedBy(value="root")
    private UpdateablePriorityQueue<QueryExecution> queuedQueries = new FifoQueue<QueryExecution>();
    @GuardedBy(value="root")
    private final Set<QueryExecution> runningQueries = new HashSet<QueryExecution>();
    @GuardedBy(value="root")
    private SchedulingPolicy schedulingPolicy = SchedulingPolicy.FAIR;
    @GuardedBy(value="root")
    private boolean jmxExport;

    protected InternalResourceGroup(Optional<InternalResourceGroup> parent, String name, BiConsumer<InternalResourceGroup, Boolean> jmxExportListener, Executor executor) {
        this.parent = Objects.requireNonNull(parent, "parent is null");
        this.jmxExportListener = Objects.requireNonNull(jmxExportListener, "jmxExportListener is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(name, "name is null");
        if (parent.isPresent()) {
            this.id = new ResourceGroupId(parent.get().id, name);
            this.root = parent.get().root;
        } else {
            this.id = new ResourceGroupId(name);
            this.root = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceGroupInfo getInfo() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            List<ResourceGroupInfo> infos = this.subGroups.values().stream().map(InternalResourceGroup::getInfo).collect(Collectors.toList());
            return new ResourceGroupInfo(this.id, new DataSize((double)this.softMemoryLimitBytes, DataSize.Unit.BYTE), this.maxRunningQueries, this.maxQueuedQueries, this.runningQueries.size() + this.descendantRunningQueries, this.queuedQueries.size() + this.descendantQueuedQueries, new DataSize((double)this.cachedMemoryUsageBytes, DataSize.Unit.BYTE), infos);
        }
    }

    public ResourceGroupId getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getRunningQueries() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.runningQueries.size() + this.descendantRunningQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getQueuedQueries() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.queuedQueries.size() + this.descendantQueuedQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSize getSoftMemoryLimit() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return new DataSize((double)this.softMemoryLimitBytes, DataSize.Unit.BYTE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoftMemoryLimit(DataSize limit) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            boolean oldCanRun = this.canRunMore();
            this.softMemoryLimitBytes = limit.toBytes();
            if (this.canRunMore() != oldCanRun) {
                this.updateEligiblility();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Duration getSoftCpuLimit() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return new Duration((double)this.softCpuLimitMillis, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoftCpuLimit(Duration limit) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (limit.toMillis() > this.hardCpuLimitMillis) {
                this.setHardCpuLimit(limit);
            }
            boolean oldCanRun = this.canRunMore();
            this.softCpuLimitMillis = limit.toMillis();
            if (this.canRunMore() != oldCanRun) {
                this.updateEligiblility();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Duration getHardCpuLimit() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return new Duration((double)this.hardCpuLimitMillis, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHardCpuLimit(Duration limit) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (limit.toMillis() < this.softCpuLimitMillis) {
                this.setSoftCpuLimit(limit);
            }
            boolean oldCanRun = this.canRunMore();
            this.hardCpuLimitMillis = limit.toMillis();
            if (this.canRunMore() != oldCanRun) {
                this.updateEligiblility();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCpuQuotaGenerationMillisPerSecond() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.cpuQuotaGenerationMillisPerSecond;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCpuQuotaGenerationMillisPerSecond(long rate) {
        Preconditions.checkArgument((rate > 0L ? 1 : 0) != 0, (Object)"Cpu quota generation must be positive");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.cpuQuotaGenerationMillisPerSecond = rate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getMaxRunningQueries() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.maxRunningQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public void setMaxRunningQueries(int maxRunningQueries) {
        Preconditions.checkArgument((maxRunningQueries >= 0 ? 1 : 0) != 0, (Object)"maxRunningQueries is negative");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            boolean oldCanRun = this.canRunMore();
            this.maxRunningQueries = maxRunningQueries;
            if (this.canRunMore() != oldCanRun) {
                this.updateEligiblility();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getMaxQueuedQueries() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.maxQueuedQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public void setMaxQueuedQueries(int maxQueuedQueries) {
        Preconditions.checkArgument((maxQueuedQueries >= 0 ? 1 : 0) != 0, (Object)"maxQueuedQueries is negative");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.maxQueuedQueries = maxQueuedQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSchedulingWeight() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.schedulingWeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchedulingWeight(int weight) {
        Preconditions.checkArgument((weight > 0 ? 1 : 0) != 0, (Object)"weight must be positive");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.schedulingWeight = weight;
            if (this.parent.isPresent() && this.parent.get().schedulingPolicy == SchedulingPolicy.WEIGHTED && this.parent.get().eligibleSubGroups.contains(this)) {
                this.parent.get().eligibleSubGroups.addOrUpdate(this, weight);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchedulingPolicy getSchedulingPolicy() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.schedulingPolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchedulingPolicy(SchedulingPolicy policy) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            UpdateablePriorityQueue<QueryExecution> queryQueue;
            UpdateablePriorityQueue<InternalResourceGroup> queue;
            if (policy == this.schedulingPolicy) {
                return;
            }
            if (this.parent.isPresent() && this.parent.get().schedulingPolicy == SchedulingPolicy.QUERY_PRIORITY) {
                Preconditions.checkArgument((policy == SchedulingPolicy.QUERY_PRIORITY ? 1 : 0) != 0, (String)"Parent of %s uses query priority scheduling, so %s must also", (Object[])new Object[]{this.id, this.id});
            }
            switch (policy) {
                case FAIR: {
                    queue = new FifoQueue();
                    queryQueue = new FifoQueue();
                    break;
                }
                case WEIGHTED: {
                    queue = new StochasticPriorityQueue();
                    queryQueue = new StochasticPriorityQueue();
                    break;
                }
                case QUERY_PRIORITY: {
                    for (InternalResourceGroup group : this.subGroups.values()) {
                        group.setSchedulingPolicy(SchedulingPolicy.QUERY_PRIORITY);
                    }
                    queue = new IndexedPriorityQueue();
                    queryQueue = new IndexedPriorityQueue();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported scheduling policy: " + policy);
                }
            }
            while (!this.eligibleSubGroups.isEmpty()) {
                InternalResourceGroup group = this.eligibleSubGroups.poll();
                queue.addOrUpdate(group, InternalResourceGroup.getSubGroupSchedulingPriority(policy, group));
            }
            this.eligibleSubGroups = queue;
            while (!this.queuedQueries.isEmpty()) {
                QueryExecution query = this.queuedQueries.poll();
                queryQueue.addOrUpdate(query, SystemSessionProperties.getQueryPriority(query.getSession()));
            }
            this.queuedQueries = queryQueue;
            this.schedulingPolicy = policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getJmxExport() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.jmxExport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJmxExport(boolean export) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.jmxExport = export;
        }
        this.jmxExportListener.accept(this, export);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalResourceGroup getOrCreateSubGroup(String name) {
        Objects.requireNonNull(name, "name is null");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            Preconditions.checkArgument((this.runningQueries.isEmpty() && this.queuedQueries.isEmpty() ? 1 : 0) != 0, (String)"Cannot add sub group to %s while queries are running", (Object[])new Object[]{this.id});
            if (this.subGroups.containsKey(name)) {
                return this.subGroups.get(name);
            }
            InternalResourceGroup subGroup = new InternalResourceGroup(Optional.of(this), name, this.jmxExportListener, this.executor);
            if (this.schedulingPolicy == SchedulingPolicy.QUERY_PRIORITY) {
                subGroup.setSchedulingPolicy(SchedulingPolicy.QUERY_PRIORITY);
            }
            this.subGroups.put(name, subGroup);
            return subGroup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(QueryExecution query) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            Preconditions.checkState((boolean)this.subGroups.isEmpty(), (String)"Cannot add queries to %s. It is not a leaf group.", (Object[])new Object[]{this.id});
            InternalResourceGroup group = this;
            boolean canQueue = true;
            boolean canRun = true;
            while (true) {
                canQueue &= group.canQueueMore();
                canRun &= group.canRunMore();
                if (!group.parent.isPresent()) break;
                group = group.parent.get();
            }
            if (!canQueue && !canRun) {
                query.fail((Throwable)new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_QUEUE_FULL, String.format("Too many queued queries for \"%s\"!", this.id)));
                return;
            }
            if (canRun) {
                this.startInBackground(query);
            } else {
                this.enqueueQuery(query);
            }
            query.addStateChangeListener(state -> {
                if (state.isDone()) {
                    this.queryFinished(query);
                }
            });
            if (query.getState().isDone()) {
                this.queryFinished(query);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueQuery(QueryExecution query) {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to enqueue a query");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.queuedQueries.addOrUpdate(query, SystemSessionProperties.getQueryPriority(query.getSession()));
            InternalResourceGroup group = this;
            while (group.parent.isPresent()) {
                ++group.parent.get().descendantQueuedQueries;
                group = group.parent.get();
            }
            this.updateEligiblility();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEligiblility() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to update eligibility");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (!this.parent.isPresent()) {
                return;
            }
            if (this.isEligibleToStartNext()) {
                this.parent.get().eligibleSubGroups.addOrUpdate(this, InternalResourceGroup.getSubGroupSchedulingPriority(this.parent.get().schedulingPolicy, this));
            } else {
                this.parent.get().eligibleSubGroups.remove(this);
            }
            this.parent.get().updateEligiblility();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startInBackground(QueryExecution query) {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to start a query");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.runningQueries.add(query);
            InternalResourceGroup group = this;
            while (group.parent.isPresent()) {
                ++group.parent.get().descendantRunningQueries;
                group.parent.get().dirtySubGroups.add(group);
                group = group.parent.get();
            }
            this.updateEligiblility();
            this.executor.execute(query::start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryFinished(QueryExecution query) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            InternalResourceGroup group;
            if (!this.runningQueries.contains(query) && !this.queuedQueries.contains(query)) {
                return;
            }
            if (query.getState() == QueryState.FINISHED || query.getQueryInfo().getErrorType() == ErrorType.USER_ERROR) {
                group = this;
                while (group != null) {
                    try {
                        group.cpuUsageMillis = Math.addExact(group.cpuUsageMillis, query.getTotalCpuTime().toMillis());
                    }
                    catch (ArithmeticException e) {
                        group.cpuUsageMillis = Long.MAX_VALUE;
                    }
                    group = group.parent.orElse(null);
                }
            }
            if (this.runningQueries.contains(query)) {
                this.runningQueries.remove(query);
                group = this;
                while (group.parent.isPresent()) {
                    --group.parent.get().descendantRunningQueries;
                    group = group.parent.get();
                }
            } else {
                this.queuedQueries.remove(query);
                group = this;
                while (group.parent.isPresent()) {
                    --group.parent.get().descendantQueuedQueries;
                    group = group.parent.get();
                }
            }
            this.updateEligiblility();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalRefreshStats() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to refresh stats");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (this.subGroups.isEmpty()) {
                this.cachedMemoryUsageBytes = 0L;
                for (QueryExecution query : this.runningQueries) {
                    this.cachedMemoryUsageBytes += query.getTotalMemoryReservation();
                }
            } else {
                Iterator<InternalResourceGroup> iterator = this.dirtySubGroups.iterator();
                while (iterator.hasNext()) {
                    InternalResourceGroup subGroup = iterator.next();
                    this.cachedMemoryUsageBytes -= subGroup.cachedMemoryUsageBytes;
                    subGroup.internalRefreshStats();
                    this.cachedMemoryUsageBytes += subGroup.cachedMemoryUsageBytes;
                    if (subGroup.isDirty()) continue;
                    iterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalGenerateCpuQuota(long elapsedSeconds) {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to generate cpu quota");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            long newQuota;
            try {
                newQuota = Math.multiplyExact(elapsedSeconds, this.cpuQuotaGenerationMillisPerSecond);
            }
            catch (ArithmeticException e) {
                newQuota = Long.MAX_VALUE;
            }
            try {
                this.cpuUsageMillis = Math.subtractExact(this.cpuUsageMillis, newQuota);
            }
            catch (ArithmeticException e) {
                this.cpuUsageMillis = 0L;
            }
            this.cpuUsageMillis = Math.max(0L, this.cpuUsageMillis);
            for (InternalResourceGroup group : this.subGroups.values()) {
                group.internalGenerateCpuQuota(elapsedSeconds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalStartNext() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to find next query");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (!this.canRunMore()) {
                return false;
            }
            QueryExecution query = this.queuedQueries.poll();
            if (query != null) {
                this.startInBackground(query);
                return true;
            }
            InternalResourceGroup subGroup = this.eligibleSubGroups.poll();
            if (subGroup == null) {
                return false;
            }
            boolean started = subGroup.internalStartNext();
            Preconditions.checkState((boolean)started, (Object)"Eligible sub group had no queries to run");
            --this.descendantQueuedQueries;
            if (subGroup.isEligibleToStartNext()) {
                this.eligibleSubGroups.addOrUpdate(subGroup, InternalResourceGroup.getSubGroupSchedulingPriority(this.schedulingPolicy, subGroup));
            }
            return true;
        }
    }

    private static int getSubGroupSchedulingPriority(SchedulingPolicy policy, InternalResourceGroup group) {
        if (policy == SchedulingPolicy.QUERY_PRIORITY) {
            return group.getHighestQueryPriority();
        }
        return group.getSchedulingWeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirty() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.runningQueries.size() + this.descendantRunningQueries > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEligibleToStartNext() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (!this.canRunMore()) {
                return false;
            }
            return !this.queuedQueries.isEmpty() || !this.eligibleSubGroups.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getHighestQueryPriority() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            Preconditions.checkState((boolean)(this.queuedQueries instanceof IndexedPriorityQueue), (Object)"Queued queries not ordered");
            if (this.queuedQueries.isEmpty()) {
                return 0;
            }
            return SystemSessionProperties.getQueryPriority(this.queuedQueries.peek().getSession());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canQueueMore() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.descendantQueuedQueries + this.queuedQueries.size() < this.maxQueuedQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canRunMore() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (this.cpuUsageMillis >= this.hardCpuLimitMillis) {
                return false;
            }
            int maxRunning = this.maxRunningQueries;
            if (this.cpuUsageMillis >= this.softCpuLimitMillis) {
                double penalty = (double)(this.cpuUsageMillis - this.softCpuLimitMillis) / (double)(this.hardCpuLimitMillis - this.softCpuLimitMillis);
                maxRunning = (int)Math.floor((double)maxRunning * (1.0 - penalty));
                maxRunning = Math.min(this.maxRunningQueries - 1, maxRunning);
                maxRunning = Math.max(1, maxRunning);
            }
            return this.runningQueries.size() + this.descendantRunningQueries < maxRunning && this.cachedMemoryUsageBytes < this.softMemoryLimitBytes;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalResourceGroup)) {
            return false;
        }
        InternalResourceGroup that = (InternalResourceGroup)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @ThreadSafe
    public static final class RootInternalResourceGroup
    extends InternalResourceGroup {
        public RootInternalResourceGroup(String name, BiConsumer<InternalResourceGroup, Boolean> jmxExportListener, Executor executor) {
            super(Optional.empty(), name, jmxExportListener, executor);
        }

        public synchronized void processQueuedQueries() {
            this.internalRefreshStats();
            while (this.internalStartNext()) {
            }
        }

        public synchronized void generateCpuQuota(long elapsedSeconds) {
            if (elapsedSeconds > 0L) {
                this.internalGenerateCpuQuota(elapsedSeconds);
            }
        }
    }
}

