/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.execution.buffer.BufferInfo;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.PageBufferInfo;
import com.facebook.presto.spi.Page;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class ClientBuffer {
    private final String taskInstanceId;
    private final OutputBuffers.OutputBufferId bufferId;
    private final AtomicLong rowsAdded = new AtomicLong();
    private final AtomicLong pagesAdded = new AtomicLong();
    private final AtomicLong bufferedBytes = new AtomicLong();
    @GuardedBy(value="this")
    private final AtomicLong currentSequenceId = new AtomicLong();
    @GuardedBy(value="this")
    private final LinkedList<PageReference> pages = new LinkedList();
    @GuardedBy(value="this")
    private boolean noMorePages;
    @GuardedBy(value="this")
    private final AtomicBoolean destroyed = new AtomicBoolean();
    @GuardedBy(value="this")
    private PendingRead pendingRead;

    public ClientBuffer(String taskInstanceId, OutputBuffers.OutputBufferId bufferId) {
        this.taskInstanceId = Objects.requireNonNull(taskInstanceId, "taskInstanceId is null");
        this.bufferId = Objects.requireNonNull(bufferId, "bufferId is null");
    }

    public BufferInfo getInfo() {
        boolean destroyed = this.destroyed.get();
        long sequenceId = this.currentSequenceId.get();
        int bufferedPages = destroyed ? 0 : Math.max(Ints.checkedCast((long)(this.pagesAdded.get() - sequenceId)), 0);
        PageBufferInfo pageBufferInfo = new PageBufferInfo(this.bufferId.getId(), bufferedPages, this.bufferedBytes.get(), this.rowsAdded.get(), this.pagesAdded.get());
        return new BufferInfo(this.bufferId, destroyed, bufferedPages, sequenceId, pageBufferInfo);
    }

    public boolean isDestroyed() {
        boolean destroyed = this.destroyed.get();
        return destroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        PendingRead pendingRead;
        ImmutableList removedPages;
        ClientBuffer clientBuffer = this;
        synchronized (clientBuffer) {
            removedPages = ImmutableList.copyOf(this.pages);
            this.pages.clear();
            this.bufferedBytes.getAndSet(0L);
            this.noMorePages = true;
            this.destroyed.set(true);
            pendingRead = this.pendingRead;
            this.pendingRead = null;
        }
        removedPages.forEach(PageReference::dereferencePage);
        if (pendingRead != null) {
            pendingRead.completeResultFutureWithEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueuePages(Collection<PageReference> pages) {
        PendingRead pendingRead;
        ClientBuffer clientBuffer = this;
        synchronized (clientBuffer) {
            if (this.noMorePages) {
                return;
            }
            pages.stream().forEach(PageReference::addReference);
            this.pages.addAll(pages);
            long rowCount = pages.stream().mapToLong(PageReference::getPositionCount).sum();
            this.rowsAdded.addAndGet(rowCount);
            this.pagesAdded.addAndGet(pages.size());
            long bytesAdded = pages.stream().mapToLong(PageReference::getRetainedSizeInBytes).sum();
            this.bufferedBytes.addAndGet(bytesAdded);
            pendingRead = this.pendingRead;
            this.pendingRead = null;
        }
        if (pendingRead != null) {
            this.processRead(pendingRead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public CompletableFuture<BufferResult> getPages(long sequenceId, DataSize maxSize) {
        CompletableFuture<BufferResult> completableFuture;
        Preconditions.checkArgument((sequenceId >= 0L ? 1 : 0) != 0, (Object)"Invalid sequence id");
        this.acknowledgePages(sequenceId);
        PendingRead oldPendingRead = null;
        try {
            ClientBuffer clientBuffer = this;
            // MONITORENTER : clientBuffer
            oldPendingRead = this.pendingRead;
            this.pendingRead = null;
            if (!this.pages.isEmpty() || this.noMorePages || sequenceId != this.currentSequenceId.get()) {
                CompletableFuture<BufferResult> completableFuture2 = CompletableFuture.completedFuture(this.processRead(sequenceId, maxSize));
                // MONITOREXIT : clientBuffer
                if (oldPendingRead == null) return completableFuture2;
                oldPendingRead.completeResultFutureWithEmpty();
                return completableFuture2;
            }
            this.pendingRead = new PendingRead(this.taskInstanceId, sequenceId, maxSize);
            completableFuture = this.pendingRead.getResultFuture();
        }
        catch (Throwable throwable) {
            if (oldPendingRead == null) throw throwable;
            oldPendingRead.completeResultFutureWithEmpty();
            throw throwable;
        }
        if (oldPendingRead == null) return completableFuture;
        oldPendingRead.completeResultFutureWithEmpty();
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNoMorePages() {
        PendingRead pendingRead;
        ClientBuffer clientBuffer = this;
        synchronized (clientBuffer) {
            if (this.noMorePages) {
                return;
            }
            this.noMorePages = true;
            pendingRead = this.pendingRead;
            this.pendingRead = null;
        }
        if (pendingRead != null) {
            this.processRead(pendingRead);
        }
    }

    private void processRead(PendingRead pendingRead) {
        if (pendingRead.getResultFuture().isDone()) {
            return;
        }
        BufferResult bufferResult = this.processRead(pendingRead.getSequenceId(), pendingRead.getMaxSize());
        pendingRead.getResultFuture().complete(bufferResult);
    }

    private synchronized BufferResult processRead(long sequenceId, DataSize maxSize) {
        if (sequenceId < this.currentSequenceId.get()) {
            return BufferResult.emptyResults(this.taskInstanceId, sequenceId, false);
        }
        if (this.pages.isEmpty() && this.noMorePages) {
            return BufferResult.emptyResults(this.taskInstanceId, this.currentSequenceId.get(), true);
        }
        Verify.verify((sequenceId == this.currentSequenceId.get() ? 1 : 0) != 0, (String)"Invalid sequence id", (Object[])new Object[0]);
        long maxBytes = maxSize.toBytes();
        ArrayList<Page> result = new ArrayList<Page>();
        long bytes = 0L;
        for (PageReference page : this.pages) {
            if (!result.isEmpty() && (bytes += page.getRetainedSizeInBytes()) > maxBytes) break;
            result.add(page.getPage());
        }
        return new BufferResult(this.taskInstanceId, sequenceId, sequenceId + (long)result.size(), false, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acknowledgePages(long sequenceId) {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not acknowledge pages while holding a lock on this");
        ArrayList<PageReference> removedPages = new ArrayList<PageReference>();
        ClientBuffer clientBuffer = this;
        synchronized (clientBuffer) {
            if (this.destroyed.get()) {
                return;
            }
            long oldCurrentSequenceId = this.currentSequenceId.get();
            if (sequenceId < oldCurrentSequenceId) {
                return;
            }
            int pagesToRemove = Ints.checkedCast((long)(sequenceId - oldCurrentSequenceId));
            Preconditions.checkArgument((pagesToRemove <= this.pages.size() ? 1 : 0) != 0, (Object)"Invalid sequence id");
            long bytesRemoved = 0L;
            for (int i = 0; i < pagesToRemove; ++i) {
                PageReference removedPage = this.pages.removeFirst();
                removedPages.add(removedPage);
                bytesRemoved += removedPage.getRetainedSizeInBytes();
            }
            Verify.verify((boolean)this.currentSequenceId.compareAndSet(oldCurrentSequenceId, oldCurrentSequenceId + (long)pagesToRemove));
            Verify.verify((this.bufferedBytes.addAndGet(-bytesRemoved) >= 0L ? 1 : 0) != 0);
        }
        removedPages.forEach(PageReference::dereferencePage);
    }

    public String toString() {
        long sequenceId = this.currentSequenceId.get();
        boolean destroyed = this.destroyed.get();
        return MoreObjects.toStringHelper((Object)this).add("bufferId", (Object)this.bufferId).add("sequenceId", sequenceId).add("destroyed", destroyed).toString();
    }

    @ThreadSafe
    static class PageReference {
        private final Page page;
        private final AtomicInteger referenceCount;
        private final Runnable onDereference;

        public PageReference(Page page, int referenceCount, Runnable onDereference) {
            this.page = Objects.requireNonNull(page, "page is null");
            Preconditions.checkArgument((referenceCount > 0 ? 1 : 0) != 0, (Object)"referenceCount must be at least 1");
            this.referenceCount = new AtomicInteger(referenceCount);
            this.onDereference = Objects.requireNonNull(onDereference, "onDereference is null");
        }

        public void addReference() {
            int oldReferences = this.referenceCount.getAndIncrement();
            Preconditions.checkState((oldReferences > 0 ? 1 : 0) != 0, (Object)"Page has already been dereferenced");
        }

        public Page getPage() {
            return this.page;
        }

        public int getPositionCount() {
            return this.page.getPositionCount();
        }

        public long getRetainedSizeInBytes() {
            return this.page.getRetainedSizeInBytes();
        }

        public void dereferencePage() {
            int remainingReferences = this.referenceCount.decrementAndGet();
            Preconditions.checkState((remainingReferences >= 0 ? 1 : 0) != 0, (Object)"Page reference count is negative");
            if (remainingReferences == 0) {
                this.onDereference.run();
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("referenceCount", (Object)this.referenceCount).toString();
        }
    }

    @Immutable
    private static class PendingRead {
        private final String taskInstanceId;
        private final long sequenceId;
        private final DataSize maxSize;
        private final CompletableFuture<BufferResult> resultFuture = new CompletableFuture();

        private PendingRead(String taskInstanceId, long sequenceId, DataSize maxSize) {
            this.taskInstanceId = Objects.requireNonNull(taskInstanceId, "taskInstanceId is null");
            this.sequenceId = sequenceId;
            this.maxSize = maxSize;
        }

        public long getSequenceId() {
            return this.sequenceId;
        }

        public DataSize getMaxSize() {
            return this.maxSize;
        }

        public CompletableFuture<BufferResult> getResultFuture() {
            return this.resultFuture;
        }

        public void completeResultFutureWithEmpty() {
            this.resultFuture.complete(BufferResult.emptyResults(this.taskInstanceId, this.sequenceId, false));
        }
    }
}

