/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.execution.buffer.BufferInfo;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.OutputBufferInfo;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@Immutable
public class TaskInfo {
    private final TaskStatus taskStatus;
    private final DateTime lastHeartbeat;
    private final OutputBufferInfo outputBuffers;
    private final Set<PlanNodeId> noMoreSplits;
    private final TaskStats stats;
    private final boolean needsPlan;
    private final boolean complete;

    @JsonCreator
    public TaskInfo(@JsonProperty(value="taskStatus") TaskStatus taskStatus, @JsonProperty(value="lastHeartbeat") DateTime lastHeartbeat, @JsonProperty(value="outputBuffers") OutputBufferInfo outputBuffers, @JsonProperty(value="noMoreSplits") Set<PlanNodeId> noMoreSplits, @JsonProperty(value="stats") TaskStats stats, @JsonProperty(value="needsPlan") boolean needsPlan, @JsonProperty(value="complete") boolean complete) {
        this.taskStatus = Objects.requireNonNull(taskStatus, "taskStatus is null");
        this.lastHeartbeat = Objects.requireNonNull(lastHeartbeat, "lastHeartbeat is null");
        this.outputBuffers = Objects.requireNonNull(outputBuffers, "outputBuffers is null");
        this.noMoreSplits = Objects.requireNonNull(noMoreSplits, "noMoreSplits is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.needsPlan = needsPlan;
        this.complete = complete;
    }

    @JsonProperty
    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    @JsonProperty
    public DateTime getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    @JsonProperty
    public OutputBufferInfo getOutputBuffers() {
        return this.outputBuffers;
    }

    @JsonProperty
    public Set<PlanNodeId> getNoMoreSplits() {
        return this.noMoreSplits;
    }

    @JsonProperty
    public TaskStats getStats() {
        return this.stats;
    }

    @JsonProperty
    public boolean isNeedsPlan() {
        return this.needsPlan;
    }

    @JsonProperty
    public boolean isComplete() {
        return this.complete;
    }

    public TaskInfo summarize() {
        return new TaskInfo(this.taskStatus, this.lastHeartbeat, this.outputBuffers, this.noMoreSplits, this.stats.summarize(), this.needsPlan, this.complete);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskStatus.getTaskId()).add("state", (Object)this.taskStatus.getState()).toString();
    }

    public static TaskInfo createInitialTask(TaskId taskId, URI location, List<BufferInfo> bufferStates, TaskStats taskStats) {
        return new TaskInfo(TaskStatus.initialTaskStatus(taskId, location), DateTime.now(), new OutputBufferInfo("UNINITIALIZED", BufferState.OPEN, true, true, 0L, 0L, 0L, 0L, bufferStates), (Set<PlanNodeId>)ImmutableSet.of(), taskStats, true, false);
    }

    public TaskInfo withTaskStatus(TaskStatus newTaskStatus) {
        return new TaskInfo(newTaskStatus, this.lastHeartbeat, this.outputBuffers, this.noMoreSplits, this.stats, this.needsPlan, this.complete);
    }
}

