/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.ForQueryExecution;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class DataDefinitionExecution<T extends Statement>
implements QueryExecution {
    private final DataDefinitionTask<T> task;
    private final T statement;
    private final TransactionManager transactionManager;
    private final Metadata metadata;
    private final AccessControl accessControl;
    private final QueryStateMachine stateMachine;
    private final List<Expression> parameters;

    private DataDefinitionExecution(DataDefinitionTask<T> task, T statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        this.task = Objects.requireNonNull(task, "task is null");
        this.statement = (Statement)Objects.requireNonNull(statement, "statement is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
        this.parameters = parameters;
    }

    @Override
    public VersionedMemoryPoolId getMemoryPool() {
        return this.stateMachine.getMemoryPool();
    }

    @Override
    public void setMemoryPool(VersionedMemoryPoolId poolId) {
        this.stateMachine.setMemoryPool(poolId);
    }

    @Override
    public long getTotalMemoryReservation() {
        return 0L;
    }

    @Override
    public Duration getTotalCpuTime() {
        return new Duration(0.0, TimeUnit.SECONDS);
    }

    @Override
    public Session getSession() {
        return this.stateMachine.getSession();
    }

    @Override
    public void start() {
        block3: {
            try {
                if (!this.stateMachine.transitionToRunning()) {
                    return;
                }
                CompletableFuture<?> future = this.task.execute(this.statement, this.transactionManager, this.metadata, this.accessControl, this.stateMachine, this.parameters);
                future.whenComplete((o, throwable) -> {
                    if (throwable == null) {
                        this.stateMachine.transitionToFinishing();
                    } else {
                        this.fail((Throwable)throwable);
                    }
                });
            }
            catch (Throwable e) {
                this.fail(e);
                if (e instanceof RuntimeException) break block3;
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    @Override
    public Duration waitForStateChange(QueryState currentState, Duration maxWait) throws InterruptedException {
        return this.stateMachine.waitForStateChange(currentState, maxWait);
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.stateMachine.addStateChangeListener(stateChangeListener);
    }

    @Override
    public void addFinalQueryInfoListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        this.stateMachine.addQueryInfoStateChangeListener(stateChangeListener);
    }

    @Override
    public void fail(Throwable cause) {
        this.stateMachine.transitionToFailed(cause);
    }

    @Override
    public void cancelQuery() {
        this.stateMachine.transitionToCanceled();
    }

    @Override
    public void cancelStage(StageId stageId) {
    }

    @Override
    public void recordHeartbeat() {
        this.stateMachine.recordHeartbeat();
    }

    @Override
    public void pruneInfo() {
    }

    @Override
    public QueryId getQueryId() {
        return this.stateMachine.getQueryId();
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.stateMachine.getQueryInfoWithoutDetails();
    }

    @Override
    public QueryState getState() {
        return this.stateMachine.getQueryState();
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    /* synthetic */ DataDefinitionExecution(DataDefinitionTask x0, Statement x1, TransactionManager x2, Metadata x3, AccessControl x4, QueryStateMachine x5, List x6, 1 x7) {
        this(x0, x1, x2, x3, x4, x5, x6);
    }

    public static class DataDefinitionExecutionFactory
    implements QueryExecution.QueryExecutionFactory<DataDefinitionExecution<?>> {
        private final LocationFactory locationFactory;
        private final TransactionManager transactionManager;
        private final Metadata metadata;
        private final AccessControl accessControl;
        private final ExecutorService executor;
        private final Map<Class<? extends Statement>, DataDefinitionTask<?>> tasks;

        @Inject
        public DataDefinitionExecutionFactory(LocationFactory locationFactory, TransactionManager transactionManager, MetadataManager metadata, AccessControl accessControl, @ForQueryExecution ExecutorService executor, Map<Class<? extends Statement>, DataDefinitionTask<?>> tasks) {
            this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
            this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
            this.executor = Objects.requireNonNull(executor, "executor is null");
            this.tasks = Objects.requireNonNull(tasks, "tasks is null");
        }

        public String explain(Statement statement, List<Expression> parameters) {
            DataDefinitionTask<Statement> task = this.getTask(statement);
            Preconditions.checkArgument((task != null ? 1 : 0) != 0, (String)"no task for statement: %s", (Object[])new Object[]{statement.getClass().getSimpleName()});
            return task.explain(statement, parameters);
        }

        @Override
        public DataDefinitionExecution<?> createQueryExecution(QueryId queryId, String query, Session session, Statement statement, List<Expression> parameters) {
            URI self = this.locationFactory.createQueryLocation(queryId);
            DataDefinitionTask<Statement> task = this.getTask(statement);
            Preconditions.checkArgument((task != null ? 1 : 0) != 0, (String)"no task for statement: %s", (Object[])new Object[]{statement.getClass().getSimpleName()});
            QueryStateMachine stateMachine = QueryStateMachine.begin(queryId, query, session, self, task.isTransactionControl(), this.transactionManager, this.accessControl, this.executor);
            stateMachine.setUpdateType(task.getName());
            return new DataDefinitionExecution(task, statement, this.transactionManager, this.metadata, this.accessControl, stateMachine, parameters, null);
        }

        private <T extends Statement> DataDefinitionTask<T> getTask(T statement) {
            return this.tasks.get(statement.getClass());
        }
    }
}

