/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.BlockSerdeUtil;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.google.common.collect.AbstractIterator;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public final class PagesSerde {
    private PagesSerde() {
    }

    public static long writePages(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Page ... pages) {
        return PagesSerde.writePages(blockEncodingSerde, sliceOutput, Arrays.asList(pages).iterator());
    }

    public static long writePages(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Iterable<Page> pages) {
        return PagesSerde.writePages(blockEncodingSerde, sliceOutput, pages.iterator());
    }

    public static long writePages(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Iterator<Page> pages) {
        long size = 0L;
        PagesWriter pagesWriter = new PagesWriter(blockEncodingSerde, sliceOutput);
        while (pages.hasNext()) {
            Page page = pages.next();
            pagesWriter.append(page);
            size += page.getSizeInBytes();
        }
        return size;
    }

    public static Iterator<Page> readPages(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        return new PagesReader(blockEncodingSerde, sliceInput);
    }

    private static class PagesReader
    extends AbstractIterator<Page> {
        private final BlockEncodingSerde serde;
        private final SliceInput input;

        public PagesReader(BlockEncodingSerde serde, SliceInput input) {
            this.serde = Objects.requireNonNull(serde, "serde is null");
            this.input = Objects.requireNonNull(input, "input is null");
        }

        protected Page computeNext() {
            if (!this.input.isReadable()) {
                return (Page)this.endOfData();
            }
            int positions = this.input.readInt();
            int numberOfBlocks = this.input.readInt();
            Block[] blocks = new Block[numberOfBlocks];
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i] = BlockSerdeUtil.readBlock(this.serde, this.input);
            }
            Page page = new Page(positions, blocks);
            return page;
        }
    }

    private static class PagesWriter {
        private final BlockEncodingSerde serde;
        private final SliceOutput output;

        private PagesWriter(BlockEncodingSerde serde, SliceOutput output) {
            this.serde = Objects.requireNonNull(serde, "serde is null");
            this.output = Objects.requireNonNull(output, "output is null");
        }

        public PagesWriter append(Page page) {
            Objects.requireNonNull(page, "page is null");
            Block[] blocks = page.getBlocks();
            this.output.writeInt(page.getPositionCount());
            this.output.writeInt(blocks.length);
            for (int i = 0; i < blocks.length; ++i) {
                BlockSerdeUtil.writeBlock(this.serde, this.output, blocks[i]);
            }
            return this;
        }
    }
}

