/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.ParametricType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeParameter;
import java.util.List;

public class CharParametricType
implements ParametricType {
    public static final CharParametricType CHAR = new CharParametricType();

    public String getName() {
        return "char";
    }

    public Type createType(List<TypeParameter> parameters) {
        if (parameters.isEmpty()) {
            return CharType.createCharType((long)1L);
        }
        if (parameters.size() != 1) {
            throw new IllegalArgumentException("Expected at most one parameter for CHAR");
        }
        TypeParameter parameter = parameters.get(0);
        if (!parameter.isLongLiteral()) {
            throw new IllegalArgumentException("CHAR length must be a number");
        }
        return CharType.createCharType((long)parameter.getLongLiteral());
    }
}

