/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.transaction;

import com.facebook.presto.security.LegacyConnectorAccessControl;
import com.facebook.presto.spi.ConnectorIndexResolver;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorIndexProvider;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.transaction.LegacyConnectorIndexProvider;
import com.facebook.presto.transaction.LegacyConnectorMetadata;
import com.facebook.presto.transaction.LegacyConnectorPageSinkProvider;
import com.facebook.presto.transaction.LegacyConnectorPageSourceProvider;
import com.facebook.presto.transaction.LegacyConnectorRecordSetProvider;
import com.facebook.presto.transaction.LegacyConnectorRecordSinkProvider;
import com.facebook.presto.transaction.LegacyConnectorSplitManager;
import com.facebook.presto.transaction.LegacyTransactionHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LegacyTransactionConnector
implements Connector {
    private final com.facebook.presto.spi.Connector connector;
    private final ConcurrentMap<ConnectorTransactionHandle, LegacyConnectorMetadata> metadatas = new ConcurrentHashMap<ConnectorTransactionHandle, LegacyConnectorMetadata>();

    public LegacyTransactionConnector(com.facebook.presto.spi.Connector connector) {
        this.connector = Objects.requireNonNull(connector, "connector is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)this.connector.getIsolationLevel(), (IsolationLevel)isolationLevel);
        return LegacyTransactionHandle.create();
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadatas.computeIfAbsent(transactionHandle, handle -> new LegacyConnectorMetadata(this.connector.getMetadata(), Optional.ofNullable(this.connector.getIndexResolver())));
    }

    public ConnectorSplitManager getSplitManager() {
        return new LegacyConnectorSplitManager(this.connector.getSplitManager());
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return new LegacyConnectorPageSourceProvider(this.connector.getPageSourceProvider());
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return new LegacyConnectorRecordSetProvider(this.connector.getRecordSetProvider());
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return new LegacyConnectorPageSinkProvider(this.connector.getPageSinkProvider());
    }

    public ConnectorRecordSinkProvider getRecordSinkProvider() {
        return new LegacyConnectorRecordSinkProvider(this.connector.getRecordSinkProvider());
    }

    public ConnectorIndexProvider getIndexProvider() {
        ConnectorIndexResolver indexResolver = this.connector.getIndexResolver();
        if (indexResolver == null) {
            throw new UnsupportedOperationException();
        }
        return new LegacyConnectorIndexProvider(indexResolver);
    }

    public Set<SystemTable> getSystemTables() {
        return this.connector.getSystemTables();
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.connector.getSessionProperties();
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.connector.getTableProperties();
    }

    public ConnectorAccessControl getAccessControl() {
        return new LegacyConnectorAccessControl(this.connector.getAccessControl());
    }

    public void commit(ConnectorTransactionHandle transactionHandle) {
        this.metadatas.remove(transactionHandle);
    }

    public void rollback(ConnectorTransactionHandle transactionHandle) {
        LegacyConnectorMetadata metadata = (LegacyConnectorMetadata)this.metadatas.remove(transactionHandle);
        if (metadata != null) {
            metadata.tryRollback();
        }
    }

    public boolean isSingleStatementWritesOnly() {
        return true;
    }

    public void shutdown() {
        this.connector.shutdown();
    }
}

