/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.Session;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.util.Threads;
import io.airlift.units.DataSize;
import java.util.concurrent.Executor;

public final class TestingTaskContext {
    private TestingTaskContext() {
    }

    public static TaskContext createTaskContext(Executor executor, Session session) {
        return TestingTaskContext.createTaskContext(Threads.checkNotSameThreadExecutor(executor, "executor is null"), session, new DataSize(256.0, DataSize.Unit.MEGABYTE));
    }

    public static TaskContext createTaskContext(Executor executor, Session session, DataSize maxMemory) {
        return TestingTaskContext.createTaskContext(executor, session, maxMemory, new DataSize(1.0, DataSize.Unit.MEGABYTE));
    }

    public static TaskContext createTaskContext(Executor executor, Session session, DataSize maxMemory, DataSize preallocated) {
        MemoryPool memoryPool = new MemoryPool(new MemoryPoolId("test"), new DataSize(1.0, DataSize.Unit.GIGABYTE));
        MemoryPool systemMemoryPool = new MemoryPool(new MemoryPoolId("testSystem"), new DataSize(1.0, DataSize.Unit.GIGABYTE));
        QueryContext queryContext = new QueryContext(new QueryId("test_query"), maxMemory, memoryPool, systemMemoryPool, executor);
        return TestingTaskContext.createTaskContext(queryContext, executor, session, preallocated);
    }

    public static TaskContext createTaskContext(QueryContext queryContext, Executor executor, Session session, DataSize preallocated) {
        return queryContext.addTaskContext(new TaskStateMachine(new TaskId("query", 0, 0), Threads.checkNotSameThreadExecutor(executor, "executor is null")), session, preallocated, true, true);
    }
}

