/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import java.util.Objects;

public final class ConstantExpression
extends RowExpression {
    private final Object value;
    private final Type type;

    public ConstantExpression(Object value, Type type) {
        Objects.requireNonNull(type, "type is null");
        this.value = value;
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.type);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantExpression other = (ConstantExpression)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.type, other.type);
    }

    @Override
    public <C, R> R accept(RowExpressionVisitor<C, R> visitor, C context) {
        return visitor.visitConstant(this, context);
    }
}

