/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.optimizations.IndexJoinOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExceptNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.IntersectNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.MetadataDeleteNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SetOperationNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.planner.sanity.PlanSanityChecker;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ValidateDependenciesChecker
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode plan, Session session, Metadata metadata, SqlParser sqlParser, Map<Symbol, Type> types) {
        ValidateDependenciesChecker.validate(plan);
    }

    public static void validate(PlanNode plan) {
        plan.accept(new Visitor(), ImmutableSet.of());
    }

    private static void checkDependencies(Collection<Symbol> inputs, Collection<Symbol> required, String message, Object ... parameters) {
        Preconditions.checkArgument((boolean)ImmutableSet.copyOf(inputs).containsAll(required), (String)message, (Object[])parameters);
    }

    private static class Visitor
    extends PlanVisitor<Set<Symbol>, Void> {
        private final Map<PlanNodeId, PlanNode> nodesById = new HashMap<PlanNodeId, PlanNode>();

        private Visitor() {
        }

        @Override
        protected Void visitPlan(PlanNode node, Set<Symbol> boundSymbols) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        @Override
        public Void visitExplainAnalyze(ExplainAnalyzeNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            this.verifyUniqueId(node);
            return null;
        }

        @Override
        public Void visitAggregation(AggregationNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            this.verifyUniqueId(node);
            ImmutableSet<Symbol> inputs = this.createInputs(source, boundSymbols);
            ValidateDependenciesChecker.checkDependencies(inputs, node.getGroupingKeys(), "Invalid node. Grouping key symbols (%s) not in source plan output (%s)", new Object[]{node.getGroupingKeys(), node.getSource().getOutputSymbols()});
            if (node.getSampleWeight().isPresent()) {
                Preconditions.checkArgument((boolean)inputs.contains(node.getSampleWeight().get()), (String)"Invalid node. Sample weight symbol (%s) is not in source plan output (%s)", (Object[])new Object[]{node.getSampleWeight().get(), node.getSource().getOutputSymbols()});
            }
            for (FunctionCall call : node.getAggregations().values()) {
                Set<Symbol> dependencies = DependencyExtractor.extractUnique((Expression)call);
                ValidateDependenciesChecker.checkDependencies(inputs, dependencies, "Invalid node. Aggregation dependencies (%s) not in source plan output (%s)", new Object[]{dependencies, node.getSource().getOutputSymbols()});
            }
            return null;
        }

        @Override
        public Void visitGroupId(GroupIdNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            this.verifyUniqueId(node);
            ValidateDependenciesChecker.checkDependencies(source.getOutputSymbols(), node.getInputSymbols(), "Invalid node. Grouping symbols (%s) not in source plan output (%s)", new Object[]{node.getInputSymbols(), source.getOutputSymbols()});
            return null;
        }

        @Override
        public Void visitMarkDistinct(MarkDistinctNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            this.verifyUniqueId(node);
            ValidateDependenciesChecker.checkDependencies(source.getOutputSymbols(), node.getDistinctSymbols(), "Invalid node. Mark distinct symbols (%s) not in source plan output (%s)", new Object[]{node.getDistinctSymbols(), source.getOutputSymbols()});
            return null;
        }

        @Override
        public Void visitWindow(WindowNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            this.verifyUniqueId(node);
            ImmutableSet<Symbol> inputs = this.createInputs(source, boundSymbols);
            ValidateDependenciesChecker.checkDependencies(inputs, node.getPartitionBy(), "Invalid node. Partition by symbols (%s) not in source plan output (%s)", new Object[]{node.getPartitionBy(), node.getSource().getOutputSymbols()});
            ValidateDependenciesChecker.checkDependencies(inputs, node.getOrderBy(), "Invalid node. Order by symbols (%s) not in source plan output (%s)", new Object[]{node.getOrderBy(), node.getSource().getOutputSymbols()});
            ImmutableList.Builder bounds = ImmutableList.builder();
            for (WindowNode.Frame frame : node.getFrames()) {
                if (frame.getStartValue().isPresent()) {
                    bounds.add((Object)frame.getStartValue().get());
                }
                if (!frame.getEndValue().isPresent()) continue;
                bounds.add((Object)frame.getEndValue().get());
            }
            ValidateDependenciesChecker.checkDependencies(inputs, (Collection)bounds.build(), "Invalid node. Frame bounds (%s) not in source plan output (%s)", new Object[]{bounds.build(), node.getSource().getOutputSymbols()});
            for (WindowNode.Function function : node.getWindowFunctions().values()) {
                Set<Symbol> dependencies = DependencyExtractor.extractUnique((Expression)function.getFunctionCall());
                ValidateDependenciesChecker.checkDependencies(inputs, dependencies, "Invalid node. Window function dependencies (%s) not in source plan output (%s)", new Object[]{dependencies, node.getSource().getOutputSymbols()});
            }
            return null;
        }

        @Override
        public Void visitTopNRowNumber(TopNRowNumberNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            this.verifyUniqueId(node);
            ImmutableSet<Symbol> inputs = this.createInputs(source, boundSymbols);
            ValidateDependenciesChecker.checkDependencies(inputs, node.getPartitionBy(), "Invalid node. Partition by symbols (%s) not in source plan output (%s)", new Object[]{node.getPartitionBy(), node.getSource().getOutputSymbols()});
            ValidateDependenciesChecker.checkDependencies(inputs, node.getOrderBy(), "Invalid node. Order by symbols (%s) not in source plan output (%s)", new Object[]{node.getOrderBy(), node.getSource().getOutputSymbols()});
            return null;
        }

        @Override
        public Void visitRowNumber(RowNumberNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            this.verifyUniqueId(node);
            ValidateDependenciesChecker.checkDependencies(source.getOutputSymbols(), node.getPartitionBy(), "Invalid node. Partition by symbols (%s) not in source plan output (%s)", new Object[]{node.getPartitionBy(), node.getSource().getOutputSymbols()});
            return null;
        }

        @Override
        public Void visitFilter(FilterNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            this.verifyUniqueId(node);
            ImmutableSet<Symbol> inputs = this.createInputs(source, boundSymbols);
            ValidateDependenciesChecker.checkDependencies(inputs, node.getOutputSymbols(), "Invalid node. Output symbols (%s) not in source plan output (%s)", new Object[]{node.getOutputSymbols(), node.getSource().getOutputSymbols()});
            Set<Symbol> dependencies = DependencyExtractor.extractUnique(node.getPredicate());
            ValidateDependenciesChecker.checkDependencies(inputs, dependencies, "Invalid node. Predicate dependencies (%s) not in source plan output (%s)", new Object[]{dependencies, node.getSource().getOutputSymbols()});
            return null;
        }

        @Override
        public Void visitSample(SampleNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            this.verifyUniqueId(node);
            return null;
        }

        @Override
        public Void visitProject(ProjectNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            this.verifyUniqueId(node);
            ImmutableSet<Symbol> inputs = this.createInputs(source, boundSymbols);
            for (Expression expression : node.getAssignments().values()) {
                Set<Symbol> dependencies = DependencyExtractor.extractUnique(expression);
                ValidateDependenciesChecker.checkDependencies(inputs, dependencies, "Invalid node. Expression dependencies (%s) not in source plan output (%s)", new Object[]{dependencies, inputs});
            }
            return null;
        }

        @Override
        public Void visitTopN(TopNNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            this.verifyUniqueId(node);
            ImmutableSet<Symbol> inputs = this.createInputs(source, boundSymbols);
            ValidateDependenciesChecker.checkDependencies(inputs, node.getOutputSymbols(), "Invalid node. Output symbols (%s) not in source plan output (%s)", new Object[]{node.getOutputSymbols(), node.getSource().getOutputSymbols()});
            ValidateDependenciesChecker.checkDependencies(inputs, node.getOrderBy(), "Invalid node. Order by dependencies (%s) not in source plan output (%s)", new Object[]{node.getOrderBy(), node.getSource().getOutputSymbols()});
            return null;
        }

        @Override
        public Void visitSort(SortNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            this.verifyUniqueId(node);
            ImmutableSet<Symbol> inputs = this.createInputs(source, boundSymbols);
            ValidateDependenciesChecker.checkDependencies(inputs, node.getOutputSymbols(), "Invalid node. Output symbols (%s) not in source plan output (%s)", new Object[]{node.getOutputSymbols(), node.getSource().getOutputSymbols()});
            ValidateDependenciesChecker.checkDependencies(inputs, node.getOrderBy(), "Invalid node. Order by dependencies (%s) not in source plan output (%s)", new Object[]{node.getOrderBy(), node.getSource().getOutputSymbols()});
            return null;
        }

        @Override
        public Void visitOutput(OutputNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            this.verifyUniqueId(node);
            ValidateDependenciesChecker.checkDependencies(source.getOutputSymbols(), node.getOutputSymbols(), "Invalid node. Output column dependencies (%s) not in source plan output (%s)", new Object[]{node.getOutputSymbols(), source.getOutputSymbols()});
            return null;
        }

        @Override
        public Void visitLimit(LimitNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            this.verifyUniqueId(node);
            return null;
        }

        @Override
        public Void visitDistinctLimit(DistinctLimitNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            this.verifyUniqueId(node);
            return null;
        }

        @Override
        public Void visitJoin(JoinNode node, Set<Symbol> boundSymbols) {
            node.getLeft().accept(this, boundSymbols);
            node.getRight().accept(this, boundSymbols);
            this.verifyUniqueId(node);
            ImmutableSet<Symbol> leftInputs = this.createInputs(node.getLeft(), boundSymbols);
            ImmutableSet<Symbol> rightInputs = this.createInputs(node.getRight(), boundSymbols);
            for (JoinNode.EquiJoinClause clause : node.getCriteria()) {
                Preconditions.checkArgument((boolean)leftInputs.contains(clause.getLeft()), (String)"Symbol from join clause (%s) not in left source (%s)", (Object[])new Object[]{clause.getLeft(), node.getLeft().getOutputSymbols()});
                Preconditions.checkArgument((boolean)rightInputs.contains(clause.getRight()), (String)"Symbol from join clause (%s) not in right source (%s)", (Object[])new Object[]{clause.getRight(), node.getRight().getOutputSymbols()});
            }
            node.getFilter().ifPresent(predicate -> {
                Set<Symbol> predicateSymbols = DependencyExtractor.extractUnique(predicate);
                ImmutableSet allInputs = ImmutableSet.builder().addAll((Iterable)leftInputs).addAll((Iterable)rightInputs).build();
                Preconditions.checkArgument((boolean)allInputs.containsAll(predicateSymbols), (String)"Symbol from filter (%s) not in sources (%s)", (Object[])new Object[]{allInputs, predicateSymbols});
            });
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Set<Symbol> boundSymbols) {
            node.getSource().accept(this, boundSymbols);
            node.getFilteringSource().accept(this, boundSymbols);
            this.verifyUniqueId(node);
            Preconditions.checkArgument((boolean)node.getSource().getOutputSymbols().contains(node.getSourceJoinSymbol()), (String)"Symbol from semi join clause (%s) not in source (%s)", (Object[])new Object[]{node.getSourceJoinSymbol(), node.getSource().getOutputSymbols()});
            Preconditions.checkArgument((boolean)node.getFilteringSource().getOutputSymbols().contains(node.getFilteringSourceJoinSymbol()), (String)"Symbol from semi join clause (%s) not in filtering source (%s)", (Object[])new Object[]{node.getSourceJoinSymbol(), node.getFilteringSource().getOutputSymbols()});
            ImmutableSet<Symbol> outputs = this.createInputs(node, boundSymbols);
            Preconditions.checkArgument((boolean)outputs.containsAll(node.getSource().getOutputSymbols()), (String)"Semi join output symbols (%s) must contain all of the source symbols (%s)", (Object[])new Object[]{node.getOutputSymbols(), node.getSource().getOutputSymbols()});
            Preconditions.checkArgument((boolean)outputs.contains(node.getSemiJoinOutput()), (String)"Semi join output symbols (%s) must contain join result (%s)", (Object[])new Object[]{node.getOutputSymbols(), node.getSemiJoinOutput()});
            return null;
        }

        @Override
        public Void visitIndexJoin(IndexJoinNode node, Set<Symbol> boundSymbols) {
            node.getProbeSource().accept(this, boundSymbols);
            node.getIndexSource().accept(this, boundSymbols);
            this.verifyUniqueId(node);
            ImmutableSet<Symbol> probeInputs = this.createInputs(node.getProbeSource(), boundSymbols);
            ImmutableSet<Symbol> indexSourceInputs = this.createInputs(node.getIndexSource(), boundSymbols);
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                Preconditions.checkArgument((boolean)probeInputs.contains(clause.getProbe()), (String)"Probe symbol from index join clause (%s) not in probe source (%s)", (Object[])new Object[]{clause.getProbe(), node.getProbeSource().getOutputSymbols()});
                Preconditions.checkArgument((boolean)indexSourceInputs.contains(clause.getIndex()), (String)"Index symbol from index join clause (%s) not in index source (%s)", (Object[])new Object[]{clause.getIndex(), node.getIndexSource().getOutputSymbols()});
            }
            Set lookupSymbols = (Set)node.getCriteria().stream().map(IndexJoinNode.EquiJoinClause::getIndex).collect(ImmutableCollectors.toImmutableSet());
            Map<Symbol, Symbol> trace = IndexJoinOptimizer.IndexKeyTracer.trace(node.getIndexSource(), lookupSymbols);
            Preconditions.checkArgument((!trace.isEmpty() && lookupSymbols.containsAll(trace.keySet()) ? 1 : 0) != 0, (String)"Index lookup symbols are not traceable to index source: %s", (Object[])new Object[]{lookupSymbols});
            return null;
        }

        @Override
        public Void visitIndexSource(IndexSourceNode node, Set<Symbol> boundSymbols) {
            this.verifyUniqueId(node);
            ValidateDependenciesChecker.checkDependencies(node.getOutputSymbols(), node.getLookupSymbols(), "Lookup symbols must be part of output symbols", new Object[0]);
            ValidateDependenciesChecker.checkDependencies(node.getAssignments().keySet(), node.getOutputSymbols(), "Assignments must contain mappings for output symbols", new Object[0]);
            return null;
        }

        @Override
        public Void visitTableScan(TableScanNode node, Set<Symbol> boundSymbols) {
            this.verifyUniqueId(node);
            Preconditions.checkArgument((boolean)node.getAssignments().keySet().containsAll(node.getOutputSymbols()), (Object)"Assignments must contain mappings for output symbols");
            return null;
        }

        @Override
        public Void visitValues(ValuesNode node, Set<Symbol> boundSymbols) {
            this.verifyUniqueId(node);
            return null;
        }

        @Override
        public Void visitUnnest(UnnestNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            this.verifyUniqueId(node);
            ImmutableSet required = ImmutableSet.builder().addAll(node.getReplicateSymbols()).addAll(node.getUnnestSymbols().keySet()).build();
            ValidateDependenciesChecker.checkDependencies(source.getOutputSymbols(), (Collection)required, "Invalid node. Dependencies (%s) not in source plan output (%s)", new Object[]{required, source.getOutputSymbols()});
            return null;
        }

        @Override
        public Void visitRemoteSource(RemoteSourceNode node, Set<Symbol> boundSymbols) {
            this.verifyUniqueId(node);
            return null;
        }

        @Override
        public Void visitExchange(ExchangeNode node, Set<Symbol> boundSymbols) {
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanNode subplan = node.getSources().get(i);
                ValidateDependenciesChecker.checkDependencies(subplan.getOutputSymbols(), node.getInputs().get(i), "EXCHANGE subplan must provide all of the necessary symbols", new Object[0]);
                ValidateDependenciesChecker.checkDependencies(subplan.getOutputSymbols(), node.getInputs().get(i), "EXCHANGE subplan must provide all of the necessary symbols", new Object[0]);
                subplan.accept(this, boundSymbols);
            }
            ValidateDependenciesChecker.checkDependencies(node.getOutputSymbols(), node.getPartitioningScheme().getOutputLayout(), "EXCHANGE must provide all of the necessary symbols for partition function", new Object[0]);
            this.verifyUniqueId(node);
            return null;
        }

        @Override
        public Void visitTableWriter(TableWriterNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            this.verifyUniqueId(node);
            if (node.getSampleWeightSymbol().isPresent()) {
                Preconditions.checkArgument((boolean)source.getOutputSymbols().contains(node.getSampleWeightSymbol().get()), (String)"Invalid node. Sample weight symbol (%s) is not in source plan output (%s)", (Object[])new Object[]{node.getSampleWeightSymbol().get(), node.getSource().getOutputSymbols()});
            }
            return null;
        }

        @Override
        public Void visitDelete(DeleteNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            this.verifyUniqueId(node);
            Preconditions.checkArgument((boolean)source.getOutputSymbols().contains(node.getRowId()), (String)"Invalid node. Row ID symbol (%s) is not in source plan output (%s)", (Object[])new Object[]{node.getRowId(), node.getSource().getOutputSymbols()});
            return null;
        }

        @Override
        public Void visitMetadataDelete(MetadataDeleteNode node, Set<Symbol> boundSymbols) {
            this.verifyUniqueId(node);
            return null;
        }

        @Override
        public Void visitTableFinish(TableFinishNode node, Set<Symbol> boundSymbols) {
            node.getSource().accept(this, boundSymbols);
            this.verifyUniqueId(node);
            return null;
        }

        @Override
        public Void visitUnion(UnionNode node, Set<Symbol> boundSymbols) {
            return this.visitSetOperation(node, boundSymbols);
        }

        private Void visitSetOperation(SetOperationNode node, Set<Symbol> boundSymbols) {
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanNode subplan = node.getSources().get(i);
                ValidateDependenciesChecker.checkDependencies(subplan.getOutputSymbols(), node.sourceOutputLayout(i), "%s subplan must provide all of the necessary symbols", new Object[]{node.getClass().getSimpleName()});
                subplan.accept(this, boundSymbols);
            }
            this.verifyUniqueId(node);
            return null;
        }

        @Override
        public Void visitIntersect(IntersectNode node, Set<Symbol> boundSymbols) {
            return this.visitSetOperation(node, boundSymbols);
        }

        @Override
        public Void visitExcept(ExceptNode node, Set<Symbol> boundSymbols) {
            return this.visitSetOperation(node, boundSymbols);
        }

        @Override
        public Void visitEnforceSingleRow(EnforceSingleRowNode node, Set<Symbol> boundSymbols) {
            node.getSource().accept(this, boundSymbols);
            this.verifyUniqueId(node);
            return null;
        }

        @Override
        public Void visitAssignUniqueId(AssignUniqueId node, Set<Symbol> boundSymbols) {
            node.getSource().accept(this, boundSymbols);
            this.verifyUniqueId(node);
            return null;
        }

        @Override
        public Void visitApply(ApplyNode node, Set<Symbol> boundSymbols) {
            ImmutableSet subqueryCorrelation = ImmutableSet.builder().addAll(boundSymbols).addAll(node.getCorrelation()).build();
            node.getInput().accept(this, boundSymbols);
            node.getSubquery().accept(this, subqueryCorrelation);
            ValidateDependenciesChecker.checkDependencies(node.getInput().getOutputSymbols(), node.getCorrelation(), "APPLY input must provide all the necessary correlation symbols for subquery", new Object[0]);
            ValidateDependenciesChecker.checkDependencies(DependencyExtractor.extractUnique(node.getSubquery()), node.getCorrelation(), "not all APPLY correlation symbols are used in subquery", new Object[0]);
            this.verifyUniqueId(node);
            return null;
        }

        private void verifyUniqueId(PlanNode node) {
            PlanNodeId id = node.getId();
            Preconditions.checkArgument((!this.nodesById.containsKey(id) ? 1 : 0) != 0, (String)"Duplicate node id found %s between %s and %s", (Object[])new Object[]{node.getId(), node, this.nodesById.get(id)});
            this.nodesById.put(id, node);
        }

        private ImmutableSet<Symbol> createInputs(PlanNode source, Set<Symbol> boundSymbols) {
            return ImmutableSet.builder().addAll(source.getOutputSymbols()).addAll(boundSymbols).build();
        }
    }
}

