/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.util.ImmutableCollectors;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ExchangeNode
extends PlanNode {
    private final Type type;
    private final Scope scope;
    private final List<PlanNode> sources;
    private final PartitioningScheme partitioningScheme;
    private final List<List<Symbol>> inputs;

    @JsonCreator
    public ExchangeNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="type") Type type, @JsonProperty(value="scope") Scope scope, @JsonProperty(value="partitioningScheme") PartitioningScheme partitioningScheme, @JsonProperty(value="sources") List<PlanNode> sources, @JsonProperty(value="inputs") List<List<Symbol>> inputs) {
        super(id);
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(scope, "scope is null");
        Objects.requireNonNull(sources, "sources is null");
        Objects.requireNonNull(partitioningScheme, "partitioningScheme is null");
        Objects.requireNonNull(inputs, "inputs is null");
        Preconditions.checkArgument((boolean)inputs.stream().allMatch(inputSymbols -> inputSymbols.size() == partitioningScheme.getOutputLayout().size()), (Object)"Input symbols do not match output symbols");
        Preconditions.checkArgument((inputs.size() == sources.size() ? 1 : 0) != 0, (Object)"Must have same number of input lists as sources");
        for (int i = 0; i < inputs.size(); ++i) {
            Preconditions.checkArgument((boolean)sources.get(i).getOutputSymbols().containsAll((Collection)inputs.get(i)), (Object)"Source does not supply all required input symbols");
        }
        Preconditions.checkArgument((scope != Scope.LOCAL || partitioningScheme.getPartitioning().getArguments().stream().allMatch(Partitioning.ArgumentBinding::isVariable) ? 1 : 0) != 0, (Object)"local exchanges do not support constant partition function arguments");
        Preconditions.checkArgument((scope != Scope.REMOTE || type == Type.REPARTITION || !partitioningScheme.isReplicateNulls() ? 1 : 0) != 0, (Object)"Only REPARTITION can remotely replicate nulls");
        this.type = type;
        this.sources = sources;
        this.scope = scope;
        this.partitioningScheme = partitioningScheme;
        this.inputs = ImmutableList.copyOf(inputs);
    }

    public static ExchangeNode partitionedExchange(PlanNodeId id, Scope scope, PlanNode child, List<Symbol> partitioningColumns, Optional<Symbol> hashColumns) {
        return ExchangeNode.partitionedExchange(id, scope, child, partitioningColumns, hashColumns, false);
    }

    public static ExchangeNode partitionedExchange(PlanNodeId id, Scope scope, PlanNode child, List<Symbol> partitioningColumns, Optional<Symbol> hashColumns, boolean nullsReplicated) {
        return ExchangeNode.partitionedExchange(id, scope, child, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, partitioningColumns), child.getOutputSymbols(), hashColumns, nullsReplicated, Optional.empty()));
    }

    public static ExchangeNode partitionedExchange(PlanNodeId id, Scope scope, PlanNode child, PartitioningScheme partitioningScheme) {
        if (partitioningScheme.getPartitioning().getHandle().isSingleNode()) {
            return ExchangeNode.gatheringExchange(id, scope, child);
        }
        return new ExchangeNode(id, Type.REPARTITION, scope, partitioningScheme, (List<PlanNode>)ImmutableList.of((Object)child), (List<List<Symbol>>)ImmutableList.of(child.getOutputSymbols()));
    }

    public static ExchangeNode replicatedExchange(PlanNodeId id, Scope scope, PlanNode child) {
        return new ExchangeNode(id, Type.REPLICATE, scope, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), child.getOutputSymbols()), (List<PlanNode>)ImmutableList.of((Object)child), (List<List<Symbol>>)ImmutableList.of(child.getOutputSymbols()));
    }

    public static ExchangeNode gatheringExchange(PlanNodeId id, Scope scope, PlanNode child) {
        return new ExchangeNode(id, Type.GATHER, scope, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), child.getOutputSymbols()), (List<PlanNode>)ImmutableList.of((Object)child), (List<List<Symbol>>)ImmutableList.of(child.getOutputSymbols()));
    }

    public static ExchangeNode gatheringExchange(PlanNodeId id, Scope scope, List<Symbol> outputLayout, List<PlanNode> children) {
        return new ExchangeNode(id, Type.GATHER, scope, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), outputLayout), children, (List)children.stream().map(PlanNode::getOutputSymbols).collect(ImmutableCollectors.toImmutableList()));
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public Scope getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty
    public List<PlanNode> getSources() {
        return this.sources;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.partitioningScheme.getOutputLayout();
    }

    @JsonProperty
    public PartitioningScheme getPartitioningScheme() {
        return this.partitioningScheme;
    }

    @JsonProperty
    public List<List<Symbol>> getInputs() {
        return this.inputs;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitExchange(this, context);
    }

    public static enum Scope {
        LOCAL,
        REMOTE;

    }

    public static enum Type {
        GATHER,
        REPARTITION,
        REPLICATE;

    }
}

