/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class AssignUniqueId
extends PlanNode {
    private final PlanNode source;
    private final Symbol idColumn;

    @JsonCreator
    public AssignUniqueId(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="idColumn") Symbol unique) {
        super(id);
        this.source = Objects.requireNonNull(source, "source is null");
        this.idColumn = Objects.requireNonNull(unique, "idColumn is null");
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.source.getOutputSymbols()).add((Object)this.idColumn).build();
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public Symbol getIdColumn() {
        return this.idColumn;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitAssignUniqueId(this, context);
    }
}

