/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.google.common.collect.Iterables;

public final class ScalarQueryUtil {
    private ScalarQueryUtil() {
    }

    public static boolean isScalar(PlanNode node) {
        return node.accept(new IsScalarPlanVisitor(), null);
    }

    private static final class IsScalarPlanVisitor
    extends PlanVisitor<Void, Boolean> {
        private IsScalarPlanVisitor() {
        }

        @Override
        protected Boolean visitPlan(PlanNode node, Void context) {
            return false;
        }

        @Override
        public Boolean visitEnforceSingleRow(EnforceSingleRowNode node, Void context) {
            return true;
        }

        @Override
        public Boolean visitExchange(ExchangeNode node, Void context) {
            return node.getSources().size() == 1 && ((PlanNode)Iterables.getOnlyElement(node.getSources())).accept(this, null) != false;
        }

        @Override
        public Boolean visitProject(ProjectNode node, Void context) {
            return node.getSource().accept(this, null);
        }

        @Override
        public Boolean visitFilter(FilterNode node, Void context) {
            return node.getSource().accept(this, null);
        }
    }
}

