/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.WhenClause;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CanonicalizeExpressions
implements PlanOptimizer {
    public static Expression canonicalizeExpression(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new CanonicalizeExpressionRewriter(), (Expression)expression);
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(), plan);
    }

    private static class CanonicalizeExpressionRewriter
    extends ExpressionRewriter<Void> {
        private CanonicalizeExpressionRewriter() {
        }

        public Expression rewriteIsNotNullPredicate(IsNotNullPredicate node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression value = treeRewriter.rewrite(node.getValue(), (Object)context);
            return new NotExpression((Expression)new IsNullPredicate(value));
        }

        public Expression rewriteIfExpression(IfExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression condition = treeRewriter.rewrite(node.getCondition(), (Object)context);
            Expression trueValue = treeRewriter.rewrite(node.getTrueValue(), (Object)context);
            Optional<Expression> falseValue = node.getFalseValue().map(value -> treeRewriter.rewrite(value, (Object)context));
            return new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause(condition, trueValue)), falseValue);
        }

        public Expression rewriteCurrentTime(CurrentTime node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (node.getPrecision() != null) {
                throw new UnsupportedOperationException("not yet implemented: non-default precision");
            }
            switch (node.getType()) {
                case DATE: {
                    return new FunctionCall(QualifiedName.of((String)"current_date"), (List)ImmutableList.of());
                }
                case TIME: {
                    return new FunctionCall(QualifiedName.of((String)"current_time"), (List)ImmutableList.of());
                }
                case LOCALTIME: {
                    return new FunctionCall(QualifiedName.of((String)"localtime"), (List)ImmutableList.of());
                }
                case TIMESTAMP: {
                    return new FunctionCall(QualifiedName.of((String)"current_timestamp"), (List)ImmutableList.of());
                }
                case LOCALTIMESTAMP: {
                    return new FunctionCall(QualifiedName.of((String)"localtimestamp"), (List)ImmutableList.of());
                }
            }
            throw new UnsupportedOperationException("not yet implemented: " + node.getType());
        }

        public Expression rewriteExtract(Extract node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression value = treeRewriter.rewrite(node.getExpression(), (Object)context);
            switch (node.getField()) {
                case YEAR: {
                    return new FunctionCall(QualifiedName.of((String)"year"), (List)ImmutableList.of((Object)value));
                }
                case QUARTER: {
                    return new FunctionCall(QualifiedName.of((String)"quarter"), (List)ImmutableList.of((Object)value));
                }
                case MONTH: {
                    return new FunctionCall(QualifiedName.of((String)"month"), (List)ImmutableList.of((Object)value));
                }
                case WEEK: {
                    return new FunctionCall(QualifiedName.of((String)"week"), (List)ImmutableList.of((Object)value));
                }
                case DAY: 
                case DAY_OF_MONTH: {
                    return new FunctionCall(QualifiedName.of((String)"day"), (List)ImmutableList.of((Object)value));
                }
                case DAY_OF_WEEK: 
                case DOW: {
                    return new FunctionCall(QualifiedName.of((String)"day_of_week"), (List)ImmutableList.of((Object)value));
                }
                case DAY_OF_YEAR: 
                case DOY: {
                    return new FunctionCall(QualifiedName.of((String)"day_of_year"), (List)ImmutableList.of((Object)value));
                }
                case YEAR_OF_WEEK: 
                case YOW: {
                    return new FunctionCall(QualifiedName.of((String)"year_of_week"), (List)ImmutableList.of((Object)value));
                }
                case HOUR: {
                    return new FunctionCall(QualifiedName.of((String)"hour"), (List)ImmutableList.of((Object)value));
                }
                case MINUTE: {
                    return new FunctionCall(QualifiedName.of((String)"minute"), (List)ImmutableList.of((Object)value));
                }
                case SECOND: {
                    return new FunctionCall(QualifiedName.of((String)"second"), (List)ImmutableList.of((Object)value));
                }
                case TIMEZONE_MINUTE: {
                    return new FunctionCall(QualifiedName.of((String)"timezone_minute"), (List)ImmutableList.of((Object)value));
                }
                case TIMEZONE_HOUR: {
                    return new FunctionCall(QualifiedName.of((String)"timezone_hour"), (List)ImmutableList.of((Object)value));
                }
            }
            throw new UnsupportedOperationException("not yet implemented: " + node.getField());
        }
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private Rewriter() {
        }

        @Override
        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableMap assignments = ImmutableMap.copyOf((Map)Maps.transformValues(node.getAssignments(), CanonicalizeExpressions::canonicalizeExpression));
            return new ProjectNode(node.getId(), source, (Map<Symbol, Expression>)assignments);
        }

        @Override
        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            Expression canonicalized = CanonicalizeExpressions.canonicalizeExpression(node.getPredicate());
            if (canonicalized.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                return source;
            }
            return new FilterNode(node.getId(), source, canonicalized);
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            Expression originalConstraint = null;
            if (node.getOriginalConstraint() != null) {
                originalConstraint = CanonicalizeExpressions.canonicalizeExpression(node.getOriginalConstraint());
            }
            return new TableScanNode(node.getId(), node.getTable(), node.getOutputSymbols(), node.getAssignments(), node.getLayout(), node.getCurrentConstraint(), originalConstraint);
        }
    }
}

